/*
 * Decompiled with CFR 0.152.
 */
package no.dadobug;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import no.dadobug.EntryModule;
import no.dadobug.ExpectPlatformBox;
import no.dadobug.RegenerativeCore;
import no.dadobug.blocks.BlockLambda;
import no.dadobug.configs.BlockConfig;
import no.dadobug.configs.BlockConfigLambda;

public final class BedrockStack {
    private final RegistrySupplier<Block> ore;
    private final RegistrySupplier<Item> oreItem;
    private final RegistrySupplier<Item> core;

    public BedrockStack(RegistrySupplier<Block> ore, RegistrySupplier<Item> oreItem, RegistrySupplier<Item> core) {
        this.ore = ore;
        this.oreItem = oreItem;
        this.core = core;
    }

    public static BedrockStack BedrockStackAlteredBedrock(String name, BlockConfig config, BlockConfigLambda<Item.Properties> itemSettings, BlockConfigLambda<BlockBehaviour.Properties> blockSettings, boolean replaceWithBedrock, MutableComponent toolTip) {
        return new BedrockStack(name, "bedrock_", "", "regenerative_", "", config, itemSettings, blockSettings, replaceWithBedrock, toolTip, (cfg, blocksettings, replace) -> () -> ExpectPlatformBox.newBedrockOre((BlockBehaviour.Properties)blocksettings.get(config), replaceWithBedrock, config.XPmin, config.XPmax));
    }

    public static BedrockStack BedrockStackStandardOre(String name, BlockConfig config, BlockConfigLambda<Item.Properties> itemSettings, BlockConfigLambda<BlockBehaviour.Properties> blockSettings, boolean replaceWithBedrock, MutableComponent toolTip) {
        return new BedrockStack(name, "bedrock_", "_ore", "regenerative_", "", config, itemSettings, blockSettings, replaceWithBedrock, toolTip, (cfg, blocksettings, replace) -> () -> ExpectPlatformBox.newBedrockOre((BlockBehaviour.Properties)blocksettings.get(config), replaceWithBedrock, config.XPmin, config.XPmax));
    }

    public static BedrockStack BedrockStackFluidOre(String name, BlockConfig config, BlockConfigLambda<Item.Properties> itemSettings, BlockConfigLambda<BlockBehaviour.Properties> blockSettings, boolean replaceWithBedrock, MutableComponent toolTip, Fluid fluid) {
        return new BedrockStack(name, "bedrock_", "_ore", "regenerative_", "", config, itemSettings, blockSettings, replaceWithBedrock, toolTip, fluid);
    }

    public static BedrockStack BedrockStackFluidOre(String name, BlockConfig config, BlockConfigLambda<Item.Properties> itemSettings, BlockConfigLambda<BlockBehaviour.Properties> blockSettings, boolean replaceWithBedrock, MutableComponent toolTip, ItemStack bucketIn, Optional<SoundEvent> bucketSoundIn) {
        return new BedrockStack(name, "bedrock_", "_ore", "regenerative_", "", config, itemSettings, blockSettings, replaceWithBedrock, toolTip, bucketIn, bucketSoundIn);
    }

    public static BedrockStack BedrockStackXPLeak(String name, BlockConfig config, BlockConfigLambda<Item.Properties> itemSettings, BlockConfigLambda<BlockBehaviour.Properties> blockSettings, boolean replaceWithBedrock, MutableComponent toolTip) {
        return new BedrockStack(name, "bedrock_", "", "regenerative_", "", config, itemSettings, blockSettings, replaceWithBedrock, toolTip, (cfg, blocksettings, replace) -> () -> ExpectPlatformBox.newXPLeak((BlockBehaviour.Properties)blocksettings.get(config), replaceWithBedrock, config.XPmin, config.XPmax));
    }

    public BedrockStack(String name, String orePrefix, String oreSuffix, String corePrefix, String coreSuffix, BlockConfig config, BlockConfigLambda<Item.Properties> itemSettings, BlockConfigLambda<BlockBehaviour.Properties> blockSettings, boolean replaceWithBedrock, MutableComponent toolTip, BlockLambda<Supplier<Block>> block) {
        this.ore = EntryModule.BLOCKS.register(orePrefix + name + oreSuffix, block.get(config, blockSettings, replaceWithBedrock));
        this.oreItem = EntryModule.ITEMS.register(orePrefix + name + oreSuffix, () -> new BlockItem((Block)this.ore.get(), (Item.Properties)itemSettings.get(config)));
        this.core = EntryModule.ITEMS.register(corePrefix + name + coreSuffix, () -> new RegenerativeCore((Item.Properties)itemSettings.get(config), (Block)this.ore.get(), toolTip));
    }

    public BedrockStack(String name, String orePrefix, String oreSuffix, String corePrefix, String coreSuffix, BlockConfig config, BlockConfigLambda<Item.Properties> itemSettings, BlockConfigLambda<BlockBehaviour.Properties> blockSettings, boolean replaceWithBedrock, MutableComponent toolTip, Fluid fluid) {
        this.ore = EntryModule.BLOCKS.register(orePrefix + name + oreSuffix, () -> ExpectPlatformBox.newBedrockFluid((BlockBehaviour.Properties)blockSettings.get(config), replaceWithBedrock, fluid, config.XPmin, config.XPmax));
        this.oreItem = EntryModule.ITEMS.register(orePrefix + name + oreSuffix, () -> new BlockItem((Block)this.ore.get(), (Item.Properties)itemSettings.get(config)));
        this.core = EntryModule.ITEMS.register(corePrefix + name + coreSuffix, () -> new RegenerativeCore((Item.Properties)itemSettings.get(config), (Block)this.ore.get(), toolTip));
    }

    public BedrockStack(String name, String orePrefix, String oreSuffix, String corePrefix, String coreSuffix, BlockConfig config, BlockConfigLambda<Item.Properties> itemSettings, BlockConfigLambda<BlockBehaviour.Properties> blockSettings, boolean replaceWithBedrock, MutableComponent toolTip, ItemStack bucketIn, Optional<SoundEvent> bucketSoundIn) {
        this.ore = EntryModule.BLOCKS.register(orePrefix + name + oreSuffix, () -> ExpectPlatformBox.newBedrockFluid((BlockBehaviour.Properties)blockSettings.get(config), replaceWithBedrock, bucketIn, bucketSoundIn, config.XPmin, config.XPmax));
        this.oreItem = EntryModule.ITEMS.register(orePrefix + name + oreSuffix, () -> new BlockItem((Block)this.ore.get(), (Item.Properties)itemSettings.get(config)));
        this.core = EntryModule.ITEMS.register(corePrefix + name + coreSuffix, () -> new RegenerativeCore((Item.Properties)itemSettings.get(config), (Block)this.ore.get(), toolTip));
    }

    public RegistrySupplier<Block> ore() {
        return this.ore;
    }

    public RegistrySupplier<Item> oreItem() {
        return this.oreItem;
    }

    public RegistrySupplier<Item> core() {
        return this.core;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BedrockStack that = (BedrockStack)obj;
        return Objects.equals(this.ore, that.ore) && Objects.equals(this.oreItem, that.oreItem) && Objects.equals(this.core, that.core);
    }

    public int hashCode() {
        return Objects.hash(this.ore, this.oreItem, this.core);
    }

    public String toString() {
        return "BedrockStack[ore=" + this.ore + ", oreItem=" + this.oreItem + ", core=" + this.core + "]";
    }
}

