/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class ShapedRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object output;
    public final int count;
    public final Object[] input;

    public ShapedRecipeSerializer(ResourceLocation key, Object output, int count, Object ... input) {
        this(key, "", output, count, input);
    }

    public ShapedRecipeSerializer(ResourceLocation key, String group, Object output, int count, Object ... input) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.output = output;
        this.count = count;
        this.input = Objects.requireNonNull(input);
    }

    @Override
    public JsonElement get() {
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        boolean width = false;
        ArrayList<String> pattern = new ArrayList<String>();
        int idx = 0;
        if (this.input[idx] instanceof String[]) {
            String[] parts;
            for (String s : parts = (String[])this.input[idx++]) {
                if (!pattern.isEmpty() && s.length() != ((String)pattern.get(0)).length()) {
                    throw new IllegalArgumentException("Invalid pattern in recipe " + this.key + "Pattern must be the same width on every line");
                }
                pattern.add(s);
            }
        } else {
            while (this.input[idx] instanceof String) {
                String s = (String)this.input[idx++];
                pattern.add(s);
            }
        }
        HashMap<Character, Ingredient> keyMap = new HashMap<Character, Ingredient>();
        while (idx < this.input.length) {
            Character chr = (Character)this.input[idx];
            Object in = this.input[idx + 1];
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(in);
            if (keyMap.containsKey(chr)) {
                throw new IllegalArgumentException("Invalid key entry in recipe " + this.key + ": Symbol '" + chr + "' is defined twice");
            }
            if (' ' == chr.charValue()) {
                throw new IllegalArgumentException("Invalid key entry in recipe " + this.key + ": Symbol ' ' is reserved");
            }
            if (ing == EmptyIngredient.INSTANCE) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
            }
            keyMap.put(chr, ing);
            idx += 2;
        }
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("No pattern is defined for shaped recipe " + this.key);
        }
        HashSet set = new HashSet(keyMap.keySet());
        for (String str : pattern) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!keyMap.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalArgumentException("Pattern in recipe " + this.key + " uses undefined symbol '" + c + "'");
                }
                set.remove(Character.valueOf(c));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalArgumentException("Ingredients are defined but not used in pattern for recipe " + this.key);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        JsonArray patternJson = new JsonArray();
        for (String str : pattern) {
            patternJson.add(str);
        }
        json.add("pattern", (JsonElement)patternJson);
        JsonObject keyJson = new JsonObject();
        for (Map.Entry entry : keyMap.entrySet()) {
            keyJson.add(String.valueOf(entry.getKey()), ((Ingredient)entry.getValue()).m_43942_());
        }
        json.add("key", (JsonElement)keyJson);
        json.add("result", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        return json;
    }
}

