/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.materials;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.materials.Material;
import thelm.jaopca.utils.ApiImpl;

public class MaterialHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TreeMap<String, Material> MATERIALS = new TreeMap();
    static boolean clientTagsBound = false;

    private MaterialHandler() {
    }

    public static Map<String, Material> getMaterialMap() {
        return MATERIALS;
    }

    public static Collection<Material> getMaterials() {
        return MATERIALS.values();
    }

    public static Material getMaterial(String name) {
        return MATERIALS.get(name);
    }

    public static boolean containsMaterial(String name) {
        return MATERIALS.containsKey(name);
    }

    public static void findMaterials() {
        Material material;
        MATERIALS.clear();
        Set tags = ApiImpl.INSTANCE.getItemTags().stream().map(ResourceLocation::toString).collect(Collectors.toCollection(TreeSet::new));
        TreeSet allMaterials = new TreeSet();
        LinkedHashSet ingots = ConfigHandler.ingot ? MaterialHandler.findItemTagNamesWithPaths(tags, "forge:ingots/", "forge:raw_materials/", "forge:ores/") : new LinkedHashSet();
        ingots.removeAll(ConfigHandler.GEM_OVERRIDES);
        ingots.removeAll(ConfigHandler.CRYSTAL_OVERRIDES);
        ingots.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(ingots);
        LinkedHashSet ingotsLegacy = ConfigHandler.ingotLegacy ? MaterialHandler.findItemTagNamesWithPaths(tags, "forge:ingots/", "forge:ores/") : new LinkedHashSet();
        ingotsLegacy.removeAll(allMaterials);
        ingotsLegacy.removeAll(ConfigHandler.GEM_OVERRIDES);
        ingotsLegacy.removeAll(ConfigHandler.CRYSTAL_OVERRIDES);
        ingotsLegacy.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(ingotsLegacy);
        LinkedHashSet gems = ConfigHandler.gem ? MaterialHandler.findItemTagNamesWithPaths(tags, "forge:gems/", "forge:ores/") : new LinkedHashSet();
        gems.removeAll(allMaterials);
        gems.removeAll(ConfigHandler.CRYSTAL_OVERRIDES);
        gems.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(gems);
        LinkedHashSet crystals = ConfigHandler.crystal ? MaterialHandler.findItemTagNamesWithPaths(tags, "forge:crystals/", "forge:ores/") : new LinkedHashSet();
        crystals.removeAll(allMaterials);
        crystals.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(crystals);
        LinkedHashSet dusts = ConfigHandler.dust ? MaterialHandler.findItemTagNamesWithPaths(tags, "forge:dusts/", "forge:ores/") : new LinkedHashSet();
        dusts.removeAll(allMaterials);
        allMaterials.addAll(dusts);
        LinkedHashSet ingotsPlain = ConfigHandler.ingotPlain ? MaterialHandler.findItemTagNamesWithPaths(tags, "forge:ingots/", new String[0]) : new LinkedHashSet();
        ingotsPlain.removeAll(allMaterials);
        ingotsPlain.removeAll(ConfigHandler.GEM_OVERRIDES);
        ingotsPlain.removeAll(ConfigHandler.CRYSTAL_OVERRIDES);
        ingotsPlain.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(ingotsPlain);
        LinkedHashSet gemsPlain = ConfigHandler.gemPlain ? MaterialHandler.findItemTagNamesWithPaths(tags, "forge:gems/", new String[0]) : new LinkedHashSet();
        gemsPlain.removeAll(allMaterials);
        gemsPlain.removeAll(ConfigHandler.CRYSTAL_OVERRIDES);
        gemsPlain.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(gemsPlain);
        LinkedHashSet crystalsPlain = ConfigHandler.crystalPlain ? MaterialHandler.findItemTagNamesWithPaths(tags, "forge:crystals/", new String[0]) : new LinkedHashSet();
        crystalsPlain.removeAll(allMaterials);
        crystalsPlain.removeAll(ConfigHandler.DUST_OVERRIDES);
        allMaterials.addAll(crystalsPlain);
        LinkedHashSet dustsPlain = ConfigHandler.dustPlain ? MaterialHandler.findItemTagNamesWithPaths(tags, "forge:dusts/", new String[0]) : new LinkedHashSet();
        dustsPlain.removeAll(allMaterials);
        allMaterials.addAll(dustsPlain);
        for (String name : ingots) {
            material = new Material(name, MaterialType.INGOT);
            MATERIALS.put(name, material);
            LOGGER.debug("Added ingot material {}", (Object)name);
        }
        for (String name : ingotsLegacy) {
            material = new Material(name, MaterialType.INGOT_LEGACY);
            MATERIALS.put(name, material);
            LOGGER.debug("Added legacy ingot material {}", (Object)name);
        }
        for (String name : gems) {
            material = new Material(name, MaterialType.GEM);
            MATERIALS.put(name, material);
            LOGGER.debug("Added gem material {}", (Object)name);
        }
        for (String name : crystals) {
            material = new Material(name, MaterialType.CRYSTAL);
            MATERIALS.put(name, material);
            LOGGER.debug("Added crystal material {}", (Object)name);
        }
        for (String name : dusts) {
            material = new Material(name, MaterialType.DUST);
            MATERIALS.put(name, material);
            LOGGER.debug("Added dust material {}", (Object)name);
        }
        for (String name : ingotsPlain) {
            material = new Material(name, MaterialType.INGOT_PLAIN);
            MATERIALS.put(name, material);
            LOGGER.debug("Added plain ingot material {}", (Object)name);
        }
        for (String name : gemsPlain) {
            material = new Material(name, MaterialType.GEM_PLAIN);
            MATERIALS.put(name, material);
            LOGGER.debug("Added plain gem material {}", (Object)name);
        }
        for (String name : crystalsPlain) {
            material = new Material(name, MaterialType.CRYSTAL_PLAIN);
            MATERIALS.put(name, material);
            LOGGER.debug("Added plain crystal material {}", (Object)name);
        }
        for (String name : dustsPlain) {
            material = new Material(name, MaterialType.DUST_PLAIN);
            MATERIALS.put(name, material);
            LOGGER.debug("Added plain dust material {}", (Object)name);
        }
        LOGGER.info("Added {} materials", (Object)MATERIALS.size());
    }

    public static void setClientTagsBound(boolean updated) {
        clientTagsBound = updated;
    }

    protected static Set<String> findItemTagNamesWithPaths(Set<String> tags, String mainPath, String ... paths) {
        TreeSet<String> ret = new TreeSet<String>();
        for (String tag : tags) {
            String name;
            if (!tag.startsWith(mainPath) || (name = tag.substring(mainPath.length())).contains("/")) continue;
            if (!Arrays.stream(paths).map(path -> path + name).allMatch(tags::contains)) continue;
            ret.add(name);
        }
        return ret;
    }
}

