/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.localization;

import java.util.Arrays;
import java.util.Map;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.localization.ILocalizer;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class LocalizerDefault
implements ILocalizer {
    public static final LocalizerDefault INSTANCE = new LocalizerDefault();

    private LocalizerDefault() {
    }

    @Override
    public MutableComponent localizeMaterialForm(String formTranslationKey, IMaterial material, String overrideKey) {
        Language languageMap = Language.m_128107_();
        Map<String, String> locMap = ApiImpl.INSTANCE.currentMaterialLocalizationMap();
        if (languageMap.m_6722_(overrideKey)) {
            return new TranslatableComponent(overrideKey);
        }
        if (locMap.containsKey(overrideKey)) {
            return new TextComponent(locMap.get(overrideKey));
        }
        String materialKey = "jaopca.material." + material.getName();
        String materialName = languageMap.m_6722_(materialKey) ? languageMap.m_6834_(materialKey) : (locMap.containsKey(materialKey) ? locMap.get(materialKey) : LocalizerDefault.splitAndCapitalize(material.getName()));
        if (languageMap.m_6722_(formTranslationKey) || !locMap.containsKey(formTranslationKey)) {
            return new TranslatableComponent(formTranslationKey, new Object[]{materialName});
        }
        return new TextComponent(String.format(locMap.get(overrideKey), materialName));
    }

    public static String splitAndCapitalize(String underscore) {
        return Arrays.stream(StringUtils.split((String)underscore, (char)'_')).map(StringUtils::capitalize).reduce((s1, s2) -> s1 + " " + s2).orElse("");
    }
}

