/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.data;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.modules.ModuleHandler;
import thelm.jaopca.resources.InMemoryResourcePack;

public class DataInjector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ListMultimap<ResourceLocation, ResourceLocation> BLOCK_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, ResourceLocation> ITEM_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, ResourceLocation> FLUID_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, ResourceLocation> ENTITY_TYPE_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final TreeMap<ResourceLocation, IRecipeSerializer> RECIPES_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<LootTable>> LOOT_TABLES_INJECT = new TreeMap();
    private static final TreeMap<ResourceLocation, Supplier<Advancement.Builder>> ADVANCEMENTS_INJECT = new TreeMap();
    private static final Gson GSON = Deserializers.m_78800_().create();

    public static boolean registerBlockTag(ResourceLocation location, ResourceLocation blockLocation) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(blockLocation);
        return BLOCK_TAGS_INJECT.put((Object)location, (Object)blockLocation);
    }

    public static boolean registerItemTag(ResourceLocation location, ResourceLocation itemLocation) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(itemLocation);
        return ITEM_TAGS_INJECT.put((Object)location, (Object)itemLocation);
    }

    public static boolean registerFluidTag(ResourceLocation location, ResourceLocation fluidLocation) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(fluidLocation);
        return FLUID_TAGS_INJECT.put((Object)location, (Object)fluidLocation);
    }

    public static boolean registerEntityTypeTag(ResourceLocation location, ResourceLocation entityTypeLocation) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(entityTypeLocation);
        return ENTITY_TYPE_TAGS_INJECT.put((Object)location, (Object)entityTypeLocation);
    }

    public static boolean registerRecipe(ResourceLocation location, IRecipeSerializer recipeSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(recipeSupplier);
        return RECIPES_INJECT.putIfAbsent(location, recipeSupplier) == null;
    }

    public static boolean registerLootTable(ResourceLocation location, Supplier<LootTable> lootTableSupplier) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(lootTableSupplier);
        return LOOT_TABLES_INJECT.putIfAbsent(location, lootTableSupplier) == null;
    }

    public static boolean registerAdvancement(ResourceLocation location, Supplier<Advancement.Builder> advancementBuilder) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(advancementBuilder);
        return ADVANCEMENTS_INJECT.putIfAbsent(location, advancementBuilder) == null;
    }

    public static Set<ResourceLocation> getInjectBlockTags() {
        return BLOCK_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectItemTags() {
        return ITEM_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectFluidTags() {
        return FLUID_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectEntityTypeTags() {
        return ENTITY_TYPE_TAGS_INJECT.keySet();
    }

    public static Set<ResourceLocation> getInjectRecipes() {
        return RECIPES_INJECT.navigableKeySet();
    }

    public static Set<ResourceLocation> getInjectLootTables() {
        return LOOT_TABLES_INJECT.navigableKeySet();
    }

    public static Set<ResourceLocation> getInjectAdvancements() {
        return ADVANCEMENTS_INJECT.navigableKeySet();
    }

    public static void injectRecipes(Map<ResourceLocation, JsonElement> recipeMap) {
        TreeMap<ResourceLocation, JsonElement> recipesToInject = new TreeMap<ResourceLocation, JsonElement>();
        RECIPES_INJECT.forEach((key, supplier) -> {
            if (recipeMap.containsKey(key)) {
                LOGGER.debug("Duplicate recipe ignored with ID {}", key);
                return;
            }
            JsonElement recipe = null;
            try {
                recipe = (JsonElement)supplier.get();
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Recipe with ID {} received invalid arguments: {}", key, (Object)e.getMessage());
                return;
            }
            catch (Throwable e) {
                LOGGER.warn("Recipe with ID {} errored", key, (Object)e);
                return;
            }
            if (recipe == null) {
                LOGGER.debug("Recipe with ID {} returned null", key);
                return;
            }
            recipesToInject.put((ResourceLocation)key, recipe);
            LOGGER.debug("Injected recipe with ID {}", key);
        });
        recipesToInject.forEach(recipeMap::putIfAbsent);
        LOGGER.info("Injected {} recipes, {} recipes total", (Object)recipesToInject.size(), (Object)recipeMap.size());
    }

    public static class PackFinder
    implements RepositorySource {
        public static final PackFinder INSTANCE = new PackFinder();

        public void m_7686_(Consumer<Pack> packConsumer, Pack.PackConstructor packConstructor) {
            Pack packInfo = Pack.m_10430_((String)"inmemory:jaopca", (boolean)true, () -> {
                InMemoryResourcePack pack = new InMemoryResourcePack("inmemory:jaopca", true);
                BLOCK_TAGS_INJECT.asMap().forEach((location, locations) -> {
                    Tag.Builder builder = Tag.Builder.m_13304_();
                    locations.forEach(l -> builder.m_144379_(l, "inmemory:jaopca"));
                    pack.putJson(PackType.SERVER_DATA, new ResourceLocation(location.m_135827_(), "tags/blocks/" + location.m_135815_() + ".json"), (JsonElement)builder.m_13334_());
                });
                ITEM_TAGS_INJECT.asMap().forEach((location, locations) -> {
                    Tag.Builder builder = Tag.Builder.m_13304_();
                    locations.forEach(l -> builder.m_144379_(l, "inmemory:jaopca"));
                    pack.putJson(PackType.SERVER_DATA, new ResourceLocation(location.m_135827_(), "tags/items/" + location.m_135815_() + ".json"), (JsonElement)builder.m_13334_());
                });
                FLUID_TAGS_INJECT.asMap().forEach((location, locations) -> {
                    Tag.Builder builder = Tag.Builder.m_13304_();
                    locations.forEach(l -> builder.m_144379_(l, "inmemory:jaopca"));
                    pack.putJson(PackType.SERVER_DATA, new ResourceLocation(location.m_135827_(), "tags/fluids/" + location.m_135815_() + ".json"), (JsonElement)builder.m_13334_());
                });
                ENTITY_TYPE_TAGS_INJECT.asMap().forEach((location, locations) -> {
                    Tag.Builder builder = Tag.Builder.m_13304_();
                    locations.forEach(l -> builder.m_144379_(l, "inmemory:jaopca"));
                    pack.putJson(PackType.SERVER_DATA, new ResourceLocation(location.m_135827_(), "tags/entity_types/" + location.m_135815_() + ".json"), (JsonElement)builder.m_13334_());
                });
                LOOT_TABLES_INJECT.forEach((location, supplier) -> pack.putJson(PackType.SERVER_DATA, new ResourceLocation(location.m_135827_(), "loot_tables/" + location.m_135815_() + ".json"), GSON.toJsonTree(supplier.get())));
                ADVANCEMENTS_INJECT.forEach((location, supplier) -> pack.putJson(PackType.SERVER_DATA, new ResourceLocation(location.m_135827_(), "advancements/" + location.m_135815_() + ".json"), (JsonElement)((Advancement.Builder)supplier.get()).m_138400_()));
                ModuleHandler.onCreateDataPack(pack);
                return pack;
            }, (Pack.PackConstructor)packConstructor, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_);
            if (packInfo != null) {
                packConsumer.accept(packInfo);
            }
        }
    }
}

