/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct;

import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import thelm.jaopca.compat.tconstruct.recipes.CastingBasinRecipeSerializer;
import thelm.jaopca.compat.tconstruct.recipes.CastingTableRecipeSerializer;
import thelm.jaopca.compat.tconstruct.recipes.MeltingRecipeSerializer;
import thelm.jaopca.compat.tconstruct.recipes.OreMeltingRecipeSerializer;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class TConstructHelper {
    public static final TConstructHelper INSTANCE = new TConstructHelper();

    private TConstructHelper() {
    }

    public FluidIngredient getFluidIngredient(Object obj, int amount) {
        return (FluidIngredient)this.getFluidIngredientResolved(obj, amount).getLeft();
    }

    public Pair<FluidIngredient, Set<Fluid>> getFluidIngredientResolved(Object obj, int amount) {
        FluidIngredient ing = null;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        MiscHelper helper = MiscHelper.INSTANCE;
        if (obj instanceof Supplier) {
            Pair<FluidIngredient, Set<Fluid>> pair = this.getFluidIngredientResolved(((Supplier)obj).get(), amount);
            ing = (FluidIngredient)pair.getLeft();
            fluids.addAll((Collection)pair.getRight());
        } else if (obj instanceof FluidIngredient) {
            ing = (FluidIngredient)obj;
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = FluidIngredient.of(MiscHelper.INSTANCE.getFluidTagKey(location), (int)amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = FluidIngredient.of(MiscHelper.INSTANCE.getFluidTagKey(location), (int)amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = FluidIngredient.of((TagKey)key, (int)amount);
            fluids.addAll(helper.getFluidTagValues(key.f_203868_()));
        } else if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            ing = FluidIngredient.of((FluidStack)stack);
            fluids.add(stack.getFluid());
        } else if (obj instanceof FluidStack[]) {
            FluidStack[] stacks = (FluidStack[])obj;
            ing = FluidIngredient.of((FluidIngredient[])((FluidIngredient[])Arrays.stream(stacks).map(FluidIngredient::of).toArray(FluidIngredient[]::new)));
            Arrays.stream(stacks).map(FluidStack::getFluid).forEach(fluids::add);
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            ing = FluidIngredient.of((Fluid)fluid, (int)amount);
            fluids.add(fluid);
        } else if (obj instanceof Fluid[]) {
            Fluid[] fluidz = (Fluid[])obj;
            ing = FluidIngredient.of((FluidIngredient[])((FluidIngredient[])Arrays.stream(fluidz).map(g -> FluidIngredient.of((Fluid)g, (int)amount)).toArray(FluidIngredient[]::new)));
            Collections.addAll(fluids, fluidz);
        } else if (obj instanceof JsonElement) {
            ing = FluidIngredient.deserialize((JsonElement)((JsonElement)obj), (String)"ingredient");
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        }
        return Pair.of((Object)(fluids.isEmpty() ? null : ing), fluids);
    }

    public ItemOutput getItemOutput(Object obj, int count) {
        return (ItemOutput)this.getItemOutputResolved(obj, count).getLeft();
    }

    public Pair<ItemOutput, Set<Item>> getItemOutputResolved(Object obj, int count) {
        ItemOutput out = ItemOutput.fromStack((ItemStack)ItemStack.f_41583_);
        HashSet<Item> items = new HashSet<Item>();
        if (obj instanceof Supplier) {
            Pair<ItemOutput, Set<Item>> pair = this.getItemOutputResolved(((Supplier)obj).get(), count);
            out = (ItemOutput)pair.getLeft();
            items.addAll((Collection)pair.getRight());
        } else if (obj instanceof ItemOutput) {
            out = (ItemOutput)obj;
            items.addAll(ForgeRegistries.ITEMS.getValues());
        } else if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            out = ItemOutput.fromStack((ItemStack)stack);
            items.add(stack.m_41720_());
        } else if (obj instanceof ItemLike) {
            ItemLike item = (ItemLike)obj;
            out = ItemOutput.fromItem((ItemLike)item, (int)count);
            items.add(item.m_5456_());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            out = ItemOutput.fromTag(MiscHelper.INSTANCE.getItemTagKey(location), (int)count);
            items.addAll(MiscHelper.INSTANCE.getItemTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            out = ItemOutput.fromTag(MiscHelper.INSTANCE.getItemTagKey(location), (int)count);
            items.addAll(MiscHelper.INSTANCE.getItemTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            out = ItemOutput.fromTag((TagKey)key, (int)count);
            items.addAll(MiscHelper.INSTANCE.getItemTagValues(key.f_203868_()));
        }
        return Pair.of((Object)(items.isEmpty() ? null : out), items);
    }

    public boolean registerOreMeltingRecipe(ResourceLocation key, String group, Object input, Object output, int outputAmount, int rate, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> time, Object ... byproducts) {
        return ApiImpl.INSTANCE.registerRecipe(key, new OreMeltingRecipeSerializer(key, group, input, output, outputAmount, rate, temperature, time, byproducts));
    }

    public boolean registerOreMeltingRecipe(ResourceLocation key, Object input, Object output, int outputAmount, int rate, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> time, Object ... byproducts) {
        return ApiImpl.INSTANCE.registerRecipe(key, new OreMeltingRecipeSerializer(key, input, output, outputAmount, rate, temperature, time, byproducts));
    }

    public boolean registerMeltingRecipe(ResourceLocation key, String group, Object input, Object output, int outputAmount, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> time, Object ... byproducts) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeSerializer(key, group, input, output, outputAmount, temperature, time, byproducts));
    }

    public boolean registerMeltingRecipe(ResourceLocation key, Object input, Object output, int outputAmount, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> time, Object ... byproducts) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeSerializer(key, input, output, outputAmount, temperature, time, byproducts));
    }

    public boolean registerCastingTableRecipe(ResourceLocation key, String group, Object cast, Object input, int inputAmount, Object output, int outputCount, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingTableRecipeSerializer(key, group, cast, input, inputAmount, output, outputCount, time, consumeCast, switchSlots));
    }

    public boolean registerCastingTableRecipe(ResourceLocation key, Object cast, Object input, int inputAmount, Object output, int outputCount, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingTableRecipeSerializer(key, cast, input, inputAmount, output, outputCount, time, consumeCast, switchSlots));
    }

    public boolean registerCastingBasinRecipe(ResourceLocation key, String group, Object cast, Object input, int inputAmount, Object output, int outputCount, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingBasinRecipeSerializer(key, group, cast, input, inputAmount, output, outputCount, time, consumeCast, switchSlots));
    }

    public boolean registerCastingBasinRecipe(ResourceLocation key, Object cast, Object input, int inputAmount, Object output, int outputCount, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingBasinRecipeSerializer(key, cast, input, inputAmount, output, outputCount, time, consumeCast, switchSlots));
    }
}

