/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.integrateddynamics;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.integrateddynamics.IntegratedDynamicsHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"integrateddynamics"})
public class IntegratedDynamicsNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("coal", "diamond", "emerald", "lapis", "quartz", "redstone"));

    @Override
    public String getName() {
        return "integrateddynamics_non_ingot";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        IntegratedDynamicsHelper helper = IntegratedDynamicsHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            if (material.getType() != MaterialType.DUST) {
                helper.registerSqueezerRecipe(new ResourceLocation("jaopca", "integrateddynamics.ore_to_material." + material.getName()), oreLocation, new Object[]{materialLocation, 1, Float.valueOf(1.0f), materialLocation, 1, Float.valueOf(0.75f)});
                helper.registerMechanicalSqueezerRecipe(new ResourceLocation("jaopca", "integrateddynamics.ore_to_material_mechanical." + material.getName()), oreLocation, new Object[]{materialLocation, 2, Float.valueOf(1.0f), materialLocation, 1, Float.valueOf(0.5f)}, 40);
                continue;
            }
            helper.registerSqueezerRecipe(new ResourceLocation("jaopca", "integrateddynamics.ore_to_material." + material.getName()), oreLocation, new Object[]{materialLocation, 6, Float.valueOf(1.0f), materialLocation, 2, Float.valueOf(0.5f), materialLocation, 2, Float.valueOf(0.5f)});
            helper.registerMechanicalSqueezerRecipe(new ResourceLocation("jaopca", "integrateddynamics.ore_to_material_mechanical." + material.getName()), oreLocation, new Object[]{materialLocation, 10, Float.valueOf(1.0f), materialLocation, 2, Float.valueOf(0.5f)}, 40);
        }
    }
}

