/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.exnihilosequentia;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.exnihilosequentia.ExNihiloSequentiaHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"exnihilosequentia"})
public class ExNihiloSequentiaModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "copper", "gold", "iron", "lead", "nickel", "platinum", "silver", "tin", "uranium", "zinc"));
    private static boolean registerOreTags = true;
    private Map<IMaterial, IDynamicSpecConfig> configs;
    private final IForm pieceForm = ApiImpl.INSTANCE.newForm(this, "exnihilosequentia_pieces", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT).setSecondaryName("exnihilosequentia:pieces").setDefaultMaterialBlacklist(BLACKLIST);
    private final IForm chunkForm = ApiImpl.INSTANCE.newForm(this, "exnihilosequentia_chunks", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT).setSecondaryName("exnihilosequentia:chunks").setDefaultMaterialBlacklist(BLACKLIST);

    @Override
    public String getName() {
        return "exnihilosequentia";
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(ApiImpl.INSTANCE.newFormRequest(this, this.pieceForm, this.chunkForm));
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        registerOreTags = config.getDefinedBoolean("tags.registerOreTags", registerOreTags, "Should the module register ore tags for chunks.");
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        ExNihiloSequentiaHelper helper = ExNihiloSequentiaHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        Item gravel = Items.f_41832_;
        Item crushedNetherrack = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("exnihilosequentia:crushed_netherrack"));
        Item crushedEndstone = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("exnihilosequentia:crushed_end_stone"));
        for (IMaterial material : this.pieceForm.getMaterials()) {
            IItemInfo pieceInfo = itemFormType.getMaterialFormInfo(this.pieceForm, material);
            IDynamicSpecConfig config = this.configs.get(material);
            boolean sieveGravel = config.getDefinedBoolean("exnihilosequentia.sieveGravel", true, "Should gravel sieve recipes be added.");
            boolean sieveCrushedNetherrack = config.getDefinedBoolean("exnihilosequentia.sieveCrushedNetherrack", false, "Should crushed netherrack sieve recipes be added.");
            boolean sieveCrushedEndstone = config.getDefinedBoolean("exnihilosequentia.sieveCrushedEndstone", false, "Should crushed end stone sieve recipes be added.");
            float sieveFlintChance = config.getDefinedFloat("exnihilosequentia.sieveFlintChance", 0.05f, 0.0f, 1.0f, "The output chance of the sieve recipes added using a flint mesh.");
            float sieveIronChance = config.getDefinedFloat("exnihilosequentia.sieveIronChance", 0.075f, 0.0f, 1.0f, "The output chance of the sieve recipes added using an iron mesh.");
            float sieveDiamondChance = config.getDefinedFloat("exnihilosequentia.sieveDiamondChance", 0.1f, 0.0f, 1.0f, "The output chance of the sieve recipes added using a diamond mesh.");
            if (sieveGravel) {
                helper.registerSieveRecipe(new ResourceLocation("jaopca", "exnihilosequentia.piece_gravel." + material.getName()), gravel, pieceInfo, 1, new Number[]{2, Float.valueOf(sieveFlintChance), 3, Float.valueOf(sieveIronChance), 4, Float.valueOf(sieveDiamondChance)}, false);
            }
            if (sieveCrushedNetherrack) {
                helper.registerSieveRecipe(new ResourceLocation("jaopca", "exnihilosequentia.piece_crushed_netherrack." + material.getName()), crushedNetherrack, pieceInfo, 1, new Number[]{2, Float.valueOf(sieveFlintChance), 3, Float.valueOf(sieveIronChance), 4, Float.valueOf(sieveDiamondChance)}, false);
            }
            if (!sieveCrushedEndstone) continue;
            helper.registerSieveRecipe(new ResourceLocation("jaopca", "exnihilosequentia.piece_crushed_end_stone." + material.getName()), crushedEndstone, pieceInfo, 1, new Number[]{2, Float.valueOf(sieveFlintChance), 3, Float.valueOf(sieveIronChance), 4, Float.valueOf(sieveDiamondChance)}, false);
        }
        for (IMaterial material : this.chunkForm.getMaterials()) {
            ResourceLocation pieceLocation = miscHelper.getTagLocation("exnihilosequentia:pieces", material.getName());
            IItemInfo chunkInfo = ItemFormType.INSTANCE.getMaterialFormInfo(this.chunkForm, material);
            ResourceLocation chunkLocation = miscHelper.getTagLocation("exnihilosequentia:chunks", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ((JAOPCAApi)api).registerShapelessRecipe(new ResourceLocation("jaopca", "exnihilosequentia.piece_to_chunk." + material.getName()), chunkInfo, 1, pieceLocation, pieceLocation, pieceLocation, pieceLocation);
            ((JAOPCAApi)api).registerSmeltingRecipe(new ResourceLocation("jaopca", "exnihilosequentia.chunk_to_material." + material.getName()), chunkLocation, materialLocation, 1, 0.7f, 200);
            ((JAOPCAApi)api).registerBlastingRecipe(new ResourceLocation("jaopca", "exnihilosequentia.chunk_to_material_blasting." + material.getName()), chunkLocation, materialLocation, 1, 0.7f, 100);
            if (!registerOreTags) continue;
            ((JAOPCAApi)api).registerItemTag(miscHelper.getTagLocation("ores", material.getName()), chunkInfo.m_5456_());
        }
    }

    static {
        if (ModList.get().isLoaded("exnihilomekanism")) {
            Collections.addAll(BLACKLIST, "osmium");
        }
    }
}

