/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.cyclic.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class CrusherRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final int secondChance;
    public final int time;
    public final int power;

    public CrusherRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, int time, int power) {
        this(key, input, output, outputCount, ItemStack.f_41583_, 0, 0, time, power);
    }

    public CrusherRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, Object secondOutput, int secondOutputCount, int secondChance, int time, int power) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondChance = secondChance;
        this.time = time;
        this.power = power;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        JsonObject json = new JsonObject();
        json.addProperty("type", "cyclic:crusher");
        json.add("input", ing.m_43942_());
        json.add("result", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        if (!secondStack.m_41619_()) {
            json.addProperty("percent", (Number)this.secondChance);
            json.add("bonus", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(secondStack));
        }
        JsonObject energyJson = new JsonObject();
        energyJson.addProperty("ticks", (Number)this.time);
        energyJson.addProperty("rfpertick", (Number)this.power);
        json.add("energy", (JsonElement)energyJson);
        return json;
    }
}

