/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crossroads.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class MillRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final Object[] output;

    public MillRecipeSerializer(ResourceLocation key, Object input, Object ... output) {
        this(key, "", input, output);
    }

    public MillRecipeSerializer(ResourceLocation key, String group, Object input, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.output = output;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).m_41619_()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            stacks.add(stack);
        }
        if (stacks.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "crossroads:mill");
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        json.add("input", ing.m_43942_());
        JsonArray resultJson = new JsonArray();
        for (ItemStack stack : stacks) {
            resultJson.add((JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        }
        json.add("output", (JsonElement)resultJson);
        return json;
    }
}

