/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.bloodmagic.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class AlchemyTableRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] input;
    public final Object output;
    public final int count;
    public final int cost;
    public final int time;
    public final int minTier;

    public AlchemyTableRecipeSerializer(ResourceLocation key, Object[] input, Object output, int count, int cost, int time, int minTier) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.count = count;
        this.cost = cost;
        this.time = time;
        this.minTier = minTier;
    }

    @Override
    public JsonElement get() {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        for (Object in : this.input) {
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(in);
            if (ing == EmptyIngredient.INSTANCE) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
            }
            inputList.add(ing);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "bloodmagic:alchemytable");
        JsonArray inputJson = new JsonArray();
        for (Ingredient ing : inputList) {
            inputJson.add(ing.m_43942_());
        }
        json.add("input", (JsonElement)inputJson);
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        json.addProperty("syphon", (Number)this.cost);
        json.addProperty("ticks", (Number)this.time);
        json.addProperty("upgradeLevel", (Number)this.minTier);
        return json;
    }
}

