/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.bloodmagic.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.bloodmagic.BloodMagicHelper;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;

public class ARCRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object tool;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object[] output;
    public final Object fluidOutput;
    public final int fluidOutputAmount;
    public final boolean consumeInput;

    public ARCRecipeSerializer(ResourceLocation key, Object input, Object tool, Object[] output, boolean consumeInput) {
        this(key, input, tool, null, 0, output, null, 0, consumeInput);
    }

    public ARCRecipeSerializer(ResourceLocation key, Object input, Object tool, Object fluidInput, int fluidInputAmount, Object[] output, Object fluidOutput, int fluidOutputAmount, boolean consumeInput) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.tool = tool;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.output = output;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
        this.consumeInput = consumeInput;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        Ingredient ingTool = MiscHelper.INSTANCE.getIngredient(this.tool);
        if (ingTool == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.tool);
        }
        FluidStackIngredient fluidIng = BloodMagicHelper.INSTANCE.getFluidStackIngredient(this.fluidInput, this.fluidInputAmount);
        ItemStack result = null;
        ArrayList<Pair> chanceOutputs = new ArrayList<Pair>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Double chance = 1.0;
            if (i < this.output.length && this.output[i] instanceof Double) {
                chance = (Double)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).m_41619_()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            if (result == null) {
                result = stack;
                continue;
            }
            chanceOutputs.add(Pair.of((Object)stack, (Object)chance));
        }
        if (result == null) {
            LOGGER.warn("No main output in recipe {}", (Object)this.key);
            result = ItemStack.f_41583_;
        }
        FluidStack fluidResult = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount);
        if (result.m_41619_() && chanceOutputs.isEmpty() && fluidResult.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output) + ", " + this.fluidOutput);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "bloodmagic:arc");
        json.add("input", ing.m_43942_());
        json.add("tool", ingTool.m_43942_());
        if (fluidIng != null) {
            json.add("inputFluid", fluidIng.serialize());
        }
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(result));
        JsonArray addedJson = new JsonArray();
        for (Pair pair : chanceOutputs) {
            JsonObject outputJson = new JsonObject();
            outputJson.add("type", (JsonElement)MiscHelper.INSTANCE.serializeItemStack((ItemStack)pair.getLeft()));
            if ((Double)pair.getRight() >= 1.0) {
                outputJson.addProperty("mainchance", (Number)1);
                outputJson.addProperty("chance", (Number)0);
            } else {
                outputJson.addProperty("mainchance", (Number)0);
                outputJson.addProperty("chance", (Number)pair.getRight());
            }
            addedJson.add((JsonElement)outputJson);
        }
        json.add("addedoutput", (JsonElement)addedJson);
        if (!fluidResult.isEmpty()) {
            json.add("outputFluid", (JsonElement)MiscHelper.INSTANCE.serializeFluidStack(fluidResult));
        }
        json.addProperty("consumeingredient", Boolean.valueOf(this.consumeInput));
        return json;
    }
}

