/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.immersiveengineering.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.immersiveengineering.recipe.IERecipeJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.util.ListJS;

public class ArcFurnaceRecipeJS
extends IERecipeJS {
    private boolean hasSlag = false;

    public void create(ListJS args) {
        this.outputItems.addAll(this.parseResultItemList(args.get(0)));
        this.inputItems.add(this.parseIngredientItem(args.get(1)).asIngredientStack());
        if (args.size() >= 3) {
            this.inputItems.addAll(this.parseIngredientItemStackList(args.get(2)));
        }
        if (args.size() >= 4) {
            this.outputItems.add(this.parseResultItem(args.get(3)));
            this.hasSlag = true;
        }
        this.json.addProperty("time", (Number)100);
        this.json.addProperty("energy", (Number)51200);
    }

    public void deserialize() {
        this.outputItems.addAll(this.parseResultItemList(this.json.get("results")));
        this.inputItems.add(this.parseIngredientItemIE(this.json.get("input")));
        if (this.json.has("additives")) {
            for (JsonElement element : this.json.get("additives").getAsJsonArray()) {
                this.inputItems.add(this.parseIngredientItemIE(element));
            }
        }
        if (this.json.has("slag")) {
            this.outputItems.add(this.parseResultItem(this.json.get("slag")));
            this.hasSlag = true;
        }
    }

    public void serialize() {
        int i;
        if (this.serializeOutputs) {
            JsonArray results = new JsonArray();
            for (i = 0; i < this.outputItems.size() - (this.hasSlag ? 1 : 0); ++i) {
                results.add(((ItemStackJS)this.outputItems.get(i)).toResultJson());
            }
            this.json.add("results", (JsonElement)results);
            if (this.hasSlag) {
                this.json.add("slag", ((ItemStackJS)this.outputItems.get(this.outputItems.size() - 1)).toResultJson());
            }
        }
        if (this.serializeInputs) {
            this.json.add("input", ((IngredientJS)this.inputItems.get(0)).toJson());
            JsonArray additives = new JsonArray();
            for (i = 1; i < this.inputItems.size(); ++i) {
                additives.add(((IngredientJS)this.inputItems.get(i)).toJson());
            }
            this.json.add("additives", (JsonElement)additives);
        }
    }
}

