/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.compat.jei;

import com.horriblenerd.cobblegenrandomizer.util.Generator;
import com.horriblenerd.compat.jei.GeneratorRecipeWrapper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public abstract class GeneratorRecipeCategoryBase<T extends GeneratorRecipeWrapper>
implements IRecipeCategory<T> {
    private final IDrawableStatic background;
    private final String localizedName;
    private final IDrawable icon;
    private final ItemStack iconStack;
    private final int size;

    public GeneratorRecipeCategoryBase(IGuiHelper guiHelper, ItemStack iconStack, String localizedName, int size) {
        this.size = size;
        this.background = this.size == 0 ? guiHelper.createBlankDrawable(52, 27) : (this.size == 1 ? guiHelper.createBlankDrawable(52, 45) : guiHelper.createBlankDrawable(52, 63));
        this.localizedName = localizedName;
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)iconStack);
        this.iconStack = iconStack;
    }

    @Nonnull
    public abstract Class<? extends T> getRecipeClass();

    @Nonnull
    public Component getTitle() {
        return new TextComponent(this.localizedName);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(T recipe, IIngredients ingredients) {
        ItemStack stack = new ItemStack((ItemLike)((GeneratorRecipeWrapper)recipe).weightedBlock.getBlock());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)stack);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull T recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        int offset = 18;
        int startingX = 0;
        int startingY = 0;
        if (((GeneratorRecipeWrapper)recipeWrapper).type == Generator.Type.COBBLESTONE) {
            if (this.size != 0) {
                startingY += 18;
            }
            fluidStacks.init(0, false, startingX, startingY);
            fluidStacks.set(0, new FluidStack((Fluid)Fluids.f_76193_, 1000));
            fluidStacks.init(1, false, startingX + 2 * offset, startingY);
            fluidStacks.set(1, new FluidStack((Fluid)Fluids.f_76195_, 1000));
            itemStacks.init(2, false, startingX + offset - 1, startingY - 1);
            itemStacks.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
            if (((GeneratorRecipeWrapper)recipeWrapper).catalyst != Blocks.f_50016_) {
                itemStacks.init(3, false, startingX + offset - 1, startingY + offset - 1);
                itemStacks.set(3, new ItemStack((ItemLike)((GeneratorRecipeWrapper)recipeWrapper).catalyst));
            }
        } else if (((GeneratorRecipeWrapper)recipeWrapper).type == Generator.Type.STONE) {
            fluidStacks.init(0, false, startingX + offset, startingY);
            fluidStacks.set(0, new FluidStack((Fluid)Fluids.f_76195_, 1000));
            fluidStacks.init(1, false, startingX, startingY + offset);
            fluidStacks.set(1, new FluidStack((Fluid)Fluids.f_76193_, 1000));
            itemStacks.init(2, false, startingX + offset - 1, startingY + offset - 1);
            itemStacks.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
            if (((GeneratorRecipeWrapper)recipeWrapper).catalyst != Blocks.f_50016_) {
                itemStacks.init(3, false, startingX + offset - 1, startingY + 2 * offset - 1);
                itemStacks.set(3, new ItemStack((ItemLike)((GeneratorRecipeWrapper)recipeWrapper).catalyst));
            }
        } else if (((GeneratorRecipeWrapper)recipeWrapper).type == Generator.Type.BASALT) {
            fluidStacks.init(0, false, startingX, startingY);
            fluidStacks.set(0, new FluidStack((Fluid)Fluids.f_76195_, 1000));
            itemStacks.init(1, false, startingX + 2 * offset, startingY - 1);
            itemStacks.set(1, new ItemStack((ItemLike)Items.f_42363_));
            itemStacks.init(2, false, startingX + offset - 1, startingY - 1);
            itemStacks.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
            itemStacks.init(3, false, startingX + offset - 1, startingY + offset - 1);
            itemStacks.set(3, new ItemStack((ItemLike)Items.f_42050_));
        }
    }

    public void draw(T recipe, PoseStack stack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        TextComponent weightString = new TextComponent(String.format("%s: %d", I18n.m_118938_((String)"cobblegenrandomizer.jei.weight", (Object[])new Object[0]), ((GeneratorRecipeWrapper)recipe).weightedBlock.m_142631_().m_146281_()));
        int y = (1 + this.size) * 18;
        minecraft.f_91062_.m_92889_(stack, (Component)weightString, 2.0f, (float)y, -8355712);
    }
}

