/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.cobblegenrandomizer.util;

import com.horriblenerd.cobblegenrandomizer.CobbleGenRandomizer;
import com.horriblenerd.cobblegenrandomizer.Config;
import com.horriblenerd.cobblegenrandomizer.util.Generator;
import com.horriblenerd.cobblegenrandomizer.util.WeightedBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Generator createGenerator(List<Object> listIn) {
        Generator.Type type;
        if (!Util.isCustomGeneratorValid(listIn)) {
            return null;
        }
        String typeString = (String)listIn.get(0);
        if (typeString.equals("cobblestone")) {
            type = Generator.Type.COBBLESTONE;
        } else if (typeString.equals("stone")) {
            type = Generator.Type.STONE;
        } else {
            return null;
        }
        String req = (String)listIn.get(1);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)req));
        List list = (List)listIn.get(2);
        ArrayList<WeightedBlock> blockList = new ArrayList<WeightedBlock>();
        for (Object o : list) {
            if (!(o instanceof String)) continue;
            if (Util.isValidBlock((String)o)) {
                blockList.add(new WeightedBlock((String)o));
                continue;
            }
            if (!Util.isValidTag((String)o)) continue;
            blockList.addAll(Util.getBlocksFromTag((String)o));
        }
        return new Generator(type, block, blockList);
    }

    public static List<WeightedBlock> getBlocksFromTag(String s) {
        ITag tag;
        ArrayList<WeightedBlock> weightedBlocks = new ArrayList<WeightedBlock>();
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)s.split("\\|")[0]);
        if (resourceLocation != null && !(tag = Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.create((ResourceLocation)resourceLocation))).isEmpty()) {
            int weight = s.split("\\|").length > 1 ? Integer.parseInt(s.split("\\|")[1]) : 1;
            for (Block block : tag) {
                weightedBlocks.add(new WeightedBlock(block, weight));
            }
        }
        return weightedBlocks;
    }

    public static List<WeightedBlock> getWeightedList(List<? extends String> list) {
        ArrayList<WeightedBlock> weightedBlocks = new ArrayList<WeightedBlock>();
        for (String string : list) {
            if (WeightedBlock.isValid(string)) {
                WeightedBlock weightedBlock = new WeightedBlock(string);
                weightedBlocks.add(weightedBlock);
                continue;
            }
            weightedBlocks.addAll(Util.getBlocksFromTag(string));
        }
        return weightedBlocks;
    }

    public static Block getLoot(ServerLevel world, BlockPos pos, Generator.Type type) {
        Block block = Blocks.f_50016_;
        if (((Boolean)Config.USE_CONFIG.get()).booleanValue()) {
            Optional randomItem;
            List<WeightedBlock> list = null;
            if (!CobbleGenRandomizer.GENERATORS.CUSTOM_GENERATOR_LIST.isEmpty()) {
                for (Generator g : CobbleGenRandomizer.GENERATORS.CUSTOM_GENERATOR_LIST) {
                    if (g.getType() != type || g.getBlock() != world.m_8055_(pos.m_7495_()).m_60734_()) continue;
                    list = g.getBlockList();
                    break;
                }
            }
            if (list == null || list.isEmpty()) {
                if (type == Generator.Type.COBBLESTONE) {
                    list = CobbleGenRandomizer.GENERATORS.COBBLE_LIST;
                } else if (type == Generator.Type.STONE) {
                    list = CobbleGenRandomizer.GENERATORS.STONE_LIST;
                } else if (type == Generator.Type.BASALT) {
                    list = CobbleGenRandomizer.GENERATORS.BASALT_LIST;
                }
            }
            if (list != null && !list.isEmpty() && (randomItem = WeightedRandom.m_146317_((Random)world.m_5822_(), list)).isPresent()) {
                block = ((WeightedBlock)((Object)randomItem.get())).getBlock();
            }
        } else {
            ItemStack loot;
            Item item;
            ResourceLocation resourceLocation = new ResourceLocation("");
            if (type == Generator.Type.COBBLESTONE) {
                resourceLocation = new ResourceLocation("cobblegenrandomizer", "cobble_gen");
            } else if (type == Generator.Type.STONE) {
                resourceLocation = new ResourceLocation("cobblegenrandomizer", "stone_gen");
            } else if (type == Generator.Type.BASALT) {
                resourceLocation = new ResourceLocation("cobblegenrandomizer", "basalt_gen");
            }
            LootTable loottable = world.m_142572_().m_129898_().m_79217_(resourceLocation);
            LootContext.Builder lootcontext$builder = new LootContext.Builder(world);
            List list = loottable.m_79129_(lootcontext$builder.m_78975_(LootContextParamSet.m_165477_().m_81405_()));
            if (!list.isEmpty() && (item = (loot = (ItemStack)list.get(world.f_46441_.nextInt(list.size()))).m_41720_()) instanceof BlockItem) {
                block = ((BlockItem)item).m_40614_();
            }
        }
        return block;
    }

    public static boolean isCustomGeneratorValid(List<Object> l) {
        if (l == null || l.size() != 3) {
            return false;
        }
        Object object = l.get(0);
        if (!(object instanceof String)) {
            return false;
        }
        String type = (String)object;
        Object object2 = l.get(1);
        if (!(object2 instanceof String)) {
            return false;
        }
        String req = (String)object2;
        Iterator iterator = l.get(2);
        if (!(iterator instanceof List)) {
            return false;
        }
        List blocks = (List)((Object)iterator);
        if (!(type.equals("cobblestone") || type.equals("stone") || type.equals("basalt"))) {
            return false;
        }
        if (!Util.isValidBlock(req)) {
            return false;
        }
        for (Object o : blocks) {
            if (!(o instanceof String)) {
                return false;
            }
            if (Util.isValidBlock((String)o) || Util.isValidTag((String)o)) continue;
            LOGGER.debug("Invalid block or tag: " + o);
            return false;
        }
        return true;
    }

    public static boolean isValidTag(String s) {
        String[] strings = s.split("\\|");
        boolean resourceNameValid = Util.isResourceNameValid(strings[0]);
        if (!resourceNameValid) {
            return false;
        }
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)strings[0]);
        return resourceLocation != null;
    }

    public static boolean isValidBlock(String s) {
        String[] strings = s.split("\\|");
        boolean resourceNameValid = Util.isResourceNameValid(strings[0]);
        if (!resourceNameValid) {
            return false;
        }
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)strings[0]);
        if (resourceLocation == null) {
            return false;
        }
        Block value = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (value == null || value == Blocks.f_50016_) {
            return false;
        }
        boolean numeric = true;
        if (strings.length == 2) {
            numeric = StringUtils.isNumeric((CharSequence)strings[1]);
        }
        return numeric;
    }

    public static boolean isResourceNameValid(String resourceName) {
        String[] split = resourceName.split(":");
        if (split.length == 1) {
            return Util.isValidPath(split[0]);
        }
        if (split.length == 2) {
            return Util.isValidPath(split[0]) && Util.isValidPath(split[1]);
        }
        return false;
    }

    private static boolean isValidPath(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (Util.isValidChar(path.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidChar(char c) {
        return c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '/';
    }
}

