/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.sdrp.config;

import com.google.gson.GsonBuilder;
import com.sunekaer.sdrp.SDRPCrossPlatform;
import com.sunekaer.sdrp.config.ConfigData;
import com.sunekaer.sdrp.discord.RPClient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(RPClient.class);
    private static Config instance;
    public final ConfigData data = this.getOrCreateData();

    public static Config get() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    private ConfigData getOrCreateData() {
        Path location = SDRPCrossPlatform.getConfigDirectory().resolve("sdrp.json");
        if (!Files.exists(location, new LinkOption[0])) {
            ConfigData defaultData = ConfigData.defaultData();
            try {
                Files.writeString(location, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((Object)defaultData), new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to write default data to config, running on in-memory config data");
                return defaultData;
            }
        }
        try {
            return (ConfigData)new GsonBuilder().create().fromJson(Files.readString(location), ConfigData.class);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read config data from {}, running on in-memory, default, config data", (Object)location);
            return ConfigData.defaultData();
        }
    }
}

