/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.sdrp;

import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.pipe.PipeStatus;
import com.mojang.realmsclient.RealmsMainScreen;
import com.sunekaer.sdrp.config.Config;
import com.sunekaer.sdrp.discord.RPClient;
import com.sunekaer.sdrp.discord.State;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import java.time.OffsetDateTime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class SDRP {
    public static final String MOD_ID = "sdrp";
    public static RPClient RP_CLIENT = new RPClient();
    public static final OffsetDateTime START_TIME = OffsetDateTime.now();

    public static void init() {
        ClientLifecycleEvent.CLIENT_STOPPING.register(minecraft -> SDRP.shutdownDiscordClient());
        Runtime.getRuntime().addShutdownHook(new Thread(SDRP::shutdownDiscordClient));
        EntityEvent.ADD.register(SDRP::clientJoinEvent);
        ClientGuiEvent.INIT_POST.register(SDRP::screenEvent);
    }

    private static void screenEvent(Screen screen, ScreenAccess screenAccess) {
        if (!Config.get().data.enabled.get().booleanValue() || !State.PRESETS.containsKey("menu")) {
            return;
        }
        if (screen instanceof TitleScreen || screen instanceof JoinMultiplayerScreen || screen instanceof SelectWorldScreen || screen instanceof RealmsMainScreen) {
            RichPresence menuState = State.PRESETS.get("menu").createPresence();
            RichPresence currentState = RP_CLIENT.getCurrentState();
            if (currentState != menuState) {
                RP_CLIENT.setState(menuState);
            }
        }
    }

    private static EventResult clientJoinEvent(Entity entity, Level level) {
        if (!Config.get().data.enabled.get().booleanValue()) {
            return EventResult.pass();
        }
        if (entity instanceof AbstractClientPlayer && entity.m_142081_().equals(Minecraft.m_91087_().f_91074_.m_142081_())) {
            SDRP.setDimension(level);
        }
        return EventResult.pass();
    }

    public static void setDimension(Level level) {
        State dim = State.PRESETS.get(level.m_46472_().toString());
        if (dim != null) {
            RP_CLIENT.setState(dim.createPresence());
        } else {
            String name = I18n.m_118938_((String)("sdrp." + level.m_46472_().m_135782_().m_135815_()), (Object[])new Object[0]);
            String in = I18n.m_118938_((String)("sdrp." + level.m_46472_().m_135782_().m_135815_() + ".in"), (Object[])new Object[0]);
            String key = level.m_46472_().m_135782_().m_135815_();
            RP_CLIENT.setState(new State(in, name, key).createPresence());
        }
    }

    private static void shutdownDiscordClient() {
        if (!RPClient.EXECUTOR_SERVICE.isShutdown()) {
            RPClient.EXECUTOR_SERVICE.shutdown();
        }
        if (RP_CLIENT == null || RP_CLIENT.getClient() == null || RP_CLIENT.getClient().getStatus() != PipeStatus.CLOSED || RP_CLIENT.getClient().getStatus() != PipeStatus.DISCONNECTED) {
            return;
        }
        RP_CLIENT.getClient().close();
    }
}

