/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.setup;

import edivad.solargeneration.Main;
import edivad.solargeneration.blockentity.BlockEntitySolarPanel;
import edivad.solargeneration.blocks.SolarPanel;
import edivad.solargeneration.items.SolarHelmet;
import edivad.solargeneration.menu.SolarPanelMenu;
import edivad.solargeneration.setup.ModSetup;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Registration {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"solargeneration");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"solargeneration");
    private static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"solargeneration");
    private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"solargeneration");
    public static final Map<SolarPanelLevel, RegistryObject<SolarPanel>> SOLAR_PANEL_BLOCK = new HashMap<SolarPanelLevel, RegistryObject<SolarPanel>>();
    public static final Map<SolarPanelLevel, RegistryObject<Item>> SOLAR_PANEL_ITEM = new HashMap<SolarPanelLevel, RegistryObject<Item>>();
    public static final Map<SolarPanelLevel, RegistryObject<BlockEntityType<BlockEntitySolarPanel>>> SOLAR_PANEL_TILE = new HashMap<SolarPanelLevel, RegistryObject<BlockEntityType<BlockEntitySolarPanel>>>();
    public static final Map<SolarPanelLevel, RegistryObject<MenuType<SolarPanelMenu>>> SOLAR_PANEL_CONTAINER = new HashMap<SolarPanelLevel, RegistryObject<MenuType<SolarPanelMenu>>>();
    public static final Map<SolarPanelLevel, RegistryObject<Item>> HELMET = new HashMap<SolarPanelLevel, RegistryObject<Item>>();
    public static final Map<SolarPanelLevel, RegistryObject<Item>> CORE = new HashMap<SolarPanelLevel, RegistryObject<Item>>();
    private static final Item.Properties property = new Item.Properties().m_41491_(ModSetup.solarGenerationTab);
    public static final RegistryObject<Item> LAPIS_SHARD = ITEMS.register("lapis_shard", () -> new Item(property));
    public static final RegistryObject<Item> PHOTOVOLTAIC_CELL = ITEMS.register("photovoltaic_cell", () -> new Item(property));

    public static void init() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        TILES.register(eventBus);
        CONTAINERS.register(eventBus);
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            SOLAR_PANEL_BLOCK.put(level, (RegistryObject<SolarPanel>)BLOCKS.register(level.getSolarPanelName(), () -> new SolarPanel(level)));
            SOLAR_PANEL_ITEM.put(level, (RegistryObject<Item>)ITEMS.register(level.getSolarPanelName(), () -> new BlockItem((Block)SOLAR_PANEL_BLOCK.get((Object)level).get(), property)));
            SOLAR_PANEL_TILE.put(level, (RegistryObject<BlockEntityType<BlockEntitySolarPanel>>)TILES.register(level.getSolarPanelName(), () -> BlockEntityType.Builder.m_155273_((pos, state) -> new BlockEntitySolarPanel(level, pos, state), (Block[])new Block[]{(Block)SOLAR_PANEL_BLOCK.get((Object)level).get()}).m_58966_(null)));
            SOLAR_PANEL_CONTAINER.put(level, (RegistryObject<MenuType<SolarPanelMenu>>)CONTAINERS.register(level.getSolarPanelName(), () -> IForgeMenuType.create((windowId, inv, data) -> {
                BlockPos pos = data.m_130135_();
                BlockEntity te = inv.f_35978_.m_20193_().m_7702_(pos);
                if (!(te instanceof BlockEntitySolarPanel)) {
                    Main.logger.error("Wrong type of block entity (expected BlockEntitySolarPanel)!");
                    return null;
                }
                BlockEntitySolarPanel tile = (BlockEntitySolarPanel)te;
                return new SolarPanelMenu(windowId, inv.f_35978_, tile, level);
            })));
            HELMET.put(level, (RegistryObject<Item>)ITEMS.register(level.getSolarHelmetName(), () -> new SolarHelmet(level)));
            CORE.put(level, (RegistryObject<Item>)ITEMS.register(level.getSolarCoreName(), () -> new Item(property)));
        }
    }
}

