/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.setup;

import edivad.solargeneration.Main;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();

    @SubscribeEvent
    public void handlePlayerLoggedInEvent(ClientPlayerNetworkEvent.LoggedInEvent event) {
        try {
            IModInfo modInfo = (IModInfo)ModList.get().getModFileById("solargeneration").getMods().get(0);
            String qualifier = modInfo.getVersion().getQualifier();
            if (qualifier != null && qualifier.contains("NONE")) {
                return;
            }
            VersionChecker.CheckResult versionRAW = VersionChecker.getResult((IModInfo)modInfo);
            if (versionRAW.target() == null) {
                return;
            }
            VersionChecker.Status result = versionRAW.status();
            LocalPlayer player = event.getPlayer();
            if (result.equals((Object)VersionChecker.Status.OUTDATED)) {
                player.m_5661_((Component)new TextComponent(ChatFormatting.GREEN + "[Solar Generation] " + ChatFormatting.WHITE + "A new version is available (" + versionRAW.target() + "), please update!"), false);
                player.m_5661_((Component)new TextComponent(ChatFormatting.YELLOW + "Changelog:"), false);
                String changes = (String)versionRAW.changes().get(versionRAW.target());
                if (changes != null) {
                    String[] changesFormat;
                    for (String change : changesFormat = changes.split("\n")) {
                        player.m_5661_((Component)new TextComponent(ChatFormatting.WHITE + "- " + change), false);
                    }
                    if (versionRAW.changes().size() > 1) {
                        player.m_5661_((Component)new TextComponent(ChatFormatting.WHITE + "- And more..."), false);
                    }
                }
            }
        }
        catch (Exception e) {
            Main.logger.warn("Unable to check the version", (Throwable)e);
        }
    }
}

