/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.network.packet;

import edivad.solargeneration.blockentity.BlockEntitySolarPanel;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class UpdateSolarPanel {
    private BlockPos pos;
    private int currentEnergy;
    private int currentProduction;

    public UpdateSolarPanel(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.currentEnergy = buf.readInt();
        this.currentProduction = buf.readInt();
    }

    public UpdateSolarPanel(BlockPos pos, int currentEnergy, int currentProduction) {
        this.pos = pos;
        this.currentEnergy = currentEnergy;
        this.currentProduction = currentProduction;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.currentEnergy);
        buf.writeInt(this.currentProduction);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            UpdateSolarPanelClient.handle(this, ctx);
        }
        ctx.get().setPacketHandled(true);
    }

    public static class UpdateSolarPanelClient {
        public static void handle(UpdateSolarPanel packet, Supplier<NetworkEvent.Context> ctx) {
            BlockEntity te;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level.m_46749_(packet.pos) && (te = level.m_7702_(packet.pos)) instanceof BlockEntitySolarPanel) {
                BlockEntitySolarPanel solar = (BlockEntitySolarPanel)te;
                solar.energyClient = packet.currentEnergy;
                solar.energyProductionClient = packet.currentProduction;
            }
        }
    }
}

