/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.items;

import edivad.solargeneration.setup.ModSetup;
import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarPanelBattery;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;

public class SolarHelmet
extends ArmorItem {
    private final SolarPanelLevel levelSolarHelmet;
    private final SolarPanelBattery energyStorage;
    private final int energyGeneration;
    private final int maxTransfer;

    public SolarHelmet(SolarPanelLevel levelSolarHelmet) {
        super(levelSolarHelmet.getArmorMaterial(), EquipmentSlot.HEAD, new Item.Properties().m_41491_(ModSetup.solarGenerationTab).m_41487_(1));
        this.levelSolarHelmet = levelSolarHelmet;
        this.energyGeneration = levelSolarHelmet.getEnergyGeneration();
        this.maxTransfer = levelSolarHelmet.getMaxTransfer();
        int capacity = levelSolarHelmet.getCapacity();
        this.energyStorage = new SolarPanelBattery(this.maxTransfer, capacity);
    }

    public boolean m_41465_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        int energy = this.getEnergyStored(stack);
        if (energy != 0) {
            Tooltip.showInfoCtrl(energy, tooltip);
        }
        Tooltip.showInfoShift(this.levelSolarHelmet, tooltip);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "solargeneration" + this.levelSolarHelmet.getArmorTexture();
    }

    public SolarPanelLevel getLevelSolarPanel() {
        return this.levelSolarHelmet;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        if (this.getEnergyStored(stack) == 0) {
            return 0;
        }
        return Math.min(1 + 12 * this.getEnergyStored(stack) / this.getMaxEnergyStored(), 13);
    }

    public void saveEnergyItem(ItemStack container) {
        if (container.m_41783_() == null) {
            container.m_41751_(new CompoundTag());
        }
        container.m_41783_().m_128405_("energy", this.energyStorage.getEnergyStored());
    }

    public int getEnergyStored(ItemStack container) {
        if (container.m_41783_() == null) {
            return 0;
        }
        return container.m_41783_().m_128451_("energy");
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void onArmorTick(ItemStack itemStack, Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        if (this.getEnergyStored(itemStack) != this.getMaxEnergyStored()) {
            this.energyStorage.generatePower(this.currentAmountEnergyProduced(level, player));
        }
        this.sendEnergy(player);
        this.saveEnergyItem(itemStack);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        if (stack.m_41783_() == null) {
            this.energyStorage.setEnergy(0);
            this.saveEnergyItem(stack);
        } else {
            this.energyStorage.setEnergy(this.getEnergyStored(stack));
        }
        return super.getEquipmentSlot(stack);
    }

    private void sendEnergy(Player player) {
        ItemStack item;
        int i;
        for (i = 36; i < 40 && this.energyStorage.getEnergyStored() > 0; ++i) {
            item = player.m_150109_().m_8020_(i);
            this.chargeItem(item);
        }
        for (i = 0; i < 36 && this.energyStorage.getEnergyStored() > 0; ++i) {
            item = player.m_150109_().m_8020_(i);
            this.chargeItem(item);
        }
    }

    private void chargeItem(ItemStack slot) {
        if (slot.m_41613_() == 1) {
            slot.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> {
                if (handler.canReceive()) {
                    while (handler.getEnergyStored() < handler.getMaxEnergyStored() && this.energyStorage.getEnergyStored() > 0) {
                        int accepted = Math.min(this.maxTransfer, handler.receiveEnergy(this.energyStorage.getEnergyStored(), true));
                        this.energyStorage.consumePower(accepted);
                        handler.receiveEnergy(accepted, false);
                    }
                }
            });
        }
    }

    private int currentAmountEnergyProduced(Level level, Player player) {
        if (!this.energyStorage.isFullEnergy()) {
            return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(level, player.m_142538_().m_142082_(0, 1, 0), this.getLevelSolarPanel()));
        }
        return 0;
    }
}

