/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import edivad.solargeneration.lootable.SolarPanelLootFunction;
import edivad.solargeneration.setup.Registration;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;

public class LootTableGenerator
extends LootTableProvider {
    public LootTableGenerator(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(SGBlockLootTables::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    public String m_6055_() {
        return "Solar Generation Loot Tables";
    }

    private static class SGBlockLootTables
    extends BlockLoot {
        private SGBlockLootTables() {
        }

        protected void addTables() {
            Registration.SOLAR_PANEL_BLOCK.values().forEach(block -> this.genBlockItemLootTableWithFunction((Block)block.get(), (LootItemFunction.Builder)SolarPanelLootFunction.builder()));
        }

        protected Iterable<Block> getKnownBlocks() {
            return Registration.SOLAR_PANEL_BLOCK.values().stream().map(RegistryObject::get).collect(Collectors.toList());
        }

        private void genBlockItemLootTableWithFunction(Block block, LootItemFunction.Builder function) {
            LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_(function)).m_6509_(ExplosionCondition.m_81661_());
            this.m_124165_(block, LootTable.m_79147_().m_79161_(builder));
        }
    }
}

