/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import edivad.solargeneration.blockentity.BlockEntitySolarPanel;
import edivad.solargeneration.menu.SolarPanelMenu;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SolarPanelScreen
extends AbstractContainerScreen<SolarPanelMenu> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("solargeneration", "textures/gui/solar_panel.png");
    private final BlockEntitySolarPanel tile;

    public SolarPanelScreen(SolarPanelMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tile = container.tile;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        if (mouseX > this.f_97735_ + 7 && mouseX < this.f_97735_ + 29 && mouseY > this.f_97736_ + 10 && mouseY < this.f_97736_ + 77) {
            this.m_96602_(poseStack, (Component)new TextComponent("Energy: " + this.getPercent() + "%"), mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        String energy = new TranslatableComponent("gui.solargeneration.stored_energy").m_130946_(" " + this.getEnergyFormatted(this.tile.energyClient)).getString();
        this.f_96547_.m_92883_(poseStack, energy, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(energy) / 2 + 14), 20.0f, 0x404040);
        String maxEnergy = new TranslatableComponent("gui.solargeneration.max_capacity").m_130946_(" " + this.getEnergyFormatted(this.tile.getLevelSolarPanel().getCapacity())).getString();
        this.f_96547_.m_92883_(poseStack, maxEnergy, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(maxEnergy) / 2 + 14), 30.0f, 0x404040);
        String generation = new TranslatableComponent("gui.solargeneration.generation").m_130946_(" " + this.tile.energyProductionClient + " FE/t").getString();
        this.f_96547_.m_92883_(poseStack, generation, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(generation) / 2 + 14), 40.0f, 0x404040);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int y = this.getEnergyScaled(60);
        this.m_93228_(poseStack, this.f_97735_ + 10, this.f_97736_ + 12 + y, this.f_97726_, 0, 16, 60 - y);
    }

    private String getEnergyFormatted(int energy) {
        if (energy >= 1000000) {
            return energy / 1000 + " kFE";
        }
        return energy + " FE";
    }

    private int getEnergyScaled(int pixels) {
        return pixels - pixels * this.getPercent() / 100;
    }

    private int getPercent() {
        long currentEnergy = this.tile.energyClient;
        int maxEnergy = this.tile.getLevelSolarPanel().getCapacity();
        long result = currentEnergy * 100L / (long)maxEnergy;
        return (int)result;
    }
}

