/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.blocks;

import edivad.solargeneration.blockentity.BlockEntitySolarPanel;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.SolarPanelBattery;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.network.NetworkHooks;

public class SolarPanel
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    private final SolarPanelLevel levelSolarPanel;
    private static final VoxelShape BOX = SolarPanel.createShape();
    private static final BooleanProperty WATERLOGGED = BooleanProperty.m_61465_((String)"waterlogged");

    public SolarPanel(SolarPanelLevel levelSolarPanel) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60999_().m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.levelSolarPanel = levelSolarPanel;
    }

    private static VoxelShape createShape() {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(SolarPanel.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
        shapes.add(SolarPanel.m_49796_((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0));
        shapes.add(SolarPanel.m_49796_((double)6.0, (double)1.0, (double)9.0, (double)7.0, (double)9.0, (double)10.0));
        shapes.add(SolarPanel.m_49796_((double)9.0, (double)1.0, (double)9.0, (double)10.0, (double)9.0, (double)10.0));
        shapes.add(SolarPanel.m_49796_((double)9.0, (double)1.0, (double)6.0, (double)10.0, (double)9.0, (double)7.0));
        shapes.add(SolarPanel.m_49796_((double)6.0, (double)1.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0));
        shapes.add(SolarPanel.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0));
        VoxelShape combinedShape = Shapes.m_83040_();
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
        }
        return combinedShape;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = level.m_7702_(pos);
        if (!(tileEntity instanceof MenuProvider)) {
            throw new IllegalStateException("Our named container provider is missing!");
        }
        MenuProvider menu = (MenuProvider)tileEntity;
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)menu, (BlockPos)tileEntity.m_58899_());
        return InteractionResult.SUCCESS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.onDestroyedByPlayer(state, level, pos, player, false, fluid);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity te, ItemStack stack) {
        super.m_6240_(level, player, pos, state, te, stack);
        level.m_7471_(pos, false);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BlockEntitySolarPanel(this.levelSolarPanel, blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return SolarPanel.createSolarPanelTicker(level, blockEntityType, (BlockEntityType<? extends BlockEntitySolarPanel>)((BlockEntityType)Registration.SOLAR_PANEL_TILE.get((Object)this.levelSolarPanel).get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createSolarPanelTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends BlockEntitySolarPanel> tile) {
        BlockEntityTicker ticker = BlockEntitySolarPanel::serverTick;
        return level.f_46443_ ? null : (tile == blockEntityType ? ticker : null);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        if (!level.f_46443_) {
            BlockEntitySolarPanel tile = (BlockEntitySolarPanel)level.m_7702_(blockPos);
            if (itemStack.m_41782_()) {
                tile.getCapability(CapabilityEnergy.ENERGY).ifPresent(t -> {
                    SolarPanelBattery energyStorage = (SolarPanelBattery)((Object)t);
                    energyStorage.setEnergy(itemStack.m_41783_().m_128451_("energy"));
                });
            }
        }
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter blockGetter, List<Component> tooltip, TooltipFlag flagIn) {
        int energy;
        int n = energy = stack.m_41782_() ? stack.m_41783_().m_128451_("energy") : 0;
        if (energy != 0) {
            Tooltip.showInfoCtrl(energy, tooltip);
        }
        Tooltip.showInfoShift(this.levelSolarPanel, tooltip);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(levelAccessor, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.m_6044_(blockGetter, pos, state, fluidIn);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

