/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.blockentity;

import edivad.solargeneration.menu.SolarPanelMenu;
import edivad.solargeneration.network.PacketHandler;
import edivad.solargeneration.network.packet.UpdateSolarPanel;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarPanelBattery;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PacketDistributor;

public class BlockEntitySolarPanel
extends BlockEntity
implements MenuProvider {
    private final int energyGeneration;
    private final int maxTransfer;
    private final SolarPanelBattery solarPanelBattery;
    private LazyOptional<IEnergyStorage> energy;
    private final SolarPanelLevel levelSolarPanel;
    public int energyClient;
    public int energyProductionClient;

    public BlockEntitySolarPanel(SolarPanelLevel levelSolarPanel, BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.SOLAR_PANEL_TILE.get((Object)levelSolarPanel).get(), pos, state);
        this.levelSolarPanel = levelSolarPanel;
        this.energyGeneration = levelSolarPanel.getEnergyGeneration();
        this.maxTransfer = levelSolarPanel.getMaxTransfer();
        int capacity = levelSolarPanel.getCapacity();
        this.solarPanelBattery = new SolarPanelBattery(this.maxTransfer, capacity);
        this.energy = LazyOptional.of(() -> this.solarPanelBattery);
        this.energyProductionClient = -1;
        this.energyClient = -1;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BlockEntitySolarPanel tile) {
        int energyProducedBySun = tile.currentAmountEnergyProduced();
        tile.solarPanelBattery.generatePower(energyProducedBySun);
        tile.sendEnergy();
        int energyStored = tile.solarPanelBattery.getEnergyStored();
        if (tile.energyClient != energyStored || tile.energyProductionClient != energyProducedBySun) {
            int energyProduced = tile.solarPanelBattery.isFullEnergy() ? 0 : energyProducedBySun;
            tile.m_6596_();
            PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(blockPos)), (Object)new UpdateSolarPanel(blockPos, energyStored, energyProduced));
        }
    }

    private int currentAmountEnergyProduced() {
        return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(this.f_58857_, this.f_58858_, this.levelSolarPanel));
    }

    private void sendEnergy() {
        AtomicInteger capacity = new AtomicInteger(this.solarPanelBattery.getEnergyStored());
        for (int i = 0; i < Direction.values().length && capacity.get() > 0; ++i) {
            BlockEntity tileEntity;
            Direction facing = Direction.values()[i];
            if (facing == Direction.UP || (tileEntity = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing))) == null) continue;
            tileEntity.getCapability(CapabilityEnergy.ENERGY, facing.m_122424_()).ifPresent(handler -> {
                if (handler.canReceive()) {
                    int received = handler.receiveEnergy(Math.min(capacity.get(), this.maxTransfer), false);
                    capacity.addAndGet(-received);
                    this.solarPanelBattery.consumePower(received);
                    this.m_6596_();
                }
            });
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != Direction.UP) {
            return this.energy.cast();
        }
        return super.getCapability(capability, facing);
    }

    public SolarPanelLevel getLevelSolarPanel() {
        return this.levelSolarPanel;
    }

    public void m_7651_() {
        super.m_7651_();
        this.energy.invalidate();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        Tag energyTag = compound.m_128423_("energy");
        if (energyTag != null) {
            this.solarPanelBattery.deserializeNBT(energyTag);
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("energy", this.solarPanelBattery.serializeNBT());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new SolarPanelMenu(id, playerEntity, this, this.levelSolarPanel);
    }

    public Component m_5446_() {
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }
}

