/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeiinternalsworkaround.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InternalsRemapperTransformer
extends Remapper
implements Consumer<ClassNode> {
    private final Map<String, String> classMap = new HashMap<String, String>();
    private final Set<String> redirectInvokeVirtual = new HashSet<String>();
    private Boolean isDev;

    public InternalsRemapperTransformer() {
        this.classToInterface("mezz/jei/Internal", "me/shedaniel/rei/jeicompat/imitator/JEIInternalsImitator");
        this.classToInterface("mezz/jei/runtime/JeiHelpers", "mezz/jei/api/helpers/IJeiHelpers");
        this.classToInterface("mezz/jei/runtime/JeiRuntime", "mezz/jei/api/runtime/IJeiRuntime");
        this.classToInterface("mezz/jei/ingredients/IngredientManager", "mezz/jei/api/runtime/IIngredientManager");
        this.classToInterface("mezz/jei/ingredients/IngredientFilter", "mezz/jei/api/runtime/IIngredientFilter");
        this.classToInterface("mezz/jei/gui/Focus", "mezz/jei/api/recipe/IFocus");
        this.classToInterface("mezz/jei/input/IClickedIngredient", "me/shedaniel/rei/jeicompat/imitator/JEIInternalsClickedIngredient");
        this.classToInterface("mezz/jei/input/ClickedIngredient", "me/shedaniel/rei/jeicompat/imitator/JEIInternalsClickedIngredientImpl");
        this.classToInterface("mezz/jei/config/ServerInfo", "me/shedaniel/rei/jeicompat/imitator/JEIServerInfo");
        this.redirect("mezz/jei/color/ColorGetter", "me/shedaniel/rei/jeicompat/imitator/JEiColorGetterImitator");
        this.redirect("mezz/jei/plugins/jei/info/IngredientInfoRecipe", "me/shedaniel/rei/jeicompat/imitator/IngredientInfoRecipe");
        this.redirect("mezz/jei/plugins/vanilla/crafting/CraftingCategoryExtension", "me/shedaniel/rei/jeicompat/imitator/JEICraftingCategoryExtension");
        this.redirect("mezz/jei/plugins/vanilla/cooking/AbstractCookingCategory", "me/shedaniel/rei/jeicompat/imitator/JEIAbstractCookingCategory");
        this.redirect("mezz/jei/plugins/vanilla/cooking/FurnaceVariantCategory", "me/shedaniel/rei/jeicompat/imitator/JEIFurnaceVariantCategory");
        this.redirect("mezz/jei/plugins/vanilla/ingredients/fluid/FluidStackRenderer", "me/shedaniel/rei/jeicompat/imitator/JEIFluidStackRendererImitator");
        this.redirect("mezz/jei/plugins/vanilla/ingredients/item/ItemStackRenderer", "me/shedaniel/rei/jeicompat/imitator/JEIItemStackRendererImitator");
        this.redirect("mezz/jei/plugins/vanilla/crafting/CategoryRecipeValidator", "me/shedaniel/rei/jeicompat/imitator/CategoryRecipeValidator");
        this.redirect("mezz/jei/common/util/Translator", "me/shedaniel/rei/jeicompat/imitator/Translator");
    }

    private void redirect(String oldName, String newName) {
        this.classMap.put(oldName, newName);
    }

    private void classToInterface(String oldName, String newName) {
        this.redirect(oldName, newName);
        this.redirectInvokeVirtual.add(oldName);
    }

    public boolean isDev() {
        if (this.isDev == null) {
            try {
                Class.forName("dev.architectury.transformer.TransformerRuntime");
                System.out.println("we are pogging in dev");
                this.isDev = true;
            }
            catch (ClassNotFoundException e) {
                this.isDev = false;
            }
        }
        return this.isDev;
    }

    public String mapSignature(String signature, boolean typeSignature) {
        if (signature == null || signature.isEmpty()) {
            return signature;
        }
        return super.mapSignature(signature, typeSignature);
    }

    public String mapType(String internalName) {
        if (internalName == null) {
            return null;
        }
        Type type = Type.getObjectType((String)internalName);
        if (type.getSort() == 9) {
            try {
                type.getElementType();
            }
            catch (IllegalArgumentException e) {
                System.out.println("REI: Failed to get element type of " + internalName + ", this is caused by an intentional obfuscation, and is intended to prevent others to read and modify their code, so we will ignore it");
                return internalName;
            }
        }
        return super.mapType(internalName);
    }

    @Override
    public void accept(ClassNode classNode) {
        if (this.isDev()) {
            if (classNode.name.endsWith("NonNullLazyValue")) {
                for (MethodNode method : classNode.methods) {
                    if (!method.name.equals("get")) continue;
                    method.instructions.clear();
                    method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/util/LazyLoadedValue", "get", "()Ljava/lang/Object;"));
                    method.instructions.add((AbstractInsnNode)new InsnNode(176));
                }
            }
            if (classNode.name.endsWith("/ItemRenderer")) {
                for (FieldNode field : classNode.fields) {
                    field.access &= 0xFFFFFFFD;
                    field.access |= 1;
                }
            }
            if (classNode.name.endsWith("BrewingRecipeHelper")) {
                block2: for (MethodNode method : classNode.methods) {
                    if (!method.name.startsWith("<")) continue;
                    for (AbstractInsnNode instruction : method.instructions) {
                        if (!(instruction instanceof LdcInsnNode)) continue;
                        if (!Objects.equals(((LdcInsnNode)instruction).cst, "net.minecraft.potion.PotionBrewing$MixPredicate")) break block2;
                        ((LdcInsnNode)instruction).cst = "net.minecraft.world.item.alchemy.PotionBrewing$Mix";
                        break block2;
                    }
                }
            }
        }
        ClassNode newClassNode = new ClassNode(589824);
        ClassRemapper remapper = new ClassRemapper(589824, (ClassVisitor)newClassNode, this){

            protected MethodVisitor createMethodRemapper(MethodVisitor methodVisitor) {
                return new MethodRemapper(this.api, methodVisitor, this.remapper){

                    public void visitMethodInsn(int opcodeAndSource, String owner, String name, String descriptor, boolean isInterface) {
                        if (opcodeAndSource == 182 && InternalsRemapperTransformer.this.redirectInvokeVirtual.contains(owner)) {
                            opcodeAndSource = 185;
                            isInterface = true;
                        }
                        super.visitMethodInsn(opcodeAndSource, owner, name, descriptor, isInterface);
                    }

                    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                        Handle handle;
                        if (Objects.equals(bootstrapMethodHandle.getOwner(), "java/lang/invoke/LambdaMetafactory") && Objects.equals(bootstrapMethodHandle.getName(), "metafactory") && bootstrapMethodArguments.length >= 3 && bootstrapMethodArguments[1] instanceof Handle && InternalsRemapperTransformer.this.redirectInvokeVirtual.contains((handle = (Handle)bootstrapMethodArguments[1]).getOwner())) {
                            bootstrapMethodArguments[1] = new Handle(handle.getTag() == 5 ? 9 : handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc(), true);
                        }
                        super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
                    }

                    public void visitLdcInsn(Object value) {
                        String possibleReplacement;
                        if (value instanceof String && (possibleReplacement = InternalsRemapperTransformer.this.classMap.get(((String)value).replace('.', '/'))) != null) {
                            super.visitLdcInsn((Object)possibleReplacement.replace('/', '.'));
                            return;
                        }
                        super.visitLdcInsn(value);
                    }
                };
            }
        };
        classNode.accept((ClassVisitor)remapper);
        InternalsRemapperTransformer.replace(newClassNode, classNode);
    }

    public String map(String internalName) {
        return this.classMap.getOrDefault(internalName, internalName);
    }

    public static void merge(ClassNode source, ClassNode dest) {
        if (source == null) {
            return;
        }
        if (dest == null) {
            throw new NullPointerException("Target ClassNode for merge must not be null");
        }
        dest.version = Math.max(source.version, dest.version);
        dest.interfaces = InternalsRemapperTransformer.merge(source.interfaces, dest.interfaces);
        dest.invisibleAnnotations = InternalsRemapperTransformer.merge(source.invisibleAnnotations, dest.invisibleAnnotations);
        dest.visibleAnnotations = InternalsRemapperTransformer.merge(source.visibleAnnotations, dest.visibleAnnotations);
        dest.visibleTypeAnnotations = InternalsRemapperTransformer.merge(source.visibleTypeAnnotations, dest.visibleTypeAnnotations);
        dest.invisibleTypeAnnotations = InternalsRemapperTransformer.merge(source.invisibleTypeAnnotations, dest.invisibleTypeAnnotations);
        dest.attrs = InternalsRemapperTransformer.merge(source.attrs, dest.attrs);
        dest.innerClasses = InternalsRemapperTransformer.merge(source.innerClasses, dest.innerClasses);
        dest.fields = InternalsRemapperTransformer.merge(source.fields, dest.fields);
        dest.methods = InternalsRemapperTransformer.merge(source.methods, dest.methods);
    }

    public static void replace(ClassNode source, ClassNode dest) {
        if (source == null) {
            return;
        }
        if (dest == null) {
            throw new NullPointerException("Target ClassNode for replace must not be null");
        }
        dest.name = source.name;
        dest.signature = source.signature;
        dest.superName = source.superName;
        dest.version = source.version;
        dest.access = source.access;
        dest.sourceDebug = source.sourceDebug;
        dest.sourceFile = source.sourceFile;
        dest.outerClass = source.outerClass;
        dest.outerMethod = source.outerMethod;
        dest.outerMethodDesc = source.outerMethodDesc;
        InternalsRemapperTransformer.clear(dest.interfaces);
        InternalsRemapperTransformer.clear(dest.visibleAnnotations);
        InternalsRemapperTransformer.clear(dest.invisibleAnnotations);
        InternalsRemapperTransformer.clear(dest.visibleTypeAnnotations);
        InternalsRemapperTransformer.clear(dest.invisibleTypeAnnotations);
        InternalsRemapperTransformer.clear(dest.attrs);
        InternalsRemapperTransformer.clear(dest.innerClasses);
        InternalsRemapperTransformer.clear(dest.fields);
        InternalsRemapperTransformer.clear(dest.methods);
        dest.module = source.module;
        dest.nestHostClass = source.nestHostClass;
        InternalsRemapperTransformer.clear(dest.nestMembers);
        dest.nestMembers = InternalsRemapperTransformer.merge(source.nestMembers, dest.nestMembers);
        InternalsRemapperTransformer.merge(source, dest);
    }

    private static <T> void clear(List<T> list) {
        if (list != null) {
            list.clear();
        }
    }

    private static <T> List<T> merge(List<T> source, List<T> destination) {
        if (source == null || source.isEmpty()) {
            return destination;
        }
        if (destination == null) {
            return new ArrayList<T>(source);
        }
        destination.addAll(source);
        return destination;
    }
}

