/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.xplat;

import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.function.TriFunction;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.IExoflameHeatable;
import vazkii.botania.api.block.IHornHarvestable;
import vazkii.botania.api.block.IHourglassTrigger;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.ICoordBoundItem;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.common.block.tile.string.TileRedStringContainer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.internal_caps.EthicalComponent;
import vazkii.botania.common.internal_caps.GhostRailComponent;
import vazkii.botania.common.internal_caps.ItemFlagsComponent;
import vazkii.botania.common.internal_caps.KeptItemsComponent;
import vazkii.botania.common.internal_caps.LooniumComponent;
import vazkii.botania.common.internal_caps.NarslimmusComponent;
import vazkii.botania.common.internal_caps.TigerseyeComponent;
import vazkii.botania.network.IPacket;

public interface IXplatAbstractions {
    public static final IXplatAbstractions INSTANCE = IXplatAbstractions.find();

    default public boolean gogLoaded() {
        return this.isModLoaded("gardenofglass");
    }

    default public boolean isFabric() {
        return !this.isForge();
    }

    default public boolean isForge() {
        return !this.isFabric();
    }

    public boolean isModLoaded(String var1);

    public boolean isDevEnvironment();

    public boolean isPhysicalClient();

    public String getBotaniaVersion();

    @Nullable
    public IAvatarWieldable findAvatarWieldable(ItemStack var1);

    @Nullable
    public IBlockProvider findBlockProvider(ItemStack var1);

    @Nullable
    public ICoordBoundItem findCoordBoundItem(ItemStack var1);

    @Nullable
    public IManaItem findManaItem(ItemStack var1);

    @Nullable
    public IRelic findRelic(ItemStack var1);

    @Nullable
    public IExoflameHeatable findExoflameHeatable(Level var1, BlockPos var2, BlockState var3, @Nullable BlockEntity var4);

    @Nullable
    public IHornHarvestable findHornHarvestable(Level var1, BlockPos var2, BlockState var3, @Nullable BlockEntity var4);

    @Nullable
    public IHourglassTrigger findHourglassTrigger(Level var1, BlockPos var2, BlockState var3, @Nullable BlockEntity var4);

    @Nullable
    public IManaCollisionGhost findManaGhost(Level var1, BlockPos var2, BlockState var3, @Nullable BlockEntity var4);

    @Nullable
    default public IManaReceiver findManaReceiver(Level level, BlockPos pos, @Nullable Direction direction) {
        return this.findManaReceiver(level, pos, level.m_8055_(pos), level.m_7702_(pos), direction);
    }

    @Nullable
    public IManaReceiver findManaReceiver(Level var1, BlockPos var2, BlockState var3, @Nullable BlockEntity var4, @Nullable Direction var5);

    @Nullable
    public ISparkAttachable findSparkAttachable(Level var1, BlockPos var2, BlockState var3, @Nullable BlockEntity var4, Direction var5);

    @Nullable
    public IManaTrigger findManaTrigger(Level var1, BlockPos var2, BlockState var3, @Nullable BlockEntity var4);

    @Nullable
    public IWandable findWandable(Level var1, BlockPos var2, BlockState var3, @Nullable BlockEntity var4);

    public boolean isFluidContainer(ItemEntity var1);

    public boolean extractFluidFromItemEntity(ItemEntity var1, Fluid var2);

    public boolean extractFluidFromPlayerItem(Player var1, InteractionHand var2, Fluid var3);

    public boolean insertFluidIntoPlayerItem(Player var1, InteractionHand var2, Fluid var3);

    public boolean hasInventory(Level var1, BlockPos var2, Direction var3);

    public ItemStack insertToInventory(Level var1, BlockPos var2, Direction var3, ItemStack var4, boolean var5);

    public EthicalComponent ethicalComponent(PrimedTnt var1);

    public GhostRailComponent ghostRailComponent(AbstractMinecart var1);

    public ItemFlagsComponent itemFlagsComponent(ItemEntity var1);

    public KeptItemsComponent keptItemsComponent(Player var1, boolean var2);

    @Nullable
    public LooniumComponent looniumComponent(LivingEntity var1);

    public NarslimmusComponent narslimmusComponent(Slime var1);

    public TigerseyeComponent tigersEyeComponent(Creeper var1);

    public boolean fireCorporeaRequestEvent(ICorporeaRequestMatcher var1, int var2, ICorporeaSpark var3, boolean var4);

    public boolean fireCorporeaIndexRequestEvent(ServerPlayer var1, ICorporeaRequestMatcher var2, int var3, ICorporeaSpark var4);

    public void fireManaItemEvent(Player var1, List<ItemStack> var2);

    public float fireManaDiscountEvent(Player var1, float var2, ItemStack var3);

    public boolean fireManaProficiencyEvent(Player var1, ItemStack var2, boolean var3);

    public void fireElvenPortalUpdateEvent(BlockEntity var1, AABB var2, boolean var3, List<ItemStack> var4);

    public void fireManaNetworkEvent(IManaReceiver var1, ManaBlockType var2, ManaNetworkAction var3);

    public Packet<?> toVanillaClientboundPacket(IPacket var1);

    public void sendToPlayer(Player var1, IPacket var2);

    public void sendToNear(Level var1, BlockPos var2, IPacket var3);

    public void sendToTracking(Entity var1, IPacket var2);

    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> var1, Block ... var2);

    public void registerReloadListener(PackType var1, ResourceLocation var2, PreparableReloadListener var3);

    public Item.Properties defaultItemBuilder();

    default public Item.Properties defaultItemBuilderWithCustomDamageOnFabric() {
        return this.defaultItemBuilder();
    }

    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(TriFunction<Integer, Inventory, FriendlyByteBuf, T> var1);

    public Registry<Brew> createBrewRegistry();

    @Nullable
    public EquipmentHandler tryCreateEquipmentHandler();

    public void openMenu(ServerPlayer var1, MenuProvider var2, Consumer<FriendlyByteBuf> var3);

    public Attribute getReachDistanceAttribute();

    public Attribute getStepHeightAttribute();

    public TagKey<Block> getOreTag();

    public boolean isInGlassTag(BlockState var1);

    public boolean canFurnaceBurn(AbstractFurnaceBlockEntity var1, @Nullable Recipe<?> var2, NonNullList<ItemStack> var3, int var4);

    public void saveRecipeAdvancement(DataGenerator var1, HashCache var2, JsonObject var3, Path var4);

    public Fluid getBucketFluid(BucketItem var1);

    public int getSmeltingBurnTime(ItemStack var1);

    public boolean preventsRemoteMovement(ItemEntity var1);

    public void addAxeStripping(Block var1, Block var2);

    public int transferEnergyToNeighbors(Level var1, BlockPos var2, int var3);

    public boolean isRedStringContainerTarget(BlockEntity var1);

    public TileRedStringContainer newRedStringContainer(BlockPos var1, BlockState var2);

    private static IXplatAbstractions find() {
        List<ServiceLoader.Provider<IXplatAbstractions>> providers = ServiceLoader.load(IXplatAbstractions.class).stream().toList();
        if (providers.size() != 1) {
            String names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
            throw new IllegalStateException("There should be exactly one IXplatAbstractions implementation on the classpath. Found: " + names);
        }
        ServiceLoader.Provider<IXplatAbstractions> provider = providers.get(0);
        BotaniaAPI.LOGGER.debug("Instantiating xplat impl: " + provider.type().getName());
        return provider.get();
    }
}

