/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class ManaInfusionProvider
extends BotaniaRecipeProvider {
    public ManaInfusionProvider(DataGenerator gen) {
        super(gen);
    }

    public String m_6055_() {
        return "Botania mana pool recipes";
    }

    @Override
    public void registerRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(this.id("manasteel"), new ItemStack((ItemLike)ModItems.manaSteel), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), 3000));
        consumer.accept(new FinishedRecipe(this.id("manasteel_block"), new ItemStack((ItemLike)ModBlocks.manasteelBlock), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50075_), 27000));
        consumer.accept(new FinishedRecipe(this.id("mana_pearl"), new ItemStack((ItemLike)ModItems.manaPearl), ManaInfusionProvider.ingr((ItemLike)Items.f_42584_), 6000));
        consumer.accept(new FinishedRecipe(this.id("mana_diamond"), new ItemStack((ItemLike)ModItems.manaDiamond), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_}), 10000));
        consumer.accept(new FinishedRecipe(this.id("mana_diamond_block"), new ItemStack((ItemLike)ModBlocks.manaDiamondBlock), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50090_), 90000));
        Ingredient dust = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_, Items.f_42451_, Items.f_42525_, Items.f_42501_});
        consumer.accept(new FinishedRecipe(this.id("mana_powder_dust"), new ItemStack((ItemLike)ModItems.manaPowder), dust, 500));
        Ingredient dyeIngredient = Ingredient.m_43929_((ItemLike[])((ItemLike[])Arrays.stream(DyeColor.values()).map(DyeItem::m_41082_).toArray(Item[]::new)));
        consumer.accept(new FinishedRecipe(this.id("mana_powder_dye"), new ItemStack((ItemLike)ModItems.manaPowder), dyeIngredient, 400));
        consumer.accept(new FinishedRecipe(this.id("piston_relay"), new ItemStack((ItemLike)ModBlocks.pistonRelay), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50039_), 15000));
        consumer.accept(new FinishedRecipe(this.id("mana_cookie"), new ItemStack((ItemLike)ModItems.manaCookie), ManaInfusionProvider.ingr((ItemLike)Items.f_42572_), 20000));
        consumer.accept(new FinishedRecipe(this.id("grass_seeds"), new ItemStack((ItemLike)ModItems.grassSeeds), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50034_), 2500));
        consumer.accept(new FinishedRecipe(this.id("podzol_seeds"), new ItemStack((ItemLike)ModItems.podzolSeeds), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50036_), 2500));
        consumer.accept(new FinishedRecipe(this.id("mycel_seeds"), new ItemStack((ItemLike)ModItems.mycelSeeds), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50073_, Blocks.f_50072_}), 6500));
        consumer.accept(new FinishedRecipe(this.id("mana_quartz"), new ItemStack((ItemLike)ModItems.manaQuartz), ManaInfusionProvider.ingr((ItemLike)Items.f_42692_), 250));
        consumer.accept(new FinishedRecipe(this.id("tiny_potato"), new ItemStack((ItemLike)ModBlocks.tinyPotato), ManaInfusionProvider.ingr((ItemLike)Items.f_42620_), 1337));
        consumer.accept(new FinishedRecipe(this.id("mana_glass"), new ItemStack((ItemLike)ModBlocks.manaGlass), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50058_), 150));
        consumer.accept(new FinishedRecipe(this.id("mana_string"), new ItemStack((ItemLike)ModItems.manaString), ManaInfusionProvider.ingr((ItemLike)Items.f_42401_), 5000));
        consumer.accept(new FinishedRecipe(this.id("mana_bottle"), new ItemStack((ItemLike)ModItems.manaBottle), ManaInfusionProvider.ingr((ItemLike)Items.f_42590_), 5000));
        consumer.accept(FinishedRecipe.alchemy(this.id("rotten_flesh_to_leather"), new ItemStack((ItemLike)Items.f_42454_), ManaInfusionProvider.ingr((ItemLike)Items.f_42583_), 600));
        this.cycle(consumer, 40, "botania:log_cycle", new ItemLike[]{Blocks.f_49999_, Blocks.f_50000_, Blocks.f_50001_, Blocks.f_50002_, Blocks.f_50003_, Blocks.f_50004_});
        this.cycle(consumer, 120, "botania:sapling_cycle", new ItemLike[]{Blocks.f_50746_, Blocks.f_50747_, Blocks.f_50748_, Blocks.f_50749_, Blocks.f_50750_, Blocks.f_50751_});
        consumer.accept(FinishedRecipe.alchemy(this.id("glowstone_deconstruct"), new ItemStack((ItemLike)Items.f_42525_, 4), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50141_), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("quartz_deconstruct"), new ItemStack((ItemLike)Items.f_42692_, 4), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50333_), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("dark_quartz_deconstruct"), new ItemStack((ItemLike)ModItems.darkQuartz, 4), ManaInfusionProvider.ingr((ItemLike)ModFluffBlocks.darkQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("mana_quartz_deconstruct"), new ItemStack((ItemLike)ModItems.manaQuartz, 4), ManaInfusionProvider.ingr((ItemLike)ModFluffBlocks.manaQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("blaze_quartz_deconstruct"), new ItemStack((ItemLike)ModItems.blazeQuartz, 4), ManaInfusionProvider.ingr((ItemLike)ModFluffBlocks.blazeQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("lavender_quartz_deconstruct"), new ItemStack((ItemLike)ModItems.lavenderQuartz, 4), ManaInfusionProvider.ingr((ItemLike)ModFluffBlocks.lavenderQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("red_quartz_deconstruct"), new ItemStack((ItemLike)ModItems.redQuartz, 4), ManaInfusionProvider.ingr((ItemLike)ModFluffBlocks.redQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("elf_quartz_deconstruct"), new ItemStack((ItemLike)ModItems.elfQuartz, 4), ManaInfusionProvider.ingr((ItemLike)ModFluffBlocks.elfQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("chiseled_stone_bricks"), new ItemStack((ItemLike)Blocks.f_50225_, 1), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50222_), 150));
        consumer.accept(FinishedRecipe.alchemy(this.id("ice"), new ItemStack((ItemLike)Blocks.f_50126_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50127_), 2250));
        consumer.accept(FinishedRecipe.alchemy(this.id("vine_to_lily_pad"), new ItemStack((ItemLike)Blocks.f_50196_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50191_), 320));
        consumer.accept(FinishedRecipe.alchemy(this.id("lily_pad_to_vine"), new ItemStack((ItemLike)Blocks.f_50191_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50196_), 320));
        this.cycle(consumer, 200, "botania:fish_cycle", new ItemLike[]{Items.f_42526_, Items.f_42527_, Items.f_42528_, Items.f_42529_});
        this.cycle(consumer, 6000, "botania:crop_cycle", new ItemLike[]{Items.f_42533_, Items.f_42404_, Items.f_42620_, Items.f_42619_, Items.f_42733_, Items.f_42578_, Items.f_42577_});
        consumer.accept(FinishedRecipe.alchemy(this.id("potato_unpoison"), new ItemStack((ItemLike)Items.f_42620_), ManaInfusionProvider.ingr((ItemLike)Items.f_42675_), 1200));
        consumer.accept(FinishedRecipe.alchemy(this.id("blaze_rod_to_nether_wart"), new ItemStack((ItemLike)Items.f_42588_), ManaInfusionProvider.ingr((ItemLike)Items.f_42585_), 4000));
        this.cycle(consumer, 200, "", new ItemLike[]{Items.f_42403_, Items.f_42484_});
        consumer.accept(FinishedRecipe.alchemy(this.id("book_to_name_tag"), new ItemStack((ItemLike)Items.f_42656_), ManaInfusionProvider.ingr((ItemLike)Items.f_42614_), 6000));
        consumer.accept(FinishedRecipe.alchemy(this.id("wool_deconstruct"), new ItemStack((ItemLike)Items.f_42401_, 3), Ingredient.m_204132_((TagKey)ItemTags.f_13167_), 100));
        consumer.accept(FinishedRecipe.alchemy(this.id("cactus_to_slime"), new ItemStack((ItemLike)Items.f_42518_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50128_), 1200));
        consumer.accept(FinishedRecipe.alchemy(this.id("slime_to_cactus"), new ItemStack((ItemLike)Blocks.f_50128_), ManaInfusionProvider.ingr((ItemLike)Items.f_42518_), 1200));
        consumer.accept(FinishedRecipe.alchemy(this.id("ender_pearl_from_ghast_tear"), new ItemStack((ItemLike)Items.f_42584_), ManaInfusionProvider.ingr((ItemLike)Items.f_42586_), 28000));
        this.cycle(consumer, 300, "", new ItemLike[]{Items.f_42525_, Items.f_42451_});
        consumer.accept(FinishedRecipe.alchemy(this.id("cobble_to_sand"), new ItemStack((ItemLike)Blocks.f_49992_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50652_), 50));
        consumer.accept(FinishedRecipe.alchemy(this.id("terracotta_to_red_sand"), new ItemStack((ItemLike)Blocks.f_49993_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50352_), 50));
        consumer.accept(FinishedRecipe.alchemy(this.id("clay_deconstruct"), new ItemStack((ItemLike)Items.f_42461_, 4), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50129_), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("brick_deconstruct"), new ItemStack((ItemLike)Items.f_42460_, 4), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50076_), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("coarse_dirt"), new ItemStack((ItemLike)Blocks.f_50546_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50493_), 120));
        consumer.accept(FinishedRecipe.alchemy(this.id("stone_to_andesite"), new ItemStack((ItemLike)Blocks.f_50334_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50069_), 200));
        consumer.accept(FinishedRecipe.alchemy(this.id("andesite_to_diorite"), new ItemStack((ItemLike)Blocks.f_50228_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50334_), 200));
        consumer.accept(FinishedRecipe.alchemy(this.id("diorite_to_granite"), new ItemStack((ItemLike)Blocks.f_50122_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50228_), 200));
        consumer.accept(FinishedRecipe.alchemy(this.id("granite_to_andesite"), new ItemStack((ItemLike)Blocks.f_50334_), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50122_), 200));
        this.cycle(consumer, 200, "botania:117_stone_cycle", new ItemLike[]{Blocks.f_152496_, Blocks.f_152497_, Blocks.f_152550_});
        this.cycle(consumer, 500, "botania:shrub_cycle", new ItemLike[]{Blocks.f_50035_, Blocks.f_50036_, Blocks.f_50034_});
        this.cycle(consumer, 400, "botania:flower_cycle", new ItemLike[]{Blocks.f_50111_, Blocks.f_50112_, Blocks.f_50113_, Blocks.f_50114_, Blocks.f_50115_, Blocks.f_50116_, Blocks.f_50117_, Blocks.f_50118_, Blocks.f_50119_, Blocks.f_50120_, Blocks.f_50121_, Blocks.f_50071_, Blocks.f_50355_, Blocks.f_50356_, Blocks.f_50357_, Blocks.f_50358_});
        consumer.accept(FinishedRecipe.alchemy(this.id("chorus_fruit_to_flower"), new ItemStack((ItemLike)Blocks.f_50491_), ManaInfusionProvider.ingr((ItemLike)Items.f_42731_), 10000));
        this.cycle(consumer, 240, "botania:berry_cycle", new ItemLike[]{Items.f_42410_, Items.f_42780_, Items.f_151079_});
        consumer.accept(this.mini((ItemLike)ModSubtiles.agricarnationChibi, (ItemLike)ModSubtiles.agricarnation));
        consumer.accept(this.mini((ItemLike)ModSubtiles.clayconiaChibi, (ItemLike)ModSubtiles.clayconia));
        consumer.accept(this.mini((ItemLike)ModSubtiles.bellethornChibi, (ItemLike)ModSubtiles.bellethorn));
        consumer.accept(this.mini((ItemLike)ModSubtiles.bubbellChibi, (ItemLike)ModSubtiles.bubbell));
        consumer.accept(this.mini((ItemLike)ModSubtiles.hopperhockChibi, (ItemLike)ModSubtiles.hopperhock));
        consumer.accept(this.mini((ItemLike)ModSubtiles.jiyuuliaChibi, (ItemLike)ModSubtiles.jiyuulia));
        consumer.accept(this.mini((ItemLike)ModSubtiles.tangleberrieChibi, (ItemLike)ModSubtiles.tangleberrie));
        consumer.accept(this.mini((ItemLike)ModSubtiles.marimorphosisChibi, (ItemLike)ModSubtiles.marimorphosis));
        consumer.accept(this.mini((ItemLike)ModSubtiles.rannuncarpusChibi, (ItemLike)ModSubtiles.rannuncarpus));
        consumer.accept(this.mini((ItemLike)ModSubtiles.solegnoliaChibi, (ItemLike)ModSubtiles.solegnolia));
        consumer.accept(FinishedRecipe.alchemy(this.id("hydroangeas_motif"), new ItemStack((ItemLike)ModBlocks.motifHydroangeas), ManaInfusionProvider.ingr((ItemLike)ModSubtiles.hydroangeas), 2500));
        consumer.accept(FinishedRecipe.conjuration(this.id("redstone_dupe"), new ItemStack((ItemLike)Items.f_42451_, 2), ManaInfusionProvider.ingr((ItemLike)Items.f_42451_), 5000));
        consumer.accept(FinishedRecipe.conjuration(this.id("glowstone_dupe"), new ItemStack((ItemLike)Items.f_42525_, 2), ManaInfusionProvider.ingr((ItemLike)Items.f_42525_), 5000));
        consumer.accept(FinishedRecipe.conjuration(this.id("quartz_dupe"), new ItemStack((ItemLike)Items.f_42692_, 2), ManaInfusionProvider.ingr((ItemLike)Items.f_42692_), 2500));
        consumer.accept(FinishedRecipe.conjuration(this.id("coal_dupe"), new ItemStack((ItemLike)Items.f_42413_, 2), ManaInfusionProvider.ingr((ItemLike)Items.f_42413_), 2100));
        consumer.accept(FinishedRecipe.conjuration(this.id("snowball_dupe"), new ItemStack((ItemLike)Items.f_42452_, 2), ManaInfusionProvider.ingr((ItemLike)Items.f_42452_), 200));
        consumer.accept(FinishedRecipe.conjuration(this.id("netherrack_dupe"), new ItemStack((ItemLike)Blocks.f_50134_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50134_), 200));
        consumer.accept(FinishedRecipe.conjuration(this.id("soul_sand_dupe"), new ItemStack((ItemLike)Blocks.f_50135_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50135_), 1500));
        consumer.accept(FinishedRecipe.conjuration(this.id("gravel_dupe"), new ItemStack((ItemLike)Blocks.f_49994_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_49994_), 720));
        consumer.accept(FinishedRecipe.conjuration(this.id("oak_leaves_dupe"), new ItemStack((ItemLike)Blocks.f_50050_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50050_), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("birch_leaves_dupe"), new ItemStack((ItemLike)Blocks.f_50052_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50052_), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("spruce_leaves_dupe"), new ItemStack((ItemLike)Blocks.f_50051_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50051_), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("jungle_leaves_dupe"), new ItemStack((ItemLike)Blocks.f_50053_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50053_), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("acacia_leaves_dupe"), new ItemStack((ItemLike)Blocks.f_50054_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50054_), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("dark_oak_leaves_dupe"), new ItemStack((ItemLike)Blocks.f_50055_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50055_), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("azalea_leaves_dupe"), new ItemStack((ItemLike)Blocks.f_152470_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_152470_), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("flowering_azalea_leaves_dupe"), new ItemStack((ItemLike)Blocks.f_152471_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_152471_), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("grass"), new ItemStack((ItemLike)Blocks.f_50034_, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.f_50034_), 800));
    }

    protected void cycle(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer, int cost, String group, ItemLike ... items) {
        for (int i = 0; i < items.length; ++i) {
            Ingredient in = ManaInfusionProvider.ingr(items[i]);
            ItemStack out = new ItemStack(i == items.length - 1 ? items[0] : items[i + 1]);
            String id = String.format("%s_to_%s", Registry.f_122827_.m_7981_((Object)items[i].m_5456_()).m_135815_(), Registry.f_122827_.m_7981_((Object)out.m_41720_()).m_135815_());
            consumer.accept(FinishedRecipe.alchemy(this.id(id), out, in, cost, group));
        }
    }

    protected FinishedRecipe mini(ItemLike mini, ItemLike full) {
        return FinishedRecipe.alchemy(this.id(Registry.f_122827_.m_7981_((Object)mini.m_5456_()).m_135815_()), new ItemStack(mini), ManaInfusionProvider.ingr(full), 2500, "botania:flower_shrinking");
    }

    protected ResourceLocation id(String s) {
        return ResourceLocationHelper.prefix("mana_infusion/" + s);
    }

    protected static Ingredient ingr(ItemLike i) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{i});
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        private static final StateIngredient CONJURATION = StateIngredientHelper.of(ModBlocks.conjurationCatalyst);
        private static final StateIngredient ALCHEMY = StateIngredientHelper.of(ModBlocks.alchemyCatalyst);
        private final ResourceLocation id;
        private final Ingredient input;
        private final ItemStack output;
        private final int mana;
        private final String group;
        @Nullable
        private final StateIngredient catalyst;

        public static FinishedRecipe conjuration(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return new FinishedRecipe(id, output, input, mana, "", CONJURATION);
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return FinishedRecipe.alchemy(id, output, input, mana, "");
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            return new FinishedRecipe(id, output, input, mana, group, ALCHEMY);
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            this(id, output, input, mana, "");
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            this(id, output, input, mana, group, null);
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group, @Nullable StateIngredient catalyst) {
            this.id = id;
            this.input = input;
            this.output = output;
            this.mana = mana;
            this.group = group;
            this.catalyst = catalyst;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.input.m_43942_());
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack(this.output));
            json.addProperty("mana", (Number)this.mana);
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.catalyst != null) {
                json.add("catalyst", (JsonElement)this.catalyst.serialize());
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return ModRecipeTypes.MANA_INFUSION_SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

