/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.lib.ModTags;

public class ItemTerraformRod
extends Item {
    private static final int COST_PER = 55;

    public ItemTerraformRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5929_(@Nonnull Level world, @Nonnull LivingEntity living, @Nonnull ItemStack stack, int count) {
        if (count != this.m_8105_(stack) && count % 10 == 0 && living instanceof Player) {
            Player player = (Player)living;
            this.terraform(stack, world, player);
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    private void terraform(ItemStack stack, Level world, Player player) {
        int range = ManaItemHandler.instance().hasProficiency(player, stack) ? 22 : 16;
        BlockPos startCenter = player.m_142538_().m_7495_();
        if (startCenter.m_123342_() < world.m_5736_()) {
            return;
        }
        ArrayList<CoordsWithBlock> blocks = new ArrayList<CoordsWithBlock>();
        for (Object pos : BlockPos.m_121940_((BlockPos)startCenter.m_142082_(-range, -range, -range), (BlockPos)startCenter.m_142082_(range, range, range))) {
            BlockState state = world.m_8055_((BlockPos)pos);
            if (state.m_60795_() || !state.m_204336_(ModTags.Blocks.TERRAFORMABLE)) continue;
            ArrayList<BlockPos> airBlocks = new ArrayList<BlockPos>();
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos pos_ = pos.m_142300_(dir);
                BlockState state_ = world.m_8055_(pos_);
                Block block_ = state_.m_60734_();
                if (!state_.m_60795_() && !state_.m_60767_().m_76336_() && (!(block_ instanceof FlowerBlock) || state_.m_204336_(ModTags.Blocks.SPECIAL_FLOWERS)) && !(block_ instanceof DoublePlantBlock)) continue;
                airBlocks.add(pos_);
            }
            if (airBlocks.isEmpty()) continue;
            if (pos.m_123342_() > startCenter.m_123342_()) {
                blocks.add(new CoordsWithBlock((BlockPos)pos, Blocks.f_50016_));
                continue;
            }
            for (BlockPos coords : airBlocks) {
                if (world.m_46859_(coords.m_7495_())) continue;
                blocks.add(new CoordsWithBlock(coords, Blocks.f_50493_));
            }
        }
        int cost = 55 * blocks.size();
        if (world.f_46443_ || ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, true)) {
            if (!world.f_46443_) {
                for (CoordsWithBlock block : blocks) {
                    world.m_46597_((BlockPos)block, block.block.m_49966_());
                }
            }
            if (!blocks.isEmpty()) {
                world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.terraformRod, SoundSource.BLOCKS, 1.0f, 1.0f);
                SparkleParticleData data = SparkleParticleData.sparkle(2.0f, 0.35f, 0.2f, 0.05f, 5);
                for (int i = 0; i < 120; ++i) {
                    world.m_7106_((ParticleOptions)data, (double)(startCenter.m_123341_() - range) + (double)(range * 2) * Math.random(), (double)(startCenter.m_123342_() + 2) + (Math.random() - 0.5) * 2.0, (double)(startCenter.m_123343_() - range) + (double)(range * 2) * Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static class CoordsWithBlock
    extends BlockPos {
        private final Block block;

        private CoordsWithBlock(BlockPos pos, Block block) {
            super((Vec3i)pos);
            this.block = block;
        }
    }

    public static class BlockProvider
    implements IBlockProvider {
        @Override
        public boolean provideBlock(Player player, ItemStack requestor, Block block, boolean doit) {
            if (block == Blocks.f_50493_) {
                return doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, true) || !doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, false);
            }
            return false;
        }

        @Override
        public int getBlockCount(Player player, ItemStack requestor, Block block) {
            if (block == Blocks.f_50493_) {
                return ManaItemHandler.instance().getInvocationCountForTool(requestor, player, 75);
            }
            return 0;
        }
    }
}

