/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;

public class ItemBlackHoleTalisman
extends Item {
    public static final String TAG_ACTIVE = "active";
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_BLOCK_COUNT = "blockCount";

    public ItemBlackHoleTalisman(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (ItemBlackHoleTalisman.getBlock(stack) != null && player.m_6144_()) {
            ItemNBTHelper.setBoolean(stack, TAG_ACTIVE, !ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false));
            player.m_5496_(ModSounds.blackHoleTalismanConfigure, 1.0f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack toUse;
        InteractionResult result;
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction side = ctx.m_43719_();
        Player player = ctx.m_43723_();
        BlockState state = world.m_8055_(pos);
        ItemStack stack = ctx.m_43722_();
        if (!state.m_60795_() && ItemBlackHoleTalisman.setBlock(stack, state.m_60734_())) {
            return InteractionResult.SUCCESS;
        }
        Block bBlock = ItemBlackHoleTalisman.getBlock(stack);
        if (bBlock == null) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof Container) {
            Container container = (Container)tile;
            if (!world.f_46443_) {
                ItemStack toAdd = new ItemStack((ItemLike)bBlock);
                int maxSize = toAdd.m_41741_();
                toAdd.m_41764_(ItemBlackHoleTalisman.remove(stack, maxSize));
                ItemStack remainder = HopperBlockEntity.m_59326_(null, (Container)container, (ItemStack)toAdd, (Direction)side);
                if (!remainder.m_41619_()) {
                    ItemBlackHoleTalisman.add(stack, remainder.m_41613_());
                }
            }
            return InteractionResult.SUCCESS;
        }
        if ((player == null || player.m_150110_().f_35937_ || ItemBlackHoleTalisman.getBlockCount(stack) > 0) && (result = PlayerHelper.substituteUse(ctx, toUse = new ItemStack((ItemLike)bBlock))).m_19077_()) {
            if (!world.f_46443_) {
                ItemBlackHoleTalisman.remove(stack, 1);
                ItemsRemainingRenderHandler.send(player, toUse, ItemBlackHoleTalisman.getBlockCount(stack));
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        Block block = ItemBlackHoleTalisman.getBlock(itemstack);
        if (!entity.f_19853_.f_46443_ && ItemNBTHelper.getBoolean(itemstack, TAG_ACTIVE, false) && block != null && entity instanceof Player) {
            Player player = (Player)entity;
            ItemBlackHoleTalisman.suckFromPlayerInv(itemstack, block, player);
        }
    }

    private static void suckFromPlayerInv(ItemStack talisman, Block toTake, Player player) {
        int i;
        int highestIdx = -1;
        int[] counts = new int[player.m_150109_().m_6643_() - player.m_150109_().f_35975_.size()];
        for (i = 0; i < counts.length; ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || toTake.m_5456_() != stack.m_41720_()) continue;
            counts[i] = stack.m_41613_();
            highestIdx = highestIdx == -1 ? i : (counts[i] > counts[highestIdx] && highestIdx > 8 ? i : highestIdx);
        }
        if (highestIdx != -1) {
            for (i = 0; i < counts.length; ++i) {
                int count = counts[i];
                if (count == 0) continue;
                ItemBlackHoleTalisman.add(talisman, count);
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
        }
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Block block = ItemBlackHoleTalisman.getBlock(stack);
        ItemStack bstack = new ItemStack((ItemLike)block);
        MutableComponent cand = super.m_7626_(stack).m_6881_();
        if (!bstack.m_41619_()) {
            cand.m_130946_(" (");
            cand.m_7220_((Component)bstack.m_41786_().m_6881_().m_130940_(ChatFormatting.GREEN));
            cand.m_130946_(")");
        }
        return cand;
    }

    private static boolean setBlock(ItemStack stack, Block block) {
        if (block.m_5456_() != Items.f_41852_ && (ItemBlackHoleTalisman.getBlock(stack) == null || ItemBlackHoleTalisman.getBlockCount(stack) == 0)) {
            ItemNBTHelper.setString(stack, TAG_BLOCK_NAME, Registry.f_122824_.m_7981_((Object)block).toString());
            return true;
        }
        return false;
    }

    private static void add(ItemStack stack, int count) {
        int current = ItemBlackHoleTalisman.getBlockCount(stack);
        ItemBlackHoleTalisman.setCount(stack, current + count);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        Block block = ItemBlackHoleTalisman.getBlock(stack);
        if (block != null) {
            int count = ItemBlackHoleTalisman.getBlockCount(stack);
            stacks.add((Component)new TextComponent(count + " ").m_7220_(new ItemStack((ItemLike)block).m_41786_()).m_130940_(ChatFormatting.GRAY));
        }
        if (ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
            stacks.add((Component)new TranslatableComponent("botaniamisc.active"));
        } else {
            stacks.add((Component)new TranslatableComponent("botaniamisc.inactive"));
        }
    }

    private static void setCount(ItemStack stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_BLOCK_COUNT, count);
    }

    public static int remove(ItemStack stack, int count) {
        int current = ItemBlackHoleTalisman.getBlockCount(stack);
        ItemBlackHoleTalisman.setCount(stack, Math.max(current - count, 0));
        return Math.min(current, count);
    }

    private static String getBlockName(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_BLOCK_NAME, "");
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        ResourceLocation id = ResourceLocation.m_135820_((String)ItemBlackHoleTalisman.getBlockName(stack));
        if (id != null) {
            return Registry.f_122824_.m_6612_(id).orElse(null);
        }
        return null;
    }

    public static int getBlockCount(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_COUNT, 0);
    }

    public boolean m_142207_(@Nonnull ItemStack talisman, @Nonnull Slot slot, @Nonnull ClickAction clickAction, @Nonnull Player player) {
        Block existingBlock;
        ItemStack toInsert;
        Block blockToInsert;
        if (clickAction == ClickAction.SECONDARY && (blockToInsert = Block.m_49814_((Item)(toInsert = slot.m_7993_()).m_41720_())) != Blocks.f_50016_ && ((existingBlock = ItemBlackHoleTalisman.getBlock(talisman)) == null || existingBlock == blockToInsert)) {
            ItemStack taken = slot.m_150647_(toInsert.m_41613_(), Integer.MAX_VALUE, player);
            if (existingBlock == null) {
                ItemBlackHoleTalisman.setBlock(talisman, blockToInsert);
                ItemBlackHoleTalisman.setCount(talisman, taken.m_41613_());
            } else {
                ItemBlackHoleTalisman.add(talisman, taken.m_41613_());
            }
            return true;
        }
        return false;
    }

    public boolean m_142305_(@Nonnull ItemStack talisman, @Nonnull ItemStack toInsert, @Nonnull Slot slot, @Nonnull ClickAction clickAction, @Nonnull Player player, @Nonnull SlotAccess cursorAccess) {
        Block existingBlock;
        Block blockToInsert;
        if (clickAction == ClickAction.SECONDARY && (blockToInsert = Block.m_49814_((Item)toInsert.m_41720_())) != Blocks.f_50016_ && ((existingBlock = ItemBlackHoleTalisman.getBlock(talisman)) == null || existingBlock == blockToInsert)) {
            if (existingBlock == null) {
                ItemBlackHoleTalisman.setBlock(talisman, blockToInsert);
                ItemBlackHoleTalisman.setCount(talisman, toInsert.m_41613_());
            } else {
                ItemBlackHoleTalisman.add(talisman, toInsert.m_41613_());
            }
            cursorAccess.m_142104_(ItemStack.f_41583_);
            return true;
        }
        return false;
    }

    public static class BlockProvider
    implements IBlockProvider {
        private final ItemStack stack;

        public BlockProvider(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean provideBlock(Player player, ItemStack requestor, Block block, boolean doit) {
            int count;
            Block stored = ItemBlackHoleTalisman.getBlock(this.stack);
            if (stored == block && (count = ItemBlackHoleTalisman.getBlockCount(this.stack)) > 0) {
                if (doit) {
                    ItemBlackHoleTalisman.setCount(this.stack, count - 1);
                }
                return true;
            }
            return false;
        }

        @Override
        public int getBlockCount(Player player, ItemStack requestor, Block block) {
            Block stored = ItemBlackHoleTalisman.getBlock(this.stack);
            if (stored == block) {
                return ItemBlackHoleTalisman.getBlockCount(this.stack);
            }
            return 0;
        }
    }
}

