/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.BlockPylon;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.xplat.BotaniaConfig;

public class TilePylon
extends BlockEntity {
    boolean activated = false;
    BlockPos centerPos;
    private int ticks = 0;

    public TilePylon(BlockPos pos, BlockState state) {
        super(ModTiles.PYLON, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, TilePylon self) {
        ++self.ticks;
        BlockPylon.Variant variant = ((BlockPylon)state.m_60734_()).variant;
        if (self.activated && level.f_46443_) {
            if (!level.m_8055_(self.centerPos).m_60713_(variant.getTargetBlock()) || variant == BlockPylon.Variant.NATURA && (self.portalOff() || !(level.m_8055_(worldPosition.m_7495_()).m_60734_() instanceof BlockPool))) {
                self.activated = false;
                return;
            }
            Vec3 centerBlock = new Vec3((double)self.centerPos.m_123341_() + 0.5, (double)self.centerPos.m_123342_() + 0.75 + (Math.random() - 0.125), (double)self.centerPos.m_123343_() + 0.5);
            if (variant == BlockPylon.Variant.NATURA) {
                if (BotaniaConfig.client().elfPortalParticlesEnabled()) {
                    double worldTime = self.ticks;
                    worldTime += (double)new Random(worldPosition.hashCode()).nextInt(1000);
                    float r = 0.75f + (float)Math.random() * 0.05f;
                    double x = (double)worldPosition.m_123341_() + 0.5 + Math.cos(worldTime /= 5.0) * (double)r;
                    double z = (double)worldPosition.m_123343_() + 0.5 + Math.sin(worldTime) * (double)r;
                    Vec3 ourCoords = new Vec3(x, (double)worldPosition.m_123342_() + 0.25, z);
                    centerBlock = centerBlock.m_82492_(0.0, 0.5, 0.0);
                    Vec3 movementVector = centerBlock.m_82546_(ourCoords).m_82541_().m_82490_(0.2);
                    WispParticleData data = WispParticleData.wisp(0.25f + (float)Math.random() * 0.1f, (float)Math.random() * 0.25f, 0.75f + (float)Math.random() * 0.25f, (float)Math.random() * 0.25f, 1.0f);
                    level.m_7106_((ParticleOptions)data, x, (double)worldPosition.m_123342_() + 0.25, z, 0.0, (double)(-(-0.075f - (float)Math.random() * 0.015f)), 0.0);
                    if (level.f_46441_.nextInt(3) == 0) {
                        WispParticleData data1 = WispParticleData.wisp(0.25f + (float)Math.random() * 0.1f, (float)Math.random() * 0.25f, 0.75f + (float)Math.random() * 0.25f, (float)Math.random() * 0.25f);
                        level.m_7106_((ParticleOptions)data1, x, (double)worldPosition.m_123342_() + 0.25, z, (double)((float)movementVector.f_82479_), (double)((float)movementVector.f_82480_), (double)((float)movementVector.f_82481_));
                    }
                }
            } else {
                Vec3 ourCoords = Vec3.m_82512_((Vec3i)worldPosition).m_82520_(0.0, 1.0 + (Math.random() - 0.125), 0.0);
                Vec3 movementVector = centerBlock.m_82546_(ourCoords).m_82541_().m_82490_(0.2);
                Block block = level.m_8055_(worldPosition.m_7495_()).m_60734_();
                if (block instanceof BlockModFlower) {
                    BlockModFlower flower = (BlockModFlower)block;
                    int hex = ColorHelper.getColorValue(flower.color);
                    int r = (hex & 0xFF0000) >> 16;
                    int g = (hex & 0xFF00) >> 8;
                    int b = hex & 0xFF;
                    if (level.f_46441_.nextInt(4) == 0) {
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 8);
                        level.m_7106_((ParticleOptions)data, centerBlock.f_82479_ + (Math.random() - 0.5) * 0.5, centerBlock.f_82480_, centerBlock.f_82481_ + (Math.random() - 0.5) * 0.5, 0.0, 0.0, 0.0);
                    }
                    WispParticleData data1 = WispParticleData.wisp((float)Math.random() / 3.0f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
                    level.m_7106_((ParticleOptions)data1, (double)worldPosition.m_123341_() + 0.5 + (Math.random() - 0.5) * 0.25, (double)worldPosition.m_123342_() - 0.5, (double)worldPosition.m_123343_() + 0.5 + (Math.random() - 0.5) * 0.25, 0.0, (double)0.04f, 0.0);
                    WispParticleData data = WispParticleData.wisp((float)Math.random() / 5.0f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
                    level.m_7106_((ParticleOptions)data, (double)worldPosition.m_123341_() + 0.5 + (Math.random() - 0.5) * 0.125, (double)worldPosition.m_123342_() + 1.5, (double)worldPosition.m_123343_() + 0.5 + (Math.random() - 0.5) * 0.125, 0.0, (double)0.001f, 0.0);
                    WispParticleData data2 = WispParticleData.wisp((float)Math.random() / 8.0f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
                    level.m_7106_((ParticleOptions)data2, (double)worldPosition.m_123341_() + 0.5 + (Math.random() - 0.5) * 0.25, (double)worldPosition.m_123342_() + 1.5, (double)worldPosition.m_123343_() + 0.5 + (Math.random() - 0.5) * 0.25, (double)((float)movementVector.f_82479_), (double)((float)movementVector.f_82480_), (double)((float)movementVector.f_82481_));
                }
            }
        }
        if (level.f_46441_.nextBoolean() && level.f_46443_) {
            SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), variant.r, variant.g, variant.b, 2);
            level.m_7106_((ParticleOptions)data, (double)worldPosition.m_123341_() + Math.random(), (double)worldPosition.m_123342_() + Math.random() * 1.5, (double)worldPosition.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    private boolean portalOff() {
        return !this.f_58857_.m_8055_(this.centerPos).m_60713_(ModBlocks.alfPortal) || this.f_58857_.m_8055_(this.centerPos).m_61143_(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.OFF;
    }
}

