/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block.ITileBound;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.internal_caps.ItemFlagsComponent;
import vazkii.botania.common.proxy.IProxy;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.PacketBotaniaEffect;
import vazkii.botania.xplat.IXplatAbstractions;

public class SubTileSpectranthemum
extends TileEntityFunctionalFlower {
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private static final int COST = 24;
    private static final int RANGE = 2;
    private static final int BIND_RANGE = 12;
    public static final String TAG_TELEPORTED = "botania:teleported";
    private BlockPos bindPos = ITileBound.UNBOUND_POS;

    public SubTileSpectranthemum(BlockPos pos, BlockState state) {
        super(ModSubtiles.SPECTRANTHEMUM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.m_58904_().f_46443_ && this.redstoneSignal == 0 && this.m_58904_().m_46805_(this.bindPos)) {
            BlockPos pos = this.getEffectivePos();
            boolean did = false;
            List items = this.m_58904_().m_45976_(ItemEntity.class, new AABB(pos.m_142082_(-2, -2, -2), pos.m_142082_(3, 3, 3)));
            for (ItemEntity item : items) {
                ItemStack stack;
                ItemFlagsComponent flags = IXplatAbstractions.INSTANCE.itemFlagsComponent(item);
                if (!DelayHelper.canInteractWith(this, item) || flags.spectranthemumTeleported || IXplatAbstractions.INSTANCE.findManaItem(stack = item.m_32055_()) != null) continue;
                int cost = stack.m_41613_() * 24;
                if (this.getMana() < cost) continue;
                SubTileSpectranthemum.spawnExplosionParticles((Entity)item, 10);
                item.m_6034_((double)this.bindPos.m_123341_() + 0.5, (double)this.bindPos.m_123342_() + 1.5, (double)this.bindPos.m_123343_() + 0.5);
                flags.spectranthemumTeleported = true;
                item.m_20256_(Vec3.f_82478_);
                SubTileSpectranthemum.spawnExplosionParticles((Entity)item, 10);
                this.addMana(-cost);
                did = true;
            }
            if (did) {
                this.sync();
            }
        }
    }

    static void spawnExplosionParticles(Entity item, int p) {
        IXplatAbstractions.INSTANCE.sendToTracking(item, new PacketBotaniaEffect(EffectType.ITEM_SMOKE, item.m_20185_(), item.m_20186_(), item.m_20189_(), item.m_142049_(), p));
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 2);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 12);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_BIND_X, this.bindPos.m_123341_());
        cmp.m_128405_(TAG_BIND_Y, this.bindPos.m_123342_());
        cmp.m_128405_(TAG_BIND_Z, this.bindPos.m_123343_());
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.bindPos = new BlockPos(cmp.m_128451_(TAG_BIND_X), cmp.m_128451_(TAG_BIND_Y), cmp.m_128451_(TAG_BIND_Z));
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 10009855;
    }

    @Override
    public int getMaxMana() {
        return 16000;
    }

    @Override
    public boolean bindTo(Player player, ItemStack wand, BlockPos pos, Direction side) {
        boolean bound = super.bindTo(player, wand, pos, side);
        if (!bound && !pos.equals((Object)this.bindPos) && pos.m_123331_((Vec3i)this.getEffectivePos()) <= 144.0 && !pos.equals((Object)this.getEffectivePos())) {
            this.bindPos = pos;
            this.sync();
            return true;
        }
        return bound;
    }

    @Override
    public BlockPos getBinding() {
        return IProxy.INSTANCE.getClientPlayer().m_6144_() && this.bindPos.m_123342_() != Integer.MIN_VALUE ? this.bindPos : super.getBinding();
    }
}

