/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.item.ItemTwigWand;

public class BlockEnchanter
extends BlockMod
implements EntityBlock {
    public BlockEnchanter(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(BotaniaStateProps.ENCHANTER_DIRECTION, (Comparable)Direction.Axis.X));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BotaniaStateProps.ENCHANTER_DIRECTION});
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileEnchanter(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockEnchanter.createTickerHelper(type, ModTiles.ENCHANTER, TileEnchanter::commonTick);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean stackEnchantable;
        TileEnchanter enchanter = (TileEnchanter)world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemTwigWand) {
            return InteractionResult.PASS;
        }
        boolean bl = stackEnchantable = !stack.m_41619_() && !stack.m_150930_(Items.f_42517_) && stack.m_41792_() && stack.m_41613_() == 1;
        if (enchanter.itemToEnchant.m_41619_()) {
            if (!stackEnchantable) return InteractionResult.PASS;
            enchanter.itemToEnchant = stack.m_41777_();
            player.m_21008_(hand, ItemStack.f_41583_);
            enchanter.sync();
            return InteractionResult.SUCCESS;
        } else {
            if (enchanter.stage != TileEnchanter.State.IDLE) return InteractionResult.SUCCESS;
            player.m_150109_().m_150079_(enchanter.itemToEnchant.m_41777_());
            enchanter.itemToEnchant = ItemStack.f_41583_;
            enchanter.sync();
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof TileEnchanter) {
                TileEnchanter enchanter = (TileEnchanter)tile;
                if (!enchanter.itemToEnchant.m_41619_()) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)enchanter.itemToEnchant);
                }
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }
}

