/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.model.IPylonModel;
import vazkii.botania.client.model.ModModelLayers;
import vazkii.botania.client.model.ModelPylonGaia;
import vazkii.botania.client.model.ModelPylonMana;
import vazkii.botania.client.model.ModelPylonNatura;
import vazkii.botania.client.render.tile.TEISR;
import vazkii.botania.common.block.BlockPylon;
import vazkii.botania.common.block.tile.TilePylon;

public class RenderTilePylon
implements BlockEntityRenderer<TilePylon> {
    public static final ResourceLocation MANA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_mana.png");
    public static final ResourceLocation NATURA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_natura.png");
    public static final ResourceLocation GAIA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_gaia.png");
    private final ModelPylonMana manaModel;
    private final ModelPylonNatura naturaModel;
    private final ModelPylonGaia gaiaModel;
    private static BlockPylon.Variant forceVariant = BlockPylon.Variant.MANA;
    private static ItemTransforms.TransformType forceTransform = ItemTransforms.TransformType.NONE;

    public RenderTilePylon(BlockEntityRendererProvider.Context ctx) {
        this.manaModel = new ModelPylonMana(ctx.m_173582_(ModModelLayers.PYLON_MANA));
        this.naturaModel = new ModelPylonNatura(ctx.m_173582_(ModModelLayers.PYLON_NATURA));
        this.gaiaModel = new ModelPylonGaia(ctx.m_173582_(ModModelLayers.PYLON_GAIA));
    }

    public void render(@Nullable TilePylon pylon, float pticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ResourceLocation texture;
        IPylonModel model;
        boolean renderingItem = pylon == null;
        boolean direct = renderingItem && (forceTransform == ItemTransforms.TransformType.GUI || forceTransform.m_111841_());
        BlockPylon.Variant type = renderingItem ? forceVariant : ((BlockPylon)pylon.m_58900_().m_60734_()).variant;
        RenderType shaderLayer = switch (type) {
            default -> {
                model = this.manaModel;
                texture = MANA_TEXTURE;
                yield direct ? RenderHelper.MANA_PYLON_GLOW_DIRECT : RenderHelper.MANA_PYLON_GLOW;
            }
            case BlockPylon.Variant.NATURA -> {
                model = this.naturaModel;
                texture = NATURA_TEXTURE;
                yield direct ? RenderHelper.NATURA_PYLON_GLOW_DIRECT : RenderHelper.NATURA_PYLON_GLOW;
            }
            case BlockPylon.Variant.GAIA -> {
                model = this.gaiaModel;
                texture = GAIA_TEXTURE;
                yield direct ? RenderHelper.GAIA_PYLON_GLOW_DIRECT : RenderHelper.GAIA_PYLON_GLOW;
            }
        };
        ms.m_85836_();
        float worldTime = (float)ClientTickHandler.ticksInGame + pticks;
        worldTime += pylon == null ? 0.0f : (float)new Random(pylon.m_58899_().hashCode()).nextInt(360);
        ms.m_85837_(0.0, pylon == null ? 1.35 : 1.5, 0.0);
        ms.m_85841_(1.0f, -1.0f, -1.0f);
        ms.m_85836_();
        ms.m_85837_(0.5, 0.0, -0.5);
        if (pylon != null) {
            ms.m_85845_(Vector3f.f_122225_.m_122240_(worldTime * 1.5f));
        }
        RenderType layer = RenderType.m_110473_((ResourceLocation)texture);
        VertexConsumer buffer = buffers.m_6299_(layer);
        model.renderRing(ms, buffer, light, overlay);
        if (pylon != null) {
            ms.m_85837_(0.0, Math.sin((double)worldTime / 20.0) / 20.0 - 0.025, 0.0);
        }
        ms.m_85849_();
        ms.m_85836_();
        if (pylon != null) {
            ms.m_85837_(0.0, Math.sin((double)worldTime / 20.0) / 17.5, 0.0);
        }
        ms.m_85837_(0.5, 0.0, -0.5);
        if (pylon != null) {
            ms.m_85845_(Vector3f.f_122225_.m_122240_(-worldTime));
        }
        buffer = buffers.m_6299_(shaderLayer);
        model.renderCrystal(ms, buffer, light, overlay);
        ms.m_85849_();
        ms.m_85849_();
    }

    public static class ItemRenderer
    extends TEISR {
        public ItemRenderer(Block block) {
            super(block);
        }

        @Override
        public void render(ItemStack stack, ItemTransforms.TransformType type, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
            Block block = Block.m_49814_((Item)stack.m_41720_());
            if (block instanceof BlockPylon) {
                BlockPylon pylon = (BlockPylon)block;
                forceVariant = pylon.variant;
                forceTransform = type;
                super.render(stack, type, ms, buffers, light, overlay);
            }
        }
    }
}

