/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.corporea;

import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaResult;
import vazkii.botania.api.corporea.ICorporeaSpark;

public interface CorporeaHelper {
    public static final Supplier<CorporeaHelper> INSTANCE = Suppliers.memoize(() -> {
        try {
            return (CorporeaHelper)Class.forName("vazkii.botania.common.impl.corporea.CorporeaHelperImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LogManager.getLogger().warn("Unable to find CorporeaHelperImpl, using a dummy");
            return new CorporeaHelper(){};
        }
    });

    public static CorporeaHelper instance() {
        return INSTANCE.get();
    }

    default public List<ICorporeaNode> getNodesOnNetwork(ICorporeaSpark spark) {
        return Collections.emptyList();
    }

    default public int getCountInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        return 0;
    }

    default public int getCountInNetwork(ICorporeaRequestMatcher matcher, List<ICorporeaNode> inventories) {
        return 0;
    }

    default public Map<ICorporeaNode, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        return Collections.emptyMap();
    }

    default public Map<ICorporeaNode, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, List<ICorporeaNode> inventories) {
        return Collections.emptyMap();
    }

    default public ICorporeaRequestMatcher createMatcher(ItemStack stack, boolean checkNBT) {
        return ICorporeaRequestMatcher.Dummy.INSTANCE;
    }

    default public ICorporeaRequestMatcher createMatcher(String name) {
        return ICorporeaRequestMatcher.Dummy.INSTANCE;
    }

    default public ICorporeaResult requestItem(ItemStack stack, ICorporeaSpark spark, boolean checkNBT, boolean doit) {
        return this.requestItem(this.createMatcher(stack, checkNBT), stack.m_41613_(), spark, doit);
    }

    default public ICorporeaResult requestItem(String name, int count, ICorporeaSpark spark, boolean doit) {
        return this.requestItem(this.createMatcher(name), count, spark, doit);
    }

    default public ICorporeaResult requestItem(ICorporeaRequestMatcher matcher, int itemCount, ICorporeaSpark spark, boolean doit) {
        return ICorporeaResult.Dummy.INSTANCE;
    }

    @Nullable
    default public ICorporeaSpark getSparkForBlock(Level world, BlockPos pos) {
        return null;
    }

    default public boolean doesBlockHaveSpark(Level world, BlockPos pos) {
        return this.getSparkForBlock(world, pos) != null;
    }

    default public int signalStrengthForRequestSize(int requestSize) {
        return 0;
    }

    default public <T extends ICorporeaRequestMatcher> void registerRequestMatcher(ResourceLocation id, Class<T> clazz, Function<CompoundTag, T> deserializer) {
    }
}

