/*
 * Decompiled with CFR 0.152.
 */
package me.dinnerbeef.compressium;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import me.dinnerbeef.compressium.CompressibleBlock;
import me.dinnerbeef.compressium.CompressiumClient;
import me.dinnerbeef.compressium.DefaultCompressiumBlocks;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="compressium")
public class Compressium {
    public static final String MODID = "compressium";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<CompressibleBlock> COMPRESSIUM_BLOCKS = new ArrayList<CompressibleBlock>();
    public static final HashMap<CompressibleBlock, List<Supplier<Block>>> REGISTERED_BLOCKS = new HashMap();
    public static final CreativeModeTab creativeTab = new CreativeModeTab("compressium"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("compressium:cobblestone_1")));
        }
    };

    public Compressium() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addGenericListener(Block.class, this::registerBlocks);
        eventBus.addGenericListener(Item.class, this::registerItems);
        eventBus.addListener(this::clientSetup);
        this.loadBlocksFromConfig();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadBlocksFromConfig() {
        LOGGER.info("Loading compressible blocks from data store config/compressiumblocks.json");
        Path config = FMLPaths.CONFIGDIR.get().resolve("compressiumblocks.json");
        if (Files.exists(config, new LinkOption[0])) {
            try {
                CompressibleBlock[] compressableBlocks = (CompressibleBlock[])new Gson().fromJson(Files.readString(config), CompressibleBlock[].class);
                COMPRESSIUM_BLOCKS.addAll(Arrays.asList(compressableBlocks));
                List<String> foundBlocks = COMPRESSIUM_BLOCKS.stream().map(e -> e.name().toLowerCase()).toList();
                List<DefaultCompressiumBlocks> missingDefaultBlocks = DefaultCompressiumBlocks.VALUES.stream().filter(e -> !foundBlocks.contains(e.name().toLowerCase())).toList();
                if (missingDefaultBlocks.size() <= 0) return;
                LOGGER.warn("Found a missing block from the default compressible blocks, adding it back.");
                LOGGER.warn("We do not support dynamically removing default blocks to prevent basic registry issues.");
                COMPRESSIUM_BLOCKS.addAll(missingDefaultBlocks.stream().map(e -> e.block).toList());
                Files.writeString(config, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson(COMPRESSIUM_BLOCKS), new OpenOption[0]);
                return;
            }
            catch (IOException e2) {
                LOGGER.error("Unable to read json file for compressible blocks data!");
                throw new RuntimeException(e2);
            }
        }
        LOGGER.info("Compressible blocks json not found. Creating a new one!");
        try {
            List<CompressibleBlock> defaultBlocks = Arrays.stream(DefaultCompressiumBlocks.values()).map(e -> e.block).toList();
            COMPRESSIUM_BLOCKS.addAll(defaultBlocks);
            Files.writeString(config, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson(defaultBlocks), new OpenOption[0]);
            return;
        }
        catch (IOException e3) {
            LOGGER.error("Unable to write json file for compressible blocks data!");
            throw new RuntimeException(e3);
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        CompressiumClient.setupItemVar();
    }

    private void registerBlocks(RegistryEvent.Register<Block> event) {
        for (CompressibleBlock block : COMPRESSIUM_BLOCKS) {
            ArrayList<Supplier<Block>> registeredBlocks = new ArrayList<Supplier<Block>>();
            for (int i = 0; i < block.getNestedDepth(); ++i) {
                Block blockToRegister = block.type().getConstructor().get();
                blockToRegister.setRegistryName(block.name().toLowerCase() + "_" + (i + 1));
                event.getRegistry().register((IForgeRegistryEntry)blockToRegister);
                registeredBlocks.add(() -> blockToRegister);
            }
            REGISTERED_BLOCKS.put(block, registeredBlocks);
        }
    }

    private void registerItems(RegistryEvent.Register<Item> event) {
        REGISTERED_BLOCKS.values().forEach(a -> a.forEach(e -> event.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)e.get(), new Item.Properties().m_41491_(creativeTab)).setRegistryName(((Block)e.get()).getRegistryName())))));
    }
}

