/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.common.BlockInfo;
import shetiphian.core.common.NameHelper;
import shetiphian.core.internal.teams.PlayerTeam;
import shetiphian.core.internal.teams.TeamHelper;

public class Function {
    public static Random random = new Random();

    public static boolean setBlock(LevelAccessor world, BlockPos pos, BlockState state, boolean doBlockUpdate) {
        int update = doBlockUpdate ? 11 : 26;
        return world.m_7731_(pos, state, update);
    }

    public static void syncTile(BlockEntity tile) {
        tile.m_6596_();
        BlockState state = tile.m_58900_();
        Function.sync(tile.m_58904_(), tile.m_58899_(), state);
    }

    public static void sync(Level world, BlockPos pos, BlockState state) {
        world.m_7260_(pos, state, state, 11);
    }

    public static void updateLighting(BlockEntity tile) {
        tile.m_58904_().m_45517_(LightLayer.BLOCK, tile.m_58899_());
        BlockState state = tile.m_58900_();
        Function.sync(tile.m_58904_(), tile.m_58899_(), state);
    }

    public static Block getBlockDown(BlockGetter world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60734_();
    }

    public static int[] getBlockXZ(double posX, double posZ) {
        int blockX = (int)posX;
        int blockZ = (int)posZ;
        if (posX - (double)((int)posX) < 0.0) {
            --blockX;
        }
        if (posZ - (double)((int)posZ) < 0.0) {
            // empty if block
        }
        return new int[]{blockX, --blockZ};
    }

    public static boolean giveItem(Player player, ItemStack stack) {
        return Function.giveItem(player, stack, SoundEvents.f_12019_);
    }

    public static boolean giveItem(Player player, ItemStack stack, SoundEvent sound) {
        if (!player.m_150109_().m_36054_(stack)) {
            Function.dropItem(player.m_20193_(), new BlockPos(player.m_20185_(), player.m_20186_(), player.m_20189_()), stack);
            return false;
        }
        if (sound != null) {
            player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, player.m_5720_(), 0.2f, ((player.m_20193_().f_46441_.nextFloat() - player.m_20193_().f_46441_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return true;
    }

    public static void dropItem(Level world, BlockPos pos, ItemStack stack) {
        if (!world.f_46443_ && !stack.m_41619_()) {
            double rndX = (double)(world.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
            double rndY = (double)(world.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
            double rndZ = (double)(world.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity entityItem = new ItemEntity(world, (double)pos.m_123341_() + rndX, (double)pos.m_123342_() + rndY, (double)pos.m_123343_() + rndZ, stack);
            entityItem.m_32010_(10);
            if (stack.m_41782_()) {
                entityItem.m_32055_().m_41751_(stack.m_41783_().m_6426_());
            }
            world.m_7967_((Entity)entityItem);
        }
    }

    @Nonnull
    public static ItemStack findItemStack(String modId, String name) {
        return Function.findItemStack(1, modId, name);
    }

    @Nonnull
    public static ItemStack findItemStack(int count, String modId, String name) {
        ResourceLocation resource = new ResourceLocation(modId, name);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resource);
        if (item != null) {
            return new ItemStack((ItemLike)item, count < 1 ? 1 : count);
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resource);
        if (block != null) {
            return new ItemStack((ItemLike)block, count < 1 ? 1 : count);
        }
        return ItemStack.f_41583_;
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        return Function.areItemStacksEqual(stackA, stackB, false);
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB, boolean excludeNBT) {
        boolean areEqual;
        if (stackA.m_41619_() && stackB.m_41619_()) {
            return true;
        }
        if (stackA.m_41619_() || stackB.m_41619_()) {
            return false;
        }
        boolean bl = areEqual = stackA.m_41720_() == stackB.m_41720_();
        return excludeNBT ? areEqual : areEqual && ItemStack.m_41658_((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean areFluidStacksEqual(FluidStack stackA, FluidStack stackB) {
        return stackA == null && stackB == null || stackA != null && stackB != null && stackA.isFluidEqual(stackB);
    }

    public static void attemptAdd(List<ItemStack> list, ItemStack itemStack) {
        if (itemStack != null && itemStack.m_41613_() > 0) {
            list.add(itemStack);
        }
    }

    public static String getEntityName(LivingEntity entity) {
        return entity.m_5446_().getString();
    }

    public static boolean isOP(Player player) {
        MinecraftServer server = player.m_20193_().m_142572_();
        if (server == null) {
            server = ServerLifecycleHooks.getCurrentServer();
        }
        if (server == null) {
            return ShetiPhianCore.PROXY.isClientOp(player);
        }
        if (server.m_129792_() && player.m_150110_().f_35937_) {
            return true;
        }
        String[] ops = null;
        try {
            ops = server.m_6846_().m_11307_().m_5875_();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ops != null) {
            for (String op : ops) {
                if (!op.equals(player.m_5446_().getString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCreativeOP(Player player) {
        return player.m_150110_().f_35937_ && Function.isOP(player);
    }

    public static String getPlayerTeamID(Player player) {
        PlayerTeam team;
        if (player != null && (team = TeamHelper.getTeam(player)) != null) {
            return team.getId();
        }
        return "";
    }

    public static String getTeamDisplayName(String teamID) {
        return !Strings.isNullOrEmpty((String)teamID) ? NameHelper.getLastKnownTeamName(teamID) : teamID;
    }

    public static int getSubShapeHit(Entity entity, BlockPos pos, VoxelShape ... shapes) {
        double distance = 5.0;
        Vec3 vecStart = new Vec3(entity.f_19854_, entity.f_19855_ + (double)entity.m_20192_(), entity.f_19856_);
        Vec3 vecLook = entity.m_20252_(0.0f);
        Vec3 vecEnd = vecStart.m_82520_(vecLook.f_82479_ * distance, vecLook.f_82480_ * distance, vecLook.f_82481_ * distance);
        int shapeIndex = -1;
        double hitDistance = 100.0;
        for (int index = 0; index < shapes.length; index = (int)((byte)(index + 1))) {
            double shapeDistance;
            BlockHitResult shapeHit = shapes[index].m_83220_(vecStart, vecEnd, pos);
            if (shapeHit == null || !((shapeDistance = shapeHit.m_82450_().m_82557_(vecStart)) < hitDistance)) continue;
            hitDistance = shapeDistance;
            shapeIndex = index;
        }
        return shapeIndex;
    }

    public static BlockHitResult fakeMOP(BlockPos pos, Direction face) {
        Vec3 vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        return new BlockHitResult(vec3, face, pos, false);
    }

    @Deprecated
    public static BlockHitResult rayTrace(Entity entity, double blockReachDistance, float partialTicks) {
        return (BlockHitResult)entity.m_19907_(blockReachDistance, partialTicks, false);
    }

    public static Entity getLivingEntityInFront(Level world, Entity entity, double distance) {
        if (entity == null || world == null || distance < 1.0) {
            return null;
        }
        Vec3 vecStart = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        Vec3 vecLook = entity.m_20252_(1.0f);
        Vec3 vecEnd = vecStart.m_82520_(vecLook.f_82479_ * distance, vecLook.f_82480_ * distance, vecLook.f_82481_ * distance);
        AABB scanBox = new AABB(Math.min(vecStart.f_82479_, vecEnd.f_82479_), Math.min(vecStart.f_82480_, vecEnd.f_82480_), Math.min(vecStart.f_82481_, vecEnd.f_82481_), Math.max(vecStart.f_82479_, vecEnd.f_82479_), Math.max(vecStart.f_82480_, vecEnd.f_82480_), Math.max(vecStart.f_82481_, vecEnd.f_82481_));
        Entity theTarget = null;
        float closestHit = Float.POSITIVE_INFINITY;
        List entityList = entity.m_20193_().m_45933_(entity, scanBox.m_82400_(2.0));
        if (entityList.isEmpty()) {
            return null;
        }
        for (Entity livingEntity : entityList) {
            float currentHit;
            Optional intercept;
            AABB boundingBox;
            if (!(livingEntity instanceof LivingEntity) || !livingEntity.m_6087_() || (boundingBox = livingEntity.m_142469_()) == null || !(intercept = boundingBox.m_82371_(vecStart, vecEnd)).isPresent() || !((currentHit = (float)((Vec3)intercept.get()).m_82554_(vecStart)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            theTarget = livingEntity;
        }
        return theTarget;
    }

    public static BlockInfo getBlockInfront(Level world, Entity entity, double reach, boolean includeLiquids) {
        HitResult mop = Function.getMovingObjectPosition(world, entity, includeLiquids, reach);
        if (mop instanceof BlockHitResult) {
            return new BlockInfo(world, (BlockHitResult)mop);
        }
        return null;
    }

    public static HitResult getMovingObjectPosition(Level world, Entity entity, boolean includeLiquids, double reach) {
        if (entity == null || world == null || reach < 1.0) {
            return null;
        }
        Vec3 vecStart = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        Vec3 vecLook = entity.m_20252_(1.0f);
        Vec3 vecEnd = vecStart.m_82520_(vecLook.f_82479_ * reach, vecLook.f_82480_ * reach, vecLook.f_82481_ * reach);
        return world.m_45547_(new ClipContext(vecStart, vecEnd, ClipContext.Block.OUTLINE, includeLiquids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity));
    }
}

