/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.client.gui.ButtonIcon;
import shetiphian.core.client.gui.WidgetInfoBox;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.SidedContainer;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketSidedWrapper;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiSidedContainer<T extends SidedContainer<?>>
extends AbstractContainerScreen<T> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("shetiphiancore", "textures/gui/info_config.png");
    protected Mode mode = Mode.NORMAL;
    protected WidgetInfoBox infoBox;
    protected byte[] indexSide = new byte[]{-1, -1, -1, -1, -1, -1};
    protected String[] faceNames;
    protected String[] invNames;
    protected Button hoveredButton;
    protected int hoverTime;
    private Button buttonSave;

    public GuiSidedContainer(T container, boolean rotatable, Inventory inventory, Component title) {
        super(container, inventory, title);
        String[] stringArray;
        if (rotatable) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "bottom";
            stringArray2[1] = "top";
            stringArray2[2] = "back";
            stringArray2[3] = "front";
            stringArray2[4] = "left";
            stringArray = stringArray2;
            stringArray2[5] = "right";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "down";
            stringArray3[1] = "up";
            stringArray3[2] = "north";
            stringArray3[3] = "south";
            stringArray3[4] = "west";
            stringArray = stringArray3;
            stringArray3[5] = "east";
        }
        this.faceNames = stringArray;
    }

    protected abstract List<String> getInfoBoxText();

    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        switch (this.mode) {
            case NORMAL: {
                this.m_142416_((GuiEventListener)new ButtonMode(this.f_97735_ - 18, this.f_97736_ + 16, Mode.INFO));
                this.m_142416_((GuiEventListener)new ButtonMode(this.f_97735_ - 18, this.f_97736_ + 40, Mode.CONFIG));
                this.initSidedContainer();
                break;
            }
            case INFO: {
                this.m_142416_((GuiEventListener)new ButtonMode(this.f_97735_ - 18, this.f_97736_ + 16, Mode.NORMAL));
                this.m_142416_((GuiEventListener)new ButtonMode(this.f_97735_ - 18, this.f_97736_ + 40, Mode.CONFIG));
                this.infoBox = new WidgetInfoBox(this.f_96541_, this.f_97735_ + 13, this.f_97736_ + this.f_97727_ - 84, 158, 72).addHeader(this.getInfoBoxText());
                break;
            }
            case CONFIG: {
                this.m_142416_((GuiEventListener)new ButtonMode(this.f_97735_ - 18, this.f_97736_ + 16, Mode.NORMAL));
                this.m_142416_((GuiEventListener)new ButtonMode(this.f_97735_ - 18, this.f_97736_ + 40, Mode.INFO));
                this.buttonSave = new ButtonSave(this.f_97735_ + 158, this.f_97736_ + this.f_97727_ - 88);
                this.m_142416_((GuiEventListener)this.buttonSave);
                if (((SidedContainer)this.f_97732_).getTile() != null) {
                    this.indexSide = (byte[])((SidedContainer)this.f_97732_).getSidedWrapper().getIndexes().clone();
                }
                int x = this.f_97735_ + 91;
                int y = this.f_97736_ + this.f_97727_ - 48;
                this.m_142416_((GuiEventListener)new ButtonFace(x + 1, y - 11, 22, 22, Direction.EAST));
                this.m_142416_((GuiEventListener)new ButtonFace(x - 47, y - 11, 22, 22, Direction.WEST));
                this.m_142416_((GuiEventListener)new ButtonFace(x - 23, y - 11, 22, 22, Direction.SOUTH));
                this.m_142416_((GuiEventListener)new ButtonFace(x + 25, y - 11, 22, 22, Direction.NORTH));
                this.m_142416_((GuiEventListener)new ButtonFace(x - 23, y - 35, 22, 22, Direction.UP));
                this.m_142416_((GuiEventListener)new ButtonFace(x - 23, y + 13, 22, 22, Direction.DOWN));
            }
        }
    }

    private String getFaceText(int index) {
        String text = Localization.get("info." + this.faceNames[index]);
        return text.substring(0, 1).toUpperCase();
    }

    protected abstract void initSidedContainer();

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        if (this.mode == Mode.NORMAL) {
            super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.m_7025_(matrixStack, mouseX, mouseY);
            return;
        }
        this.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.DrawBackground((AbstractContainerScreen)this, matrixStack, mouseX, mouseY));
        RenderSystem.m_69465_();
        Button lastButton = this.hoveredButton;
        this.hoveredButton = null;
        for (Widget widget : this.f_169369_) {
            widget.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            if (!(widget instanceof Button) || !((Button)widget).m_5953_((double)mouseX, (double)mouseY)) continue;
            if (lastButton != widget) {
                this.hoverTime = 0;
            }
            this.hoveredButton = (Button)widget;
        }
        this.hoverTime = this.hoveredButton == null ? 0 : Mth.m_14045_((int)(this.hoverTime + 1), (int)0, (int)Integer.MAX_VALUE);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_7027_(matrixStack, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.DrawForeground((AbstractContainerScreen)this, matrixStack, mouseX, mouseY));
        matrixStack.m_85849_();
        GlStateManager.m_84513_();
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        if (this.mode == Mode.NORMAL) {
            this.drawNormal(matrixStack, partialTicks, mouseX, mouseY);
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_ + this.f_97727_ - 98, 0, 158, 182, 98);
        if (this.mode == Mode.INFO) {
            this.m_93228_(matrixStack, this.f_97735_ + 12, this.f_97736_ + this.f_97727_ - 85, 0, 84, 160, 74);
        } else {
            this.m_93228_(matrixStack, this.buttonSave.f_93620_, this.buttonSave.f_93621_, 208, 208, this.buttonSave.m_5711_(), this.buttonSave.m_93694_());
        }
        GuiFunctions.exitDrawTextureStateWithBlend();
        if (this.mode == Mode.INFO) {
            this.drawInfo(matrixStack, partialTicks, mouseX, mouseY);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
            this.m_93228_(matrixStack, this.f_97735_ + 12, this.f_97736_ + this.f_97727_ - 92, 12, 164, 160, 8);
            this.m_93228_(matrixStack, this.f_97735_ + 12, this.f_97736_ + this.f_97727_ - 85, 0, 84, 160, 1);
            this.m_93228_(matrixStack, this.f_97735_ + 12, this.f_97736_ + this.f_97727_ - 12, 0, 157, 160, 1);
            this.m_93228_(matrixStack, this.f_97735_ + 12, this.f_97736_ + this.f_97727_ - 11, 12, 245, 160, 8);
        } else {
            this.drawConfig(matrixStack, partialTicks, mouseX, mouseY);
        }
    }

    protected abstract void drawNormal(PoseStack var1, float var2, int var3, int var4);

    protected abstract void drawInfo(PoseStack var1, float var2, int var3, int var4);

    protected abstract void drawConfig(PoseStack var1, float var2, int var3, int var4);

    protected void renderFaceButton(PoseStack matrixStack, AbstractWidget button, Direction face, int mouseX, int mouseY, float partialTicks) {
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        if (this.mode == Mode.CONFIG && this.hoverTime >= 40 && this.hoveredButton instanceof ButtonFace) {
            int id = ((ButtonFace)this.hoveredButton).faceIndex;
            byte index = this.indexSide[id];
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a7l" + Localization.get("info." + this.faceNames[id])));
            if (this.invNames != null) {
                list.add(new TextComponent("\u00a7o" + Localization.get(index > -1 && index < this.invNames.length ? this.invNames[index] : "gui.side_disabled")));
            }
            this.m_96597_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.mode == Mode.INFO && this.infoBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.mode == Mode.INFO && this.infoBox.m_7920_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char character, int value) {
        if (this.mode == Mode.INFO && this.infoBox.m_5534_(character, value)) {
            return true;
        }
        return super.m_5534_(character, value);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.mode == Mode.INFO && this.infoBox.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double accelX, double accelY) {
        if (this.mode == Mode.INFO && this.infoBox.m_7979_(mouseX, mouseY, button, accelX, accelY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.mode == Mode.INFO && this.infoBox.m_6050_(mouseX, mouseY, scroll)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    protected static enum Mode {
        NORMAL(192, 240, 192, 224, 192, 240),
        INFO(224, 240, 224, 224, 224, 240),
        CONFIG(240, 240, 240, 224, 240, 240);

        private final int[] normal;
        private final int[] hover;
        private final int[] pressed;

        private Mode(int nU, int nV, int hU, int hV, int pU, int pV) {
            this.normal = new int[]{nU, nV};
            this.hover = new int[]{hU, hV};
            this.pressed = new int[]{pU, pV};
        }
    }

    private class ButtonMode
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;
        private final Mode mode;

        ButtonMode(int posX, int posY, Mode mode) {
            super(posX, posY, 16, 16, GUI_TEXTURE, mode.normal, mode.hover, mode.pressed);
            this.parent = GuiSidedContainer.this;
            this.mode = mode;
        }

        @Override
        public void m_5691_() {
            this.parent.mode = this.mode;
            this.parent.m_7856_();
        }
    }

    private class ButtonSave
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;

        ButtonSave(int posX, int posY) {
            super(posX, posY, 16, 16, GUI_TEXTURE, 208, 240, 208, 224, 208, 240);
            this.parent = GuiSidedContainer.this;
            this.f_93624_ = false;
        }

        @Override
        public void m_5691_() {
            NetworkHandler.sendToServer(new PacketSidedWrapper(((SidedContainer)this.parent.f_97732_).getTile().m_58899_(), this.parent.indexSide));
            this.f_93624_ = false;
        }
    }

    private class ButtonFace
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;
        private final Direction face;
        private final int faceIndex;

        ButtonFace(int posX, int posY, int sizeX, int sizeY, Direction face) {
            super(posX, posY, sizeX, sizeY);
            this.parent = GuiSidedContainer.this;
            this.face = face;
            this.faceIndex = face.m_122411_();
            this.setText(this.parent.getFaceText(this.faceIndex));
        }

        @Override
        public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (!this.f_93624_) {
                return;
            }
            this.parent.renderFaceButton(matrixStack, (AbstractWidget)this, this.face, mouseX, mouseY, partialTicks);
            if (!Strings.isNullOrEmpty((String)this.displayString)) {
                ButtonFace.m_93208_((PoseStack)matrixStack, (Font)this.parent.f_96547_, (String)this.displayString, (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)-1);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_93680_(mouseX, mouseY)) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                ISidedWrapper.SidedWrapper wrapper = ((ISidedWrapper)((SidedContainer)this.parent.f_97732_).getTile()).getSidedWrapper();
                byte max = (byte)(wrapper.getWrapperCount() - 1);
                switch (button) {
                    case 0: {
                        int n = this.faceIndex;
                        this.parent.indexSide[n] = (byte)(this.parent.indexSide[n] + 1);
                        if (this.parent.indexSide[this.faceIndex] <= max) break;
                        this.parent.indexSide[this.faceIndex] = -1;
                        break;
                    }
                    case 1: {
                        int n = this.faceIndex;
                        this.parent.indexSide[n] = (byte)(this.parent.indexSide[n] - 1);
                        if (this.parent.indexSide[this.faceIndex] >= -1) break;
                        this.parent.indexSide[this.faceIndex] = max;
                        break;
                    }
                    case 2: {
                        this.parent.indexSide[this.faceIndex] = -1;
                    }
                }
                if (this.parent.buttonSave != null) {
                    this.parent.buttonSave.f_93624_ = false;
                    byte[] original = wrapper.getIndexes();
                    for (int index = 0; index < 6; ++index) {
                        if (original[index] == this.parent.indexSide[index]) continue;
                        this.parent.buttonSave.f_93624_ = true;
                        break;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

