/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.event;

import cofh.ensorcellation.config.OverrideEnchantmentConfig;
import cofh.ensorcellation.enchantment.override.MendingEnchantmentAlt;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.XpHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class PreservationEvents {
    private PreservationEvents() {
    }

    @SubscribeEvent
    public static void handleAnvilRepairEvent(AnvilRepairEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!OverrideEnchantmentConfig.enableMendingOverride) {
            return;
        }
        ItemStack left = event.getItemInput();
        ItemStack output = event.getItemResult();
        if (Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44962_, (ItemStack)left) <= 0) {
            return;
        }
        if (output.m_41773_() < left.m_41773_()) {
            event.setBreakChance(MendingEnchantmentAlt.anvilDamage);
        }
    }

    @SubscribeEvent
    public static void handleAnvilUpdateEvent(AnvilUpdateEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!OverrideEnchantmentConfig.enableMendingOverride) {
            return;
        }
        ItemStack left = event.getLeft();
        if (Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44962_, (ItemStack)left) <= 0) {
            return;
        }
        ItemStack right = event.getRight();
        ItemStack output = left.m_41777_();
        if (output.m_41763_() && output.m_41720_().m_6832_(left, right)) {
            int matCost;
            int damageLeft = Math.min(output.m_41773_(), output.m_41776_() / 4);
            if (damageLeft <= 0) {
                return;
            }
            for (matCost = 0; damageLeft > 0 && matCost < right.m_41613_(); ++matCost) {
                int durability = output.m_41773_() - damageLeft;
                output.m_41721_(durability);
                damageLeft = Math.min(output.m_41773_(), output.m_41776_() / 4);
            }
            event.setMaterialCost(matCost);
            event.setOutput(output);
        } else if (output.m_41763_()) {
            int damageLeft = left.m_41776_() - left.m_41773_();
            int damageRight = right.m_41776_() - right.m_41773_();
            int damageRepair = damageLeft + damageRight + output.m_41776_() * 12 / 100;
            int damageOutput = output.m_41776_() - damageRepair;
            if (damageOutput < 0) {
                damageOutput = 0;
            }
            if (damageOutput < output.m_41773_()) {
                output.m_41721_(damageOutput);
            }
            event.setOutput(output);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void handlePickupXpEvent(PlayerXpEvent.PickupXp event) {
        if (event.isCanceled()) {
            return;
        }
        if (!OverrideEnchantmentConfig.enableMendingOverride) {
            return;
        }
        Player player = event.getPlayer();
        ExperienceOrb orb = event.getOrb();
        player.f_36101_ = 2;
        player.m_7938_((Entity)orb, 1);
        XpHelper.attemptStoreXP((Player)player, (ExperienceOrb)orb);
        if (orb.f_20770_ > 0) {
            player.m_6756_(orb.f_20770_);
        }
        orb.m_146870_();
        event.setCanceled(true);
    }
}

