/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.enchantment;

import cofh.lib.enchantment.EnchantmentCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.references.CoreReferences;
import cofh.lib.util.references.EnsorcReferences;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;

public class FrostRebukeEnchantment
extends EnchantmentCoFH {
    public static int chance = 20;
    public static boolean mobsAffectPlayers = false;

    public FrostRebukeEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.ARMOR_CHEST, Constants.ARMOR_SLOTS);
        this.maxLevel = 3;
    }

    public int m_6183_(int level) {
        return 5 + 15 * (level - 1);
    }

    protected int maxDelegate(int level) {
        return super.m_6183_(level) + 50;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        Item item = stack.m_41720_();
        return this.enable && (super.canApplyAtEnchantingTable(stack) || item instanceof HorseArmorItem || item.canPerformAction(stack, ToolActions.SHIELD_BLOCK));
    }

    public boolean m_5975_(Enchantment ench) {
        return super.m_5975_(ench) && ench != Enchantments.f_44972_ && ench != EnsorcReferences.DISPLACEMENT && ench != EnsorcReferences.FIRE_REBUKE;
    }

    public void m_7675_(LivingEntity user, Entity attacker, int level) {
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        Map.Entry stack = EnchantmentHelper.m_44906_((Enchantment)EnsorcReferences.FROST_REBUKE, (LivingEntity)user);
        if (FrostRebukeEnchantment.shouldHit(level, user.m_21187_())) {
            FrostRebukeEnchantment.onHit(user, attacker, level);
            if (stack != null) {
                ((ItemStack)stack.getValue()).m_41622_(2, user, entity -> entity.m_21166_((EquipmentSlot)stack.getKey()));
            }
        }
    }

    public static void onHit(LivingEntity user, Entity attacker, int level) {
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        if (user instanceof Player || !(attacker instanceof Player) || mobsAffectPlayers) {
            ((LivingEntity)attacker).m_147240_((double)(0.5f * (float)level), user.m_20185_() - attacker.m_20185_(), user.m_20189_() - attacker.m_20189_());
        }
        Random rand = user.m_21187_();
        int i = 20 + 20 * rand.nextInt(3 * level);
        if (attacker.m_6060_()) {
            attacker.m_20095_();
        }
        ((LivingEntity)attacker).m_7292_(new MobEffectInstance(CoreReferences.CHILLED, i, level - 1, false, false));
        if (attacker.f_19853_ instanceof ServerLevel) {
            for (int j = 0; j < 3 * level; ++j) {
                Utils.spawnParticles((Level)attacker.f_19853_, (ParticleOptions)CoreReferences.FROST_PARTICLE, (double)(attacker.m_20185_() + rand.nextDouble()), (double)(attacker.m_20186_() + 1.0 + rand.nextDouble()), (double)(attacker.m_20189_() + rand.nextDouble()), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            }
        }
    }

    public static boolean shouldHit(int level, Random rand) {
        return rand.nextInt(100) < chance * level;
    }
}

