/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.config;

import cofh.ensorcellation.enchantment.override.FrostWalkerEnchantmentImp;
import cofh.ensorcellation.enchantment.override.MendingEnchantmentAlt;
import cofh.ensorcellation.enchantment.override.ThornsEnchantmentImp;
import cofh.lib.config.IBaseConfig;
import cofh.lib.enchantment.EnchantmentCoFH;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ForgeConfigSpec;

public class OverrideEnchantmentConfig
implements IBaseConfig {
    public static boolean enableMendingOverride = false;
    private ForgeConfigSpec.BooleanValue enableProtection;
    private ForgeConfigSpec.IntValue levelProtection;
    private ForgeConfigSpec.BooleanValue enableProtectionBlast;
    private ForgeConfigSpec.IntValue levelProtectionBlast;
    private ForgeConfigSpec.BooleanValue enableProtectionFall;
    private ForgeConfigSpec.IntValue levelProtectionFall;
    private ForgeConfigSpec.BooleanValue enableProtectionFire;
    private ForgeConfigSpec.IntValue levelProtectionFire;
    private ForgeConfigSpec.BooleanValue enableProtectionProjectile;
    private ForgeConfigSpec.IntValue levelProtectionProjectile;
    private ForgeConfigSpec.BooleanValue enableFireAspect;
    private ForgeConfigSpec.IntValue levelFireAspect;
    private ForgeConfigSpec.BooleanValue enableFrostWalker;
    private ForgeConfigSpec.BooleanValue treasureFrostWalker;
    private ForgeConfigSpec.IntValue levelFrostWalker;
    private ForgeConfigSpec.BooleanValue enableFreezeLava;
    private ForgeConfigSpec.BooleanValue enableKnockback;
    private ForgeConfigSpec.IntValue levelKnockback;
    private ForgeConfigSpec.BooleanValue enableLooting;
    private ForgeConfigSpec.IntValue levelLooting;
    private ForgeConfigSpec.BooleanValue enableThorns;
    private ForgeConfigSpec.IntValue levelThorns;
    private ForgeConfigSpec.IntValue chanceThorns;
    private ForgeConfigSpec.BooleanValue alternateMending;
    private ForgeConfigSpec.BooleanValue treasureMending;
    private ForgeConfigSpec.IntValue damageMending;

    public void apply(ForgeConfigSpec.Builder builder) {
        String treasure = "This sets whether or not the Enchantment is considered a 'treasure' enchantment.";
        String level = "This option adjusts the maximum allowable level for the Enchantment.";
        builder.push("Overrides");
        builder.push("Protection");
        this.enableProtection = builder.comment("If TRUE, the Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.levelProtection = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Blast Protection");
        this.enableProtectionBlast = builder.comment("If TRUE, the Blast Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.levelProtectionBlast = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Feather Falling");
        this.enableProtectionFall = builder.comment("If TRUE, the Feather Falling Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.levelProtectionFall = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Fire Protection");
        this.enableProtectionFire = builder.comment("If TRUE, the Fire Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.levelProtectionFire = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Projectile Protection");
        this.enableProtectionProjectile = builder.comment("If TRUE, the Projectile Protection Enchantment is replaced with a more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.levelProtectionProjectile = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Fire Aspect");
        this.enableFireAspect = builder.comment("If TRUE, the Fire Aspect Enchantment is replaced with a more configurable version which works on more items, such as Axes.").define("Enable", true);
        this.levelFireAspect = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Frost Walker");
        this.enableFrostWalker = builder.comment("If TRUE, the Frost Walker Enchantment is replaced with an improved and more configurable version which works on more items, such as Horse Armor.").define("Enable", true);
        this.treasureFrostWalker = builder.comment(treasure).define("Treasure", true);
        this.levelFrostWalker = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        this.enableFreezeLava = builder.comment("If TRUE, the Frost Walker Enchantment will also chill Lava into Glossed Magma.").define("Freeze Lava", true);
        builder.pop();
        builder.push("Knockback");
        this.enableKnockback = builder.comment("If TRUE, the Knockback Enchantment is replaced with a more configurable version which works on more items, such as Axes.").define("Enable", true);
        this.levelKnockback = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Looting");
        this.enableLooting = builder.comment("If TRUE, the Looting Enchantment is replaced with a more configurable version which works on more items, such as Axes.").define("Enable", true);
        this.levelLooting = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        builder.pop();
        builder.push("Thorns");
        this.enableThorns = builder.comment("If TRUE, the Thorns Enchantment is replaced with a more configurable version which works on more items, such as Shields and Horse Armor.").define("Enable", true);
        this.levelThorns = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        this.chanceThorns = builder.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 15, 1, 100);
        builder.pop();
        builder.push("Mending");
        this.alternateMending = builder.comment("If TRUE, the Mending Enchantment is replaced with a new Enchantment - Preservation. This enchantment allows you to repair items at an Anvil without paying an increasing XP cost for every time you repair it. Additionally, these repairs have a much lower chance of damaging the anvil.").define("Alternate Mending", false);
        this.treasureMending = builder.comment(treasure).define("Treasure", true);
        this.damageMending = builder.comment("Adjust this value to set the chance of an Anvil being damaged when used to repair an item with Preservation (in percentage). Only used if Alternate Mending (Preservation) is enabled.").defineInRange("Anvil Damage Chance", 3, 0, 12);
        builder.pop();
        builder.pop();
    }

    public void refresh() {
        if (Enchantments.f_44965_ instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.f_44965_).setEnable(((Boolean)this.enableProtection.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44965_).setMaxLevel(((Integer)this.levelProtection.get()).intValue());
        }
        if (Enchantments.f_44968_ instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.f_44968_).setEnable(((Boolean)this.enableProtectionBlast.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44968_).setMaxLevel(((Integer)this.levelProtectionBlast.get()).intValue());
        }
        if (Enchantments.f_44967_ instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.f_44967_).setEnable(((Boolean)this.enableProtectionFall.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44967_).setMaxLevel(((Integer)this.levelProtectionFall.get()).intValue());
        }
        if (Enchantments.f_44966_ instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.f_44966_).setEnable(((Boolean)this.enableProtectionFire.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44966_).setMaxLevel(((Integer)this.levelProtectionFire.get()).intValue());
        }
        if (Enchantments.f_44969_ instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.f_44969_).setEnable(((Boolean)this.enableProtectionProjectile.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44969_).setMaxLevel(((Integer)this.levelProtectionProjectile.get()).intValue());
        }
        if (Enchantments.f_44981_ instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.f_44981_).setEnable(((Boolean)this.enableFireAspect.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44981_).setMaxLevel(((Integer)this.levelFireAspect.get()).intValue());
        }
        if (Enchantments.f_44974_ instanceof FrostWalkerEnchantmentImp) {
            ((EnchantmentCoFH)Enchantments.f_44974_).setEnable(((Boolean)this.enableFrostWalker.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44974_).setTreasureEnchantment(((Boolean)this.treasureFrostWalker.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44974_).setMaxLevel(((Integer)this.levelFrostWalker.get()).intValue());
            ((FrostWalkerEnchantmentImp)Enchantments.f_44974_).setFreezeLava((Boolean)this.enableFreezeLava.get());
        }
        if (Enchantments.f_44980_ instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.f_44980_).setEnable(((Boolean)this.enableKnockback.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44980_).setMaxLevel(((Integer)this.levelKnockback.get()).intValue());
        }
        if (Enchantments.f_44982_ instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.f_44982_).setEnable(((Boolean)this.enableLooting.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44982_).setMaxLevel(((Integer)this.levelLooting.get()).intValue());
        }
        if (Enchantments.f_44972_ instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.f_44972_).setEnable(((Boolean)this.enableThorns.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44972_).setMaxLevel(((Integer)this.levelThorns.get()).intValue());
            ThornsEnchantmentImp.chance = (Integer)this.chanceThorns.get();
        }
        if (Enchantments.f_44962_ instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)Enchantments.f_44962_).setEnable(((Boolean)this.alternateMending.get()).booleanValue());
            ((EnchantmentCoFH)Enchantments.f_44962_).setTreasureEnchantment(((Boolean)this.treasureMending.get()).booleanValue());
            MendingEnchantmentAlt.anvilDamage = (float)((Integer)this.damageMending.get()).intValue() / 100.0f;
        }
    }
}

