/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.config;

import cofh.ensorcellation.enchantment.AnglerEnchantment;
import cofh.ensorcellation.enchantment.DamageVillagerEnchantment;
import cofh.ensorcellation.enchantment.DisplacementEnchantment;
import cofh.ensorcellation.enchantment.FireRebukeEnchantment;
import cofh.ensorcellation.enchantment.FrostRebukeEnchantment;
import cofh.ensorcellation.enchantment.HunterEnchantment;
import cofh.ensorcellation.enchantment.PilferingEnchantment;
import cofh.ensorcellation.enchantment.SoulboundEnchantment;
import cofh.ensorcellation.enchantment.VitalityEnchantment;
import cofh.ensorcellation.enchantment.VorpalEnchantment;
import cofh.ensorcellation.enchantment.XpBoostEnchantment;
import cofh.lib.config.IBaseConfig;
import cofh.lib.enchantment.EnchantmentCoFH;
import cofh.lib.util.references.EnsorcReferences;
import net.minecraftforge.common.ForgeConfigSpec;

public class BaseEnchantmentConfig
implements IBaseConfig {
    private ForgeConfigSpec.BooleanValue enableProtectionMagic;
    private ForgeConfigSpec.BooleanValue treasureProtectionMagic;
    private ForgeConfigSpec.IntValue levelProtectionMagic;
    private ForgeConfigSpec.BooleanValue enableDisplacement;
    private ForgeConfigSpec.BooleanValue treasureDisplacement;
    private ForgeConfigSpec.IntValue levelDisplacement;
    private ForgeConfigSpec.IntValue chanceDisplacement;
    private ForgeConfigSpec.BooleanValue allowMobsDisplacement;
    private ForgeConfigSpec.BooleanValue enableFireRebuke;
    private ForgeConfigSpec.BooleanValue treasureFireRebuke;
    private ForgeConfigSpec.IntValue levelFireRebuke;
    private ForgeConfigSpec.IntValue chanceFireRebuke;
    private ForgeConfigSpec.BooleanValue allowMobsFireRebuke;
    private ForgeConfigSpec.BooleanValue enableFrostRebuke;
    private ForgeConfigSpec.BooleanValue treasureFrostRebuke;
    private ForgeConfigSpec.IntValue levelFrostRebuke;
    private ForgeConfigSpec.IntValue chanceFrostRebuke;
    private ForgeConfigSpec.BooleanValue allowMobsFrostRebuke;
    private ForgeConfigSpec.BooleanValue enableAirAffinity;
    private ForgeConfigSpec.BooleanValue treasureAirAffinity;
    private ForgeConfigSpec.BooleanValue enableXpBoost;
    private ForgeConfigSpec.BooleanValue treasureXpBoost;
    private ForgeConfigSpec.IntValue levelXpBoost;
    private ForgeConfigSpec.IntValue amountXpBoost;
    private ForgeConfigSpec.BooleanValue enableGourmand;
    private ForgeConfigSpec.BooleanValue treasureGourmand;
    private ForgeConfigSpec.IntValue levelGourmand;
    private ForgeConfigSpec.BooleanValue enableReach;
    private ForgeConfigSpec.BooleanValue treasureReach;
    private ForgeConfigSpec.IntValue levelReach;
    private ForgeConfigSpec.BooleanValue enableVitality;
    private ForgeConfigSpec.BooleanValue treasureVitality;
    private ForgeConfigSpec.IntValue levelVitality;
    private ForgeConfigSpec.IntValue healthLevelVitality;
    private ForgeConfigSpec.BooleanValue enableDamageEnder;
    private ForgeConfigSpec.BooleanValue treasureDamageEnder;
    private ForgeConfigSpec.IntValue levelDamageEnder;
    private ForgeConfigSpec.BooleanValue enableDamageIllager;
    private ForgeConfigSpec.BooleanValue treasureDamageIllager;
    private ForgeConfigSpec.IntValue levelDamageIllager;
    private ForgeConfigSpec.BooleanValue enableDamageVillager;
    private ForgeConfigSpec.BooleanValue treasureDamageVillager;
    private ForgeConfigSpec.IntValue levelDamageVillager;
    private ForgeConfigSpec.BooleanValue dropsDamageVillager;
    private ForgeConfigSpec.BooleanValue enableCavalier;
    private ForgeConfigSpec.BooleanValue treasureCavalier;
    private ForgeConfigSpec.IntValue levelCavalier;
    private ForgeConfigSpec.BooleanValue enableFrostAspect;
    private ForgeConfigSpec.BooleanValue treasureFrostAspect;
    private ForgeConfigSpec.IntValue levelFrostAspect;
    private ForgeConfigSpec.BooleanValue enableInstigating;
    private ForgeConfigSpec.BooleanValue treasureInstigating;
    private ForgeConfigSpec.BooleanValue enableLeech;
    private ForgeConfigSpec.BooleanValue treasureLeech;
    private ForgeConfigSpec.IntValue levelLeech;
    private ForgeConfigSpec.BooleanValue enableMagicEdge;
    private ForgeConfigSpec.BooleanValue treasureMagicEdge;
    private ForgeConfigSpec.IntValue levelMagicEdge;
    private ForgeConfigSpec.BooleanValue enableVorpal;
    private ForgeConfigSpec.BooleanValue treasureVorpal;
    private ForgeConfigSpec.IntValue levelVorpal;
    private ForgeConfigSpec.IntValue critBaseVorpal;
    private ForgeConfigSpec.IntValue critLevelVorpal;
    private ForgeConfigSpec.IntValue critDamageVorpal;
    private ForgeConfigSpec.IntValue headBaseVorpal;
    private ForgeConfigSpec.IntValue headLevelVorpal;
    private ForgeConfigSpec.BooleanValue enableExcavating;
    private ForgeConfigSpec.BooleanValue treasureExcavating;
    private ForgeConfigSpec.BooleanValue enableHunter;
    private ForgeConfigSpec.BooleanValue treasureHunter;
    private ForgeConfigSpec.IntValue levelHunter;
    private ForgeConfigSpec.IntValue chanceHunter;
    private ForgeConfigSpec.BooleanValue enableQuickDraw;
    private ForgeConfigSpec.BooleanValue treasureQuickDraw;
    private ForgeConfigSpec.IntValue levelQuickDraw;
    private ForgeConfigSpec.BooleanValue enableTrueshot;
    private ForgeConfigSpec.BooleanValue treasureTrueshot;
    private ForgeConfigSpec.IntValue levelTrueshot;
    private ForgeConfigSpec.BooleanValue enableVolley;
    private ForgeConfigSpec.BooleanValue treasureVolley;
    private ForgeConfigSpec.BooleanValue enableAngler;
    private ForgeConfigSpec.BooleanValue treasureAngler;
    private ForgeConfigSpec.IntValue levelAngler;
    private ForgeConfigSpec.IntValue chanceAngler;
    private ForgeConfigSpec.BooleanValue enablePilfering;
    private ForgeConfigSpec.BooleanValue treasurePilfering;
    private ForgeConfigSpec.BooleanValue playerStealPilfering;
    private ForgeConfigSpec.BooleanValue enableFurrowing;
    private ForgeConfigSpec.BooleanValue treasureFurrowing;
    private ForgeConfigSpec.IntValue levelFurrowing;
    private ForgeConfigSpec.BooleanValue enableTilling;
    private ForgeConfigSpec.BooleanValue treasureTilling;
    private ForgeConfigSpec.IntValue levelTilling;
    private ForgeConfigSpec.BooleanValue enableWeeding;
    private ForgeConfigSpec.BooleanValue treasureWeeding;
    private ForgeConfigSpec.BooleanValue enableBulwark;
    private ForgeConfigSpec.BooleanValue treasureBulwark;
    private ForgeConfigSpec.BooleanValue enablePhalanx;
    private ForgeConfigSpec.BooleanValue treasurePhalanx;
    private ForgeConfigSpec.IntValue levelPhalanx;
    private ForgeConfigSpec.BooleanValue enableSoulbound;
    private ForgeConfigSpec.BooleanValue treasureSoulbound;
    private ForgeConfigSpec.IntValue levelSoulbound;
    private ForgeConfigSpec.BooleanValue permanentSoulbound;
    private ForgeConfigSpec.BooleanValue enableCurseFool;
    private ForgeConfigSpec.BooleanValue enableCurseMercy;

    public void apply(ForgeConfigSpec.Builder builder) {
        String treasure = "This sets whether or not the Enchantment is considered a 'treasure' enchantment.";
        String level = "This option adjusts the maximum allowable level for the Enchantment.";
        builder.push("Enchantments");
        builder.push("Magic Protection");
        this.enableProtectionMagic = builder.comment("If TRUE, the Magic Protection Enchantment is available for Armor and Horse Armor.").define("Enable", true);
        this.treasureProtectionMagic = builder.comment(treasure).define("Treasure", false);
        this.levelProtectionMagic = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Displacement");
        this.enableDisplacement = builder.comment("If TRUE, the Displacement Enchantment is available for Armor, Shields, and Horse Armor.").define("Enable", false);
        this.treasureDisplacement = builder.comment(treasure).define("Treasure", true);
        this.levelDisplacement = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.chanceDisplacement = builder.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 20, 1, 100);
        this.allowMobsDisplacement = builder.comment("If TRUE, mobs wearing armor with this Enchantment can teleport players.").define("Mobs Teleport Players", DisplacementEnchantment.mobsAffectPlayers);
        builder.pop();
        builder.push("Flaming Rebuke");
        this.enableFireRebuke = builder.comment("If TRUE, the Flaming Rebuke Enchantment is available for Armor, Shields, and Horse Armor.").define("Enable", false);
        this.treasureFireRebuke = builder.comment(treasure).define("Treasure", true);
        this.levelFireRebuke = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.chanceFireRebuke = builder.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 20, 1, 100);
        this.allowMobsFireRebuke = builder.comment("If TRUE, mobs wearing armor with this Enchantment can knockback players.").define("Mobs Knockback Players", FireRebukeEnchantment.mobsAffectPlayers);
        builder.pop();
        builder.push("Chilling Rebuke");
        this.enableFrostRebuke = builder.comment("If TRUE, the Chilling Rebuke Enchantment is available for Armor, Shields, and Horse Armor.").define("Enable", false);
        this.treasureFrostRebuke = builder.comment(treasure).define("Treasure", true);
        this.levelFrostRebuke = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.chanceFrostRebuke = builder.comment("Adjust this value to set the chance per level of the Enchantment firing (in percentage).").defineInRange("Effect Chance", 20, 1, 100);
        this.allowMobsFrostRebuke = builder.comment("If TRUE, mobs wearing armor with this Enchantment can knockback players.").define("Mobs Knockback Players", FrostRebukeEnchantment.mobsAffectPlayers);
        builder.pop();
        builder.push("Air Affinity");
        this.enableAirAffinity = builder.comment("If TRUE, the Air Affinity Enchantment is available for Helmets.").define("Enable", true);
        this.treasureAirAffinity = builder.comment(treasure).define("Treasure", false);
        builder.pop();
        builder.push("Insight");
        this.enableXpBoost = builder.comment("If TRUE, the Insight Enchantment is available for Helmets.").define("Enable", true);
        this.treasureXpBoost = builder.comment(treasure).define("Treasure", false);
        this.levelXpBoost = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.amountXpBoost = builder.comment("Adjust this to change the max experience awarded per level of the Enchantment.").defineInRange("Experience Amount", 4, 1, 1000);
        builder.pop();
        builder.push("Gourmand");
        this.enableGourmand = builder.comment("If TRUE, the Gourmand Enchantment is available for Helmets.").define("Enable", false);
        this.treasureGourmand = builder.comment(treasure).define("Treasure", false);
        this.levelGourmand = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Reach");
        this.enableReach = builder.comment("If TRUE, the Reach Enchantment is available for Chestplates.").define("Enable", true);
        this.treasureReach = builder.comment(treasure).define("Treasure", true);
        this.levelReach = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        builder.pop();
        builder.push("Vitality");
        this.enableVitality = builder.comment("If TRUE, the Vitality Enchantment is available for Chestplates.").define("Enable", true);
        this.treasureVitality = builder.comment(treasure).define("Treasure", true);
        this.levelVitality = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.healthLevelVitality = builder.comment("Adjust this value to set the health granted per level of the Enchantment. (There are 2 health per heart icon.)").defineInRange("Health / Level", 4, 1, 10);
        builder.pop();
        builder.push("Ender Disruption");
        this.enableDamageEnder = builder.comment("If TRUE, the Ender Disruption Enchantment is available for various Weapons.").define("Enable", false);
        this.treasureDamageEnder = builder.comment(treasure).define("Treasure", true);
        this.levelDamageEnder = builder.comment(level).defineInRange("Max Level", 5, 1, 10);
        builder.pop();
        builder.push("Vigilante");
        this.enableDamageIllager = builder.comment("If TRUE, the Vigilante Enchantment is available for various Weapons.").define("Enable", true);
        this.treasureDamageIllager = builder.comment(treasure).define("Treasure", true);
        this.levelDamageIllager = builder.comment(level).defineInRange("Max Level", 5, 1, 10);
        builder.pop();
        builder.push("Outlaw");
        this.enableDamageVillager = builder.comment("If TRUE, the Outlaw Enchantment is available for various Weapons.").define("Enable", false);
        this.treasureDamageVillager = builder.comment(treasure).define("Treasure", false);
        this.levelDamageVillager = builder.comment(level).defineInRange("Max Level", 5, 1, 10);
        this.dropsDamageVillager = builder.comment("If TRUE, the Outlaw Enchantment causes Villagers (and Iron Golems) to drop Emeralds when killed.").define("Emerald Drops", true);
        builder.pop();
        builder.push("Cavalier");
        this.enableCavalier = builder.comment("If TRUE, the Cavalier Enchantment is available for various Weapons.").define("Enable", false);
        this.treasureCavalier = builder.comment(treasure).define("Treasure", true);
        this.levelCavalier = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        builder.pop();
        builder.push("Frost Aspect");
        this.enableFrostAspect = builder.comment("If TRUE, the Frost Aspect Enchantment is available for various Weapons.").define("Enable", true);
        this.treasureFrostAspect = builder.comment(treasure).define("Treasure", true);
        this.levelFrostAspect = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Instigating");
        this.enableInstigating = builder.comment("If TRUE, the Instigating Enchantment is available for various Weapons.").define("Enable", false);
        this.treasureInstigating = builder.comment(treasure).define("Treasure", true);
        builder.pop();
        builder.push("Leech");
        this.enableLeech = builder.comment("If TRUE, the Leech Enchantment is available for various Weapons.").define("Enable", true);
        this.treasureLeech = builder.comment(treasure).define("Treasure", false);
        this.levelLeech = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.push("Magic Edge");
        this.enableMagicEdge = builder.comment("If TRUE, the Magic Edge Enchantment is available for various Weapons.").define("Enable", false);
        this.treasureMagicEdge = builder.comment(treasure).define("Treasure", true);
        this.levelMagicEdge = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        builder.pop();
        builder.push("Vorpal");
        this.enableVorpal = builder.comment("If TRUE, the Vorpal Enchantment is available for various Weapons.").define("Enable", true);
        this.treasureVorpal = builder.comment(treasure).define("Treasure", true);
        this.levelVorpal = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        this.critBaseVorpal = builder.comment("Adjust this value to set the base critical hit chance of the Enchantment (in percentage).").defineInRange("Base Critical Chance", 5, 0, 100);
        this.critLevelVorpal = builder.comment("Adjust this value to set the additional critical hit chance per level of the Enchantment (in percentage).").defineInRange("Critical Chance / Level", 5, 0, 100);
        this.critDamageVorpal = builder.comment("Adjust this value to set the critical hit damage multiplier.").defineInRange("Critical Damage Multiplier", 5, 0, 1000);
        this.headBaseVorpal = builder.comment("Adjust this value to set the base head drop chance for the Enchantment (in percentage).").defineInRange("Base Head Drop Chance", 10, 0, 100);
        this.headLevelVorpal = builder.comment("Adjust this value to set the head drop chance per level of the Enchantment (in percentage).").defineInRange("Head Drop Chance / Level", 10, 0, 100);
        builder.pop();
        builder.push("Excavating");
        this.enableExcavating = builder.comment("If TRUE, the Excavating Enchantment is available for various Tools.").define("Enable", true);
        this.treasureExcavating = builder.comment(treasure).define("Treasure", true);
        builder.pop();
        builder.push("Hunter's Bounty");
        this.enableHunter = builder.comment("If TRUE, the Hunter's Bounty Enchantment is available for Bows.").define("Enable", true);
        this.treasureHunter = builder.comment(treasure).define("Treasure", true);
        this.levelHunter = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        this.chanceHunter = builder.comment("Adjust this value to set the chance of an additional drop per level of the Enchantment (in percentage).").defineInRange("Effect Chance", 50, 1, 100);
        builder.pop();
        builder.push("Quick Draw");
        this.enableQuickDraw = builder.comment("If TRUE, the Quick Draw Enchantment is available for various Bows.").define("Enable", true);
        this.treasureQuickDraw = builder.comment(treasure).define("Treasure", false);
        this.levelQuickDraw = builder.comment(level).defineInRange("Max Level", 3, 1, 10);
        builder.pop();
        builder.push("Trueshot");
        this.enableTrueshot = builder.comment("If TRUE, the Trueshot Enchantment is available for various Bows.").define("Enable", true);
        this.treasureTrueshot = builder.comment(treasure).define("Treasure", false);
        this.levelTrueshot = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Volley");
        this.enableVolley = builder.comment("If TRUE, the Volley Enchantment is available for various Bows.").define("Enable", true);
        this.treasureVolley = builder.comment(treasure).define("Treasure", false);
        builder.pop();
        builder.push("Angler's Bounty");
        this.enableAngler = builder.comment("If TRUE, the Angler's Bounty Enchantment is available for Fishing Rods.").define("Enable", true);
        this.treasureAngler = builder.comment(treasure).define("Treasure", true);
        this.levelAngler = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        this.chanceAngler = builder.comment("Adjust this value to set the chance of an additional drop per level of the Enchantment (in percentage).").defineInRange("Effect Chance", 50, 1, 100);
        builder.pop();
        builder.push("Pilfering");
        this.enablePilfering = builder.comment("If TRUE, the Pilfering Enchantment is available for Fishing Rods.").define("Enable", false);
        this.treasurePilfering = builder.comment(treasure).define("Treasure", true);
        this.playerStealPilfering = builder.comment("This sets whether or not the Enchantment works on Players.").define("Allow Player Stealing", true);
        builder.pop();
        builder.push("Bulwark");
        this.enableBulwark = builder.comment("If TRUE, the Bulwark Enchantment is available for Shields.").define("Enable", true);
        this.treasureBulwark = builder.comment(treasure).define("Treasure", false);
        builder.pop();
        builder.push("Phalanx");
        this.enablePhalanx = builder.comment("If TRUE, the Phalanx Enchantment is available for Shields.").define("Enable", true);
        this.treasurePhalanx = builder.comment(treasure).define("Treasure", false);
        this.levelPhalanx = builder.comment(level).defineInRange("Max Level", 2, 1, 10);
        builder.pop();
        builder.push("Soulbound");
        this.enableSoulbound = builder.comment("If TRUE, the Soulbound Enchantment is available.").define("Enable", true);
        this.treasureSoulbound = builder.comment(treasure).define("Treasure", false);
        this.levelSoulbound = builder.comment("This option adjusts the maximum allowable level for the Enchantment. If permanent, this setting is ignored.").defineInRange("Max Level", 3, 1, 10);
        this.permanentSoulbound = builder.comment("If TRUE, the Soulbound Enchantment is permanent (and will remove excess levels when triggered).").define("Permanent", true);
        builder.pop();
        builder.push("Curse of Foolishness");
        this.enableCurseFool = builder.comment("If TRUE, the Curse of Foolishness Enchantment is available for Helmets.").define("Enable", true);
        builder.pop();
        builder.push("Curse of Mercy");
        this.enableCurseMercy = builder.comment("If TRUE, the Curse of Mercy Enchantment is available for various Weapons.").define("Enable", true);
        builder.pop();
        builder.pop();
    }

    public void refresh() {
        if (EnsorcReferences.PROTECTION_MAGIC instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.PROTECTION_MAGIC).setEnable(((Boolean)this.enableProtectionMagic.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.PROTECTION_MAGIC).setTreasureEnchantment(((Boolean)this.treasureProtectionMagic.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.PROTECTION_MAGIC).setMaxLevel(((Integer)this.levelProtectionMagic.get()).intValue());
        }
        if (EnsorcReferences.DISPLACEMENT instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.DISPLACEMENT).setEnable(((Boolean)this.enableDisplacement.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DISPLACEMENT).setTreasureEnchantment(((Boolean)this.treasureDisplacement.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DISPLACEMENT).setMaxLevel(((Integer)this.levelDisplacement.get()).intValue());
            DisplacementEnchantment.chance = (Integer)this.chanceDisplacement.get();
            DisplacementEnchantment.mobsAffectPlayers = (Boolean)this.allowMobsDisplacement.get();
        }
        if (EnsorcReferences.FIRE_REBUKE instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.FIRE_REBUKE).setEnable(((Boolean)this.enableFireRebuke.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FIRE_REBUKE).setTreasureEnchantment(((Boolean)this.treasureFireRebuke.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FIRE_REBUKE).setMaxLevel(((Integer)this.levelFireRebuke.get()).intValue());
            FireRebukeEnchantment.chance = (Integer)this.chanceFireRebuke.get();
            FireRebukeEnchantment.mobsAffectPlayers = (Boolean)this.allowMobsFireRebuke.get();
        }
        if (EnsorcReferences.FROST_REBUKE instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.FROST_REBUKE).setEnable(((Boolean)this.enableFrostRebuke.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FROST_REBUKE).setTreasureEnchantment(((Boolean)this.treasureFrostRebuke.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FROST_REBUKE).setMaxLevel(((Integer)this.levelFrostRebuke.get()).intValue());
            FrostRebukeEnchantment.chance = (Integer)this.chanceFrostRebuke.get();
            FrostRebukeEnchantment.mobsAffectPlayers = (Boolean)this.allowMobsFrostRebuke.get();
        }
        if (EnsorcReferences.AIR_AFFINITY instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.AIR_AFFINITY).setEnable(((Boolean)this.enableAirAffinity.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.AIR_AFFINITY).setTreasureEnchantment(((Boolean)this.treasureAirAffinity.get()).booleanValue());
        }
        if (EnsorcReferences.XP_BOOST instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.XP_BOOST).setEnable(((Boolean)this.enableXpBoost.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.XP_BOOST).setTreasureEnchantment(((Boolean)this.treasureXpBoost.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.XP_BOOST).setMaxLevel(((Integer)this.levelXpBoost.get()).intValue());
            XpBoostEnchantment.xp = (Integer)this.amountXpBoost.get();
        }
        if (EnsorcReferences.GOURMAND instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.GOURMAND).setEnable(((Boolean)this.enableGourmand.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.GOURMAND).setTreasureEnchantment(((Boolean)this.treasureGourmand.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.GOURMAND).setMaxLevel(((Integer)this.levelGourmand.get()).intValue());
        }
        if (EnsorcReferences.REACH instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.REACH).setEnable(((Boolean)this.enableReach.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.REACH).setTreasureEnchantment(((Boolean)this.treasureReach.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.REACH).setMaxLevel(((Integer)this.levelReach.get()).intValue());
        }
        if (EnsorcReferences.VITALITY instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.VITALITY).setEnable(((Boolean)this.enableVitality.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.VITALITY).setTreasureEnchantment(((Boolean)this.treasureVitality.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.VITALITY).setMaxLevel(((Integer)this.levelVitality.get()).intValue());
            VitalityEnchantment.health = (Integer)this.healthLevelVitality.get();
        }
        if (EnsorcReferences.DAMAGE_ENDER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ENDER).setEnable(((Boolean)this.enableDamageEnder.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ENDER).setTreasureEnchantment(((Boolean)this.treasureDamageEnder.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ENDER).setMaxLevel(((Integer)this.levelDamageEnder.get()).intValue());
        }
        if (EnsorcReferences.DAMAGE_ILLAGER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ILLAGER).setEnable(((Boolean)this.enableDamageIllager.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ILLAGER).setTreasureEnchantment(((Boolean)this.treasureDamageIllager.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_ILLAGER).setMaxLevel(((Integer)this.levelDamageIllager.get()).intValue());
        }
        if (EnsorcReferences.DAMAGE_VILLAGER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_VILLAGER).setEnable(((Boolean)this.enableDamageVillager.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_VILLAGER).setTreasureEnchantment(((Boolean)this.treasureDamageVillager.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.DAMAGE_VILLAGER).setMaxLevel(((Integer)this.levelDamageVillager.get()).intValue());
            DamageVillagerEnchantment.enableEmeraldDrops = (Boolean)this.dropsDamageVillager.get();
        }
        if (EnsorcReferences.CAVALIER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.CAVALIER).setEnable(((Boolean)this.enableCavalier.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.CAVALIER).setTreasureEnchantment(((Boolean)this.treasureCavalier.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.CAVALIER).setMaxLevel(((Integer)this.levelCavalier.get()).intValue());
        }
        if (EnsorcReferences.FROST_ASPECT instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.FROST_ASPECT).setEnable(((Boolean)this.enableFrostAspect.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FROST_ASPECT).setTreasureEnchantment(((Boolean)this.treasureFrostAspect.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FROST_ASPECT).setMaxLevel(((Integer)this.levelFrostAspect.get()).intValue());
        }
        if (EnsorcReferences.INSTIGATING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.INSTIGATING).setEnable(((Boolean)this.enableInstigating.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.INSTIGATING).setTreasureEnchantment(((Boolean)this.treasureInstigating.get()).booleanValue());
        }
        if (EnsorcReferences.LEECH instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.LEECH).setEnable(((Boolean)this.enableLeech.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.LEECH).setTreasureEnchantment(((Boolean)this.treasureLeech.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.LEECH).setMaxLevel(((Integer)this.levelLeech.get()).intValue());
        }
        if (EnsorcReferences.MAGIC_EDGE instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.MAGIC_EDGE).setEnable(((Boolean)this.enableMagicEdge.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.MAGIC_EDGE).setTreasureEnchantment(((Boolean)this.treasureMagicEdge.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.MAGIC_EDGE).setMaxLevel(((Integer)this.levelMagicEdge.get()).intValue());
        }
        if (EnsorcReferences.VORPAL instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.VORPAL).setEnable(((Boolean)this.enableVorpal.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.VORPAL).setTreasureEnchantment(((Boolean)this.treasureVorpal.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.VORPAL).setMaxLevel(((Integer)this.levelVorpal.get()).intValue());
            VorpalEnchantment.critBase = (Integer)this.critBaseVorpal.get();
            VorpalEnchantment.critLevel = (Integer)this.critLevelVorpal.get();
            VorpalEnchantment.critDamage = (Integer)this.critDamageVorpal.get();
            VorpalEnchantment.headBase = (Integer)this.headBaseVorpal.get();
            VorpalEnchantment.headLevel = (Integer)this.headLevelVorpal.get();
        }
        if (EnsorcReferences.EXCAVATING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.EXCAVATING).setEnable(((Boolean)this.enableExcavating.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.EXCAVATING).setTreasureEnchantment(((Boolean)this.treasureExcavating.get()).booleanValue());
        }
        if (EnsorcReferences.HUNTER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.HUNTER).setEnable(((Boolean)this.enableHunter.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.HUNTER).setTreasureEnchantment(((Boolean)this.treasureHunter.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.HUNTER).setMaxLevel(((Integer)this.levelHunter.get()).intValue());
            HunterEnchantment.chance = (Integer)this.chanceHunter.get();
        }
        if (EnsorcReferences.QUICK_DRAW instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.QUICK_DRAW).setEnable(((Boolean)this.enableQuickDraw.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.QUICK_DRAW).setTreasureEnchantment(((Boolean)this.treasureQuickDraw.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.QUICK_DRAW).setMaxLevel(((Integer)this.levelQuickDraw.get()).intValue());
        }
        if (EnsorcReferences.TRUESHOT instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.TRUESHOT).setEnable(((Boolean)this.enableTrueshot.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.TRUESHOT).setTreasureEnchantment(((Boolean)this.treasureTrueshot.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.TRUESHOT).setMaxLevel(((Integer)this.levelTrueshot.get()).intValue());
        }
        if (EnsorcReferences.VOLLEY instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.VOLLEY).setEnable(((Boolean)this.enableVolley.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.VOLLEY).setTreasureEnchantment(((Boolean)this.treasureVolley.get()).booleanValue());
        }
        if (EnsorcReferences.ANGLER instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.ANGLER).setEnable(((Boolean)this.enableAngler.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.ANGLER).setTreasureEnchantment(((Boolean)this.treasureAngler.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.ANGLER).setMaxLevel(((Integer)this.levelAngler.get()).intValue());
            AnglerEnchantment.chance = (Integer)this.chanceAngler.get();
        }
        if (EnsorcReferences.PILFERING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.PILFERING).setEnable(((Boolean)this.enablePilfering.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.PILFERING).setTreasureEnchantment(((Boolean)this.treasurePilfering.get()).booleanValue());
            PilferingEnchantment.allowPlayerStealing = (Boolean)this.playerStealPilfering.get();
        }
        if (EnsorcReferences.FURROWING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.FURROWING).setEnable(((Boolean)this.enableFurrowing.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FURROWING).setTreasureEnchantment(((Boolean)this.treasureFurrowing.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.FURROWING).setMaxLevel(((Integer)this.levelFurrowing.get()).intValue());
        }
        if (EnsorcReferences.TILLING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.TILLING).setEnable(((Boolean)this.enableTilling.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.TILLING).setTreasureEnchantment(((Boolean)this.treasureTilling.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.TILLING).setMaxLevel(((Integer)this.levelTilling.get()).intValue());
        }
        if (EnsorcReferences.WEEDING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.WEEDING).setEnable(((Boolean)this.enableWeeding.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.WEEDING).setTreasureEnchantment(((Boolean)this.treasureWeeding.get()).booleanValue());
        }
        if (EnsorcReferences.BULWARK instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.BULWARK).setEnable(((Boolean)this.enableBulwark.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.BULWARK).setTreasureEnchantment(((Boolean)this.treasureBulwark.get()).booleanValue());
        }
        if (EnsorcReferences.PHALANX instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.PHALANX).setEnable(((Boolean)this.enablePhalanx.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.PHALANX).setTreasureEnchantment(((Boolean)this.treasurePhalanx.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.PHALANX).setMaxLevel(((Integer)this.levelPhalanx.get()).intValue());
        }
        if (EnsorcReferences.SOULBOUND instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.SOULBOUND).setEnable(((Boolean)this.enableSoulbound.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.SOULBOUND).setTreasureEnchantment(((Boolean)this.treasureSoulbound.get()).booleanValue());
            ((EnchantmentCoFH)EnsorcReferences.SOULBOUND).setMaxLevel(((Integer)this.levelSoulbound.get()).intValue());
            SoulboundEnchantment.permanent = (Boolean)this.permanentSoulbound.get();
        }
        if (EnsorcReferences.CURSE_FOOL instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.CURSE_FOOL).setEnable(((Boolean)this.enableCurseFool.get()).booleanValue());
        }
        if (EnsorcReferences.CURSE_MERCY instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)EnsorcReferences.CURSE_MERCY).setEnable(((Boolean)this.enableCurseMercy.get()).booleanValue());
        }
    }
}

