/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building.view;

import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.util.spliterator.MappingSpliterator;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public final class PositionalBuildView
implements IBuildView {
    private Map<BlockPos, BlockData> map;
    private Region boundingBox;
    private BlockPos translation;
    private BuildContext context;

    public static PositionalBuildView createUnsafe(BuildContext context, Map<BlockPos, BlockData> map, Region boundingBox) {
        return new PositionalBuildView(Objects.requireNonNull(context, "Cannot have a PositionalBuildView without BuildContext!"), Objects.requireNonNull(map, "Cannot have a PositionalBuildView without position to data map!"), Objects.requireNonNull(boundingBox, "Cannot have a PositionalBuildView without a boundingBox!"));
    }

    private PositionalBuildView(BuildContext context, Map<BlockPos, BlockData> map, Region boundingBox) {
        this.context = context;
        this.map = map;
        this.boundingBox = boundingBox;
        this.translation = BlockPos.f_121853_;
    }

    @Override
    public Spliterator<PlacementTarget> spliterator() {
        BlockPos translation = this.translation;
        return new MappingSpliterator<Map.Entry, PlacementTarget>(this.map.entrySet().spliterator(), e -> new PlacementTarget(((BlockPos)e.getKey()).m_141952_((Vec3i)translation), (BlockData)e.getValue()));
    }

    @Override
    public PositionalBuildView translateTo(BlockPos pos) {
        this.boundingBox = this.boundingBox.translate((Vec3i)pos.m_141950_((Vec3i)this.translation));
        this.translation = pos;
        return this;
    }

    @Override
    public int estimateSize() {
        return this.map.size();
    }

    @Override
    public PositionalBuildView copy() {
        return new PositionalBuildView(this.context, this.map, this.boundingBox);
    }

    @Override
    public Region getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public BuildContext getContext() {
        return this.context;
    }

    public ImmutableMap<BlockPos, BlockData> getMap() {
        return ImmutableMap.copyOf(this.map);
    }
}

