/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.ScrollingMaterialList;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.lang.MaterialListTranslation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.LazyOptional;

public class MaterialListGUI
extends Screen
implements ITemplateProvider.IUpdateListener {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTONS_PADDING = 4;
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("buildinggadgets", "textures/gui/material_list.png");
    public static final int BACKGROUND_WIDTH = 256;
    public static final int BACKGROUND_HEIGHT = 200;
    public static final int BORDER_SIZE = 4;
    public static final int WINDOW_WIDTH = 248;
    public static final int WINDOW_HEIGHT = 192;
    private int backgroundX;
    private int backgroundY;
    private ItemStack item;
    private String title;
    private int titleLeft;
    private int titleTop;
    private ScrollingMaterialList scrollingList;
    private Button buttonClose;
    private Button buttonSortingModes;
    private Button buttonCopyList;
    private int hoveringTextX;
    private int hoveringTextY;
    private List<Component> hoveringText;
    private TemplateHeader header;

    public MaterialListGUI(ItemStack item) {
        super((Component)MaterialListTranslation.TITLE.componentTranslation(new Object[0]));
        Preconditions.checkArgument((boolean)item.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).isPresent());
        this.item = item;
    }

    public void m_7856_() {
        this.backgroundX = MaterialListGUI.getXForAlignedCenter(0, this.f_96543_, 256);
        this.backgroundY = MaterialListGUI.getYForAlignedCenter(0, this.f_96544_, 200);
        this.header = this.evaluateTemplateHeader();
        this.evaluateTitle();
        this.scrollingList = new ScrollingMaterialList(this);
        this.m_7522_((GuiEventListener)this.scrollingList);
        this.m_142416_((GuiEventListener)this.scrollingList);
        int buttonY = this.getWindowBottomY() - 26;
        this.buttonClose = new Button(0, buttonY, 0, 20, (Component)MaterialListTranslation.BUTTON_CLOSE.componentTranslation(new Object[0]), b -> this.getMinecraft().f_91074_.m_6915_());
        this.buttonSortingModes = new Button(0, buttonY, 0, 20, (Component)this.scrollingList.getSortingMode().getTranslationProvider().componentTranslation(new Object[0]), button -> {
            this.scrollingList.setSortingMode(this.scrollingList.getSortingMode().next());
            this.buttonSortingModes.m_93666_((Component)this.scrollingList.getSortingMode().getTranslationProvider().componentTranslation(new Object[0]));
        });
        this.buttonCopyList = new Button(0, buttonY, 0, 20, (Component)MaterialListTranslation.BUTTON_COPY.componentTranslation(new Object[0]), button -> {
            this.getMinecraft().f_91068_.m_90911_(this.evaluateTemplateHeader().toJson(false, MaterialListGUI.m_96637_()));
            if (this.getMinecraft().f_91074_ != null) {
                this.getMinecraft().f_91074_.m_5661_((Component)new TranslatableComponent(MaterialListTranslation.MESSAGE_COPY_SUCCESS.getTranslationKey()), true);
            }
        });
        this.m_142416_((GuiEventListener)this.buttonSortingModes);
        this.m_142416_((GuiEventListener)this.buttonCopyList);
        this.m_142416_((GuiEventListener)this.buttonClose);
        this.calculateButtonsWidthAndX();
    }

    public TemplateHeader evaluateTemplateHeader() {
        Template template = this.getTemplateCapability();
        BuildContext context = BuildContext.builder().player((Player)this.getMinecraft().f_91074_).stack(this.getTemplateItem()).build((LevelAccessor)this.getMinecraft().f_91073_);
        return template.getHeaderAndForceMaterials(context);
    }

    public TemplateHeader getHeader() {
        return this.header;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float particleTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        this.m_93228_(matrices, this.backgroundX, this.backgroundY, 0, 0, 256, 200);
        this.scrollingList.m_6305_(matrices, mouseX, mouseY, particleTicks);
        MaterialListGUI.m_93236_((PoseStack)matrices, (Font)this.f_96547_, (String)this.title, (int)this.titleLeft, (int)this.titleTop, (int)Color.WHITE.getRGB());
        super.m_6305_(matrices, mouseX, mouseY, particleTicks);
        if (this.buttonCopyList.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96617_(matrices, Lists.transform((List)ImmutableList.of((Object)MaterialListTranslation.HELP_COPY_LIST.componentTranslation(new Object[0])), Component::m_7532_), mouseX, mouseY);
        } else if (this.hoveringText != null) {
            this.m_96617_(matrices, Lists.transform(this.hoveringText, Component::m_7532_), mouseX, mouseY);
            this.hoveringText = null;
        }
    }

    private void calculateButtonsWidthAndX() {
        int amountButtons = (int)this.m_6702_().stream().filter(e -> e instanceof Button).count();
        int amountMargins = amountButtons - 1;
        int totalMarginWidth = amountMargins * 4;
        int usableWidth = this.getWindowWidth();
        int buttonWidth = (usableWidth - totalMarginWidth) / amountButtons;
        int nextX = this.getWindowLeftX();
        for (GuiEventListener widget : this.m_6702_()) {
            if (!(widget instanceof Button)) continue;
            Button btn = (Button)widget;
            btn.m_93674_(buttonWidth);
            btn.f_93620_ = nextX;
            nextX += buttonWidth + 4;
        }
    }

    public Template getTemplateCapability() {
        if (this.getMinecraft().f_91073_ == null || this.getMinecraft().f_91074_ == null) {
            return null;
        }
        LazyOptional providerCap = this.getMinecraft().f_91073_.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY);
        if (providerCap.isPresent()) {
            LazyOptional keyCap = this.item.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY);
            ITemplateProvider provider = (ITemplateProvider)providerCap.orElseThrow(RuntimeException::new);
            if (keyCap.isPresent()) {
                provider.registerUpdateListener(this);
                ITemplateKey key = (ITemplateKey)keyCap.orElseThrow(RuntimeException::new);
                return provider.getTemplateForKey(key);
            }
            BuildingGadgets.LOG.warn("Item used for material list does not have an ITemplateKey capability!");
            this.getMinecraft().f_91074_.m_6915_();
            return null;
        }
        BuildingGadgets.LOG.warn("Client world used for material list does not have an ITemplateProvider capability!");
        this.getMinecraft().f_91074_.m_6915_();
        return null;
    }

    public void setTaskHoveringText(int x, int y, List<Component> text) {
        this.hoveringTextX = x;
        this.hoveringTextY = y;
        this.hoveringText = text;
    }

    @Override
    public void onTemplateUpdate(ITemplateProvider provider, ITemplateKey key, Template template) {
        this.item.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(itemKey -> {
            UUID itemId;
            UUID keyId = provider.getId(key);
            if (keyId.equals(itemId = provider.getId((ITemplateKey)itemKey))) {
                this.header = this.evaluateTemplateHeader();
                this.evaluateTitle();
                this.scrollingList.reset();
            }
        });
    }

    private void evaluateTitle() {
        String name = this.getHeader().getName();
        String author = this.getHeader().getAuthor();
        this.title = name == null && author == null ? MaterialListTranslation.TITLE_EMPTY.format(new Object[0]) : (name == null ? MaterialListTranslation.TITLE_AUTHOR_ONLY.format(author) : (author == null ? MaterialListTranslation.TITLE_NAME_ONLY.format(name) : MaterialListTranslation.TITLE.format(name, author)));
        int n = this.getWindowTopY() + 16;
        Objects.requireNonNull(this.f_96547_);
        this.titleTop = MaterialListGUI.getYForAlignedCenter(this.backgroundY, n, 9);
        this.titleLeft = MaterialListGUI.getXForAlignedCenter(this.backgroundX, this.getWindowRightX(), this.f_96547_.m_92895_(this.title));
    }

    public boolean m_7043_() {
        return false;
    }

    public int getWindowLeftX() {
        return this.backgroundX + 4;
    }

    public int getWindowRightX() {
        return this.backgroundX + 256 - 4;
    }

    public int getWindowTopY() {
        return this.backgroundY + 4;
    }

    public int getWindowBottomY() {
        return this.backgroundY + 200 - 4;
    }

    public int getWindowWidth() {
        return 248;
    }

    public int getWindowHeight() {
        return 192;
    }

    public ItemStack getTemplateItem() {
        return this.item;
    }

    public static int getXForAlignedRight(int right, int width) {
        return right - width;
    }

    public static int getXForAlignedCenter(int left, int right, int width) {
        return left + (right - left) / 2 - width / 2;
    }

    public static int getYForAlignedCenter(int top, int bottom, int height) {
        return top + (bottom - top) / 2 - height / 2;
    }

    public static void renderTextVerticalCenter(PoseStack matrices, String text, int leftX, int top, int bottom, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(fontRenderer);
        int y = MaterialListGUI.getYForAlignedCenter(top, bottom, 9);
        RenderSystem.m_69493_();
        fontRenderer.m_92883_(matrices, text, (float)leftX, (float)y, color);
    }

    public static void renderTextHorizontalRight(PoseStack matrices, String text, int right, int y, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int x = MaterialListGUI.getXForAlignedRight(right, fontRenderer.m_92895_(text));
        RenderSystem.m_69493_();
        fontRenderer.m_92883_(matrices, text, (float)x, (float)y, color);
    }

    public static boolean isPointInBox(double x, double y, int bx, int by, int width, int height) {
        return x >= (double)bx && y >= (double)by && x < (double)(bx + width) && y < (double)(by + height);
    }
}

