/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renders;

import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.RecordingItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class BuildRender
extends BaseRenderer {
    private final boolean isExchanger;
    private static final BlockState DEFAULT_EFFECT_BLOCK = ((Block)OurBlocks.EFFECT_BLOCK.get()).m_49966_();

    public BuildRender(boolean isExchanger) {
        this.isExchanger = isExchanger;
    }

    @Override
    public void render(RenderLevelLastEvent evt, Player player, ItemStack heldItem) {
        super.render(evt, player, heldItem);
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, heldItem);
        BlockState state = AIR;
        Optional<List<BlockPos>> anchor = GadgetUtils.getAnchor(heldItem);
        BlockState startBlock = player.f_19853_.m_8055_(lookingAt.m_82425_());
        if (player.f_19853_.m_46859_(lookingAt.m_82425_()) && !anchor.isPresent() || startBlock == DEFAULT_EFFECT_BLOCK) {
            return;
        }
        BlockData data = GadgetUtils.getToolBlock(heldItem);
        BlockState renderBlockState = data.getState();
        if (renderBlockState == BaseRenderer.AIR) {
            return;
        }
        List coordinates = anchor.orElseGet(() -> {
            AbstractMode mode = !this.isExchanger ? GadgetBuilding.getToolMode(heldItem).getMode() : GadgetExchanger.getToolMode(heldItem).getMode();
            return mode.getCollection(new AbstractMode.UseContext(player.f_19853_, renderBlockState, lookingAt.m_82425_(), heldItem, lookingAt.m_82434_(), !this.isExchanger && GadgetBuilding.shouldPlaceAtop(heldItem), !this.isExchanger ? GadgetBuilding.getConnectedArea(heldItem) : GadgetExchanger.getConnectedArea(heldItem)), player);
        });
        BuildRender.getBuilderWorld().setWorldAndState(player.f_19853_, renderBlockState, coordinates);
        Vec3 playerPos = BuildRender.getMc().f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        PoseStack matrix = evt.getPoseStack();
        matrix.m_85836_();
        matrix.m_85837_(-playerPos.m_7096_(), -playerPos.m_7098_(), -playerPos.m_7094_());
        BlockRenderDispatcher dispatcher = BuildRender.getMc().m_91289_();
        for (BlockPos coordinate : coordinates) {
            matrix.m_85836_();
            matrix.m_85837_((double)coordinate.m_123341_(), (double)coordinate.m_123342_(), (double)coordinate.m_123343_());
            if (this.isExchanger) {
                matrix.m_85837_((double)-5.0E-4f, (double)-5.0E-4f, (double)-5.0E-4f);
                matrix.m_85841_(1.001f, 1.001f, 1.001f);
            }
            state = renderBlockState;
            OurRenderTypes.MultiplyAlphaRenderTypeBuffer mutatedBuffer = new OurRenderTypes.MultiplyAlphaRenderTypeBuffer((MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0.55f);
            try {
                dispatcher.renderSingleBlock(state, matrix, (MultiBufferSource)mutatedBuffer, 0xF00000, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            matrix.m_85849_();
            RenderSystem.m_69465_();
            buffer.m_109911_();
        }
        if (!player.m_7500_()) {
            boolean hasLinkedInventory = BuildRender.getCacheInventory().maintainCache(heldItem);
            int remainingCached = BuildRender.getCacheInventory().getCache() == null ? -1 : BuildRender.getCacheInventory().getCache().count((Object)new UniqueItem(data.getState().m_60734_().m_5456_()));
            RecordingItemIndex index = new RecordingItemIndex(InventoryHelper.index(heldItem, player));
            BuildContext context = new BuildContext((LevelAccessor)player.f_19853_, player, heldItem);
            MaterialList materials = data.getRequiredItems(context, null, null);
            int hasEnergy = this.getEnergy(player, heldItem);
            LazyOptional energyCap = heldItem.getCapability(CapabilityEnergy.ENERGY);
            for (BlockPos coordinate : coordinates) {
                boolean renderFree = false;
                if (energyCap.isPresent()) {
                    hasEnergy -= ((AbstractGadget)heldItem.m_41720_()).getEnergyCost(heldItem);
                }
                VertexConsumer builder = buffer.m_6299_(OurRenderTypes.MissingBlockOverlay);
                MatchResult match = index.tryMatch(materials);
                if (!match.isSuccess()) {
                    match = index.tryMatch(InventoryHelper.PASTE_LIST);
                }
                if (!match.isSuccess() || hasEnergy < 0) {
                    if (hasLinkedInventory && remainingCached > 0) {
                        renderFree = true;
                        --remainingCached;
                    } else {
                        BuildRender.renderMissingBlock(matrix.m_85850_().m_85861_(), builder, coordinate);
                    }
                } else {
                    index.applyMatch(match);
                    BuildRender.renderBoxSolid(matrix.m_85850_().m_85861_(), builder, coordinate, 0.97f, 1.0f, 0.99f, 0.1f);
                }
                if (!renderFree) continue;
                BuildRender.renderBoxSolid(matrix.m_85850_().m_85861_(), builder, coordinate, 0.97f, 1.0f, 0.99f, 0.1f);
            }
        }
        matrix.m_85849_();
        RenderSystem.m_69465_();
        buffer.m_109911_();
    }

    @Override
    public boolean isLinkable() {
        return true;
    }
}

