/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.turtle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.lib.peripherals.IBasePeripheral;
import de.srendi.advancedperipherals.lib.turtle.PeripheralTurtleUpgrade;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClockwiseAnimatedTurtleUpgrade<T extends IBasePeripheral<?>>
extends PeripheralTurtleUpgrade<T> {
    public ClockwiseAnimatedTurtleUpgrade(ResourceLocation id, String adjective, ItemStack item) {
        super(id, adjective, item);
    }

    public ClockwiseAnimatedTurtleUpgrade(ResourceLocation id, ItemStack item) {
        super(id, item);
    }

    @Override
    @NotNull
    public TransformedModel getModel(@Nullable ITurtleAccess turtle, @NotNull TurtleSide side) {
        if (this.getLeftModel() == null) {
            PoseStack stack = new PoseStack();
            stack.m_85836_();
            stack.m_85837_(0.0, 0.5, 0.5);
            if (turtle != null) {
                int rotationStep = DataStorageUtil.RotationCharge.get(turtle, side);
                stack.m_85845_(Vector3f.f_122222_.m_122240_((float)(-10 * rotationStep)));
            }
            stack.m_85837_(0.0, -0.5, -0.5);
            stack.m_85845_(Vector3f.f_122224_.m_122240_(90.0f));
            if (side == TurtleSide.LEFT) {
                stack.m_85837_(0.0, 0.0, -0.6);
            } else {
                stack.m_85837_(0.0, 0.0, -1.4);
            }
            return TransformedModel.of((ItemStack)this.getCraftingItem(), (Transformation)new Transformation(stack.m_85850_().m_85861_()));
        }
        return TransformedModel.of((ModelResourceLocation)(side == TurtleSide.LEFT ? this.getLeftModel() : this.getRightModel()));
    }

    public void chargeConsumingCallback() {
    }

    public void update(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        super.update(turtle, side);
        if (this.tick % 2 == 0 && DataStorageUtil.RotationCharge.consume(turtle, side)) {
            this.chargeConsumingCallback();
        }
    }
}

