/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;

public class DataStorageUtil {
    public static CompoundTag getDataStorage(@Nonnull ITurtleAccess access, @Nonnull TurtleSide side) {
        return access.getUpgradeNBTData(side);
    }

    public static CompoundTag getDataStorage(@Nonnull IPeripheralTileEntity tileEntity) {
        return tileEntity.getPeripheralSettings();
    }

    public static CompoundTag getDataStorage(@Nonnull IPocketAccess pocket) {
        return pocket.getUpgradeNBTData();
    }

    public static class RotationCharge {
        public static final int ROTATION_STEPS = 36;
        private static final String ROTATION_CHARGE_SETTING = "rotationCharge";

        public static int get(@Nonnull ITurtleAccess access, @Nonnull TurtleSide side) {
            return DataStorageUtil.getDataStorage(access, side).m_128451_(ROTATION_CHARGE_SETTING);
        }

        public static boolean consume(@Nonnull ITurtleAccess access, @Nonnull TurtleSide side) {
            CompoundTag data = DataStorageUtil.getDataStorage(access, side);
            int currentCharge = data.m_128451_(ROTATION_CHARGE_SETTING);
            if (currentCharge > 0) {
                data.m_128405_(ROTATION_CHARGE_SETTING, Math.max(0, data.m_128451_(ROTATION_CHARGE_SETTING) - 1));
                access.updateUpgradeNBTData(side);
                return true;
            }
            return false;
        }

        public static void addCycles(IPeripheralOwner owner, int count) {
            CompoundTag data = owner.getDataStorage();
            data.m_128405_(ROTATION_CHARGE_SETTING, Math.max(0, data.m_128451_(ROTATION_CHARGE_SETTING)) + count * 36);
            owner.markDataStorageDirty();
        }
    }
}

