/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.items;

import com.mojang.blaze3d.platform.InputConstants;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.client.HudOverlayHandler;
import de.srendi.advancedperipherals.common.addons.curios.CuriosHelper;
import de.srendi.advancedperipherals.common.blocks.blockentities.ARControllerEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.setup.Blocks;
import de.srendi.advancedperipherals.common.util.EnumColor;
import de.srendi.advancedperipherals.common.util.SideHelper;
import de.srendi.advancedperipherals.network.MNetwork;
import de.srendi.advancedperipherals.network.messages.RequestHudCanvasMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class ARGogglesItem
extends ArmorItem {
    private static final String CONTROLLER_POS = "controller_pos";
    private static final String CONTROLLER_LEVEL = "controller_level";

    public ARGogglesItem() {
        super((ArmorMaterial)ArmorMaterials.LEATHER, EquipmentSlot.HEAD, new Item.Properties().m_41491_(AdvancedPeripherals.TAB).m_41487_(1));
    }

    public static void clientTick(LocalPlayer player, ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(CONTROLLER_POS) && stack.m_41783_().m_128441_(CONTROLLER_LEVEL)) {
            Level level;
            int[] arr = stack.m_41783_().m_128465_(CONTROLLER_POS);
            if (arr.length < 3) {
                return;
            }
            BlockPos pos = new BlockPos(arr[0], arr[1], arr[2]);
            String dimensionKey = stack.m_41783_().m_128461_(CONTROLLER_LEVEL);
            if (!dimensionKey.equals((level = player.f_19853_).m_46472_().toString())) {
                MNetwork.sendToServer(new RequestHudCanvasMessage(pos, dimensionKey));
                return;
            }
            BlockEntity te = level.m_7702_(pos);
            if (!(te instanceof ARControllerEntity)) {
                MNetwork.sendToServer(new RequestHudCanvasMessage(pos, dimensionKey));
                return;
            }
            ARControllerEntity controller = (ARControllerEntity)te;
            HudOverlayHandler.updateCanvas(controller.getCanvas());
        }
    }

    public Component m_41466_() {
        return new TranslatableComponent("item.advancedperipherals.tooltip.ar_goggles");
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, levelIn, tooltip, flagIn);
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341)) {
            tooltip.add(EnumColor.buildTextComponent((Component)new TranslatableComponent("item.advancedperipherals.tooltip.show_desc")));
        } else {
            tooltip.add(EnumColor.buildTextComponent(this.m_41466_()));
        }
        if (!((Boolean)APConfig.PERIPHERALS_CONFIG.enableARGoggles.get()).booleanValue()) {
            tooltip.add(EnumColor.buildTextComponent((Component)new TranslatableComponent("item.advancedperipherals.tooltip.disabled")));
        }
        if (stack.m_41782_() && stack.m_41783_().m_128425_(CONTROLLER_POS, 11)) {
            int[] pos = stack.m_41783_().m_128465_(CONTROLLER_POS);
            tooltip.add((Component)new TranslatableComponent("item.advancedperipherals.tooltip.ar_goggles.binding", new Object[]{pos[0], pos[1], pos[2]}));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!AdvancedPeripherals.isCuriosLoaded()) {
            return null;
        }
        return CuriosHelper.createARGogglesProvider(stack);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "advancedperipherals:textures/models/ar_goggles.png";
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!SideHelper.isClientPlayer((LivingEntity)player)) {
            return;
        }
        ARGogglesItem.clientTick((LocalPlayer)player, stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        if (!level.m_8055_(blockpos).m_60713_((Block)Blocks.AR_CONTROLLER.get())) {
            return super.m_6225_(context);
        }
        BlockEntity entity = level.m_7702_(blockpos);
        if (!(entity instanceof ARControllerEntity)) {
            return super.m_6225_(context);
        }
        ARControllerEntity controller = (ARControllerEntity)entity;
        if (!context.m_43725_().f_46443_) {
            ItemStack item = context.m_43722_();
            if (!item.m_41782_()) {
                item.m_41751_(new CompoundTag());
            }
            CompoundTag nbt = item.m_41783_();
            BlockPos pos = controller.m_58899_();
            nbt.m_128385_(CONTROLLER_POS, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
            nbt.m_128359_(CONTROLLER_LEVEL, controller.m_58904_().m_46472_().toString());
            item.m_41751_(nbt);
        }
        context.m_43723_().m_5661_((Component)new TranslatableComponent("text.advancedperipherals.linked_goggles"), true);
        return InteractionResult.SUCCESS;
    }
}

