/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.blockentities;

import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.ARControllerPeripheral;
import de.srendi.advancedperipherals.common.argoggles.ARRenderAction;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.setup.BlockEntityTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ARControllerEntity
extends PeripheralBlockEntity<ARControllerPeripheral> {
    private static final String CANVAS = "canvas";
    private static final String VIRTUAL_SCREEN_SIZE = "virtual_screen_size";
    private final List<ARRenderAction> canvas = new ArrayList<ARRenderAction>();
    private Optional<int[]> virtualScreenSize = Optional.empty();

    public ARControllerEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.AR_CONTROLLER.get(), pos, state);
    }

    public void addToCanvas(ARRenderAction action) {
        if (this.canvas.contains(action)) {
            return;
        }
        if (action.getId() != null) {
            this.canvas.removeIf(old -> action.getId().equals(old.getId()));
        }
        this.canvas.add(action);
        this.blockChanged();
    }

    public void clearCanvas() {
        this.canvas.clear();
        this.blockChanged();
    }

    public void clearElement(String id) {
        this.canvas.removeIf(old -> id.equals(old.getId()));
        this.blockChanged();
    }

    @Override
    @NotNull
    protected ARControllerPeripheral createPeripheral() {
        return new ARControllerPeripheral(this);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.deserializeNBT(nbt);
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.virtualScreenSize = nbt.m_128465_(VIRTUAL_SCREEN_SIZE).length > 0 ? Optional.of(nbt.m_128465_(VIRTUAL_SCREEN_SIZE)) : Optional.empty();
        ListTag list = nbt.m_128437_(CANVAS, 10);
        this.canvas.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag c = list.m_128728_(i);
            ARRenderAction action = new ARRenderAction();
            action.deserializeNBT(c);
            this.canvas.add(action);
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        if (this.virtualScreenSize.isPresent()) {
            compound.m_128385_(VIRTUAL_SCREEN_SIZE, this.virtualScreenSize.get());
        } else if (compound.m_128441_(VIRTUAL_SCREEN_SIZE)) {
            compound.m_128473_(VIRTUAL_SCREEN_SIZE);
        }
        ListTag list = new ListTag();
        for (ARRenderAction action : new ArrayList<ARRenderAction>(this.canvas)) {
            list.add((Object)action.serializeNBT());
        }
        compound.m_128365_(CANVAS, (Tag)list);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.deserializeNBT(tag);
        super.handleUpdateTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        this.deserializeNBT(nbt);
    }

    public boolean isRelativeMode() {
        return this.virtualScreenSize.isPresent();
    }

    public int[] getVirtualScreenSize() {
        return this.virtualScreenSize.orElse(null);
    }

    public void setRelativeMode(int virtualScreenWidth, int virtualScreenHeight) {
        this.virtualScreenSize = Optional.of(new int[]{virtualScreenWidth, virtualScreenHeight});
        this.blockChanged();
    }

    public void disableRelativeMode() {
        this.virtualScreenSize = Optional.empty();
        this.blockChanged();
    }

    private void blockChanged() {
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public List<ARRenderAction> getCanvas() {
        ArrayList<ARRenderAction> list = new ArrayList<ARRenderAction>();
        for (ARRenderAction a : this.canvas) {
            ARRenderAction action = a.copyWithVirtualScreenSize(this.virtualScreenSize);
            list.add(action);
        }
        return list;
    }

    @Override
    public void markSettingsChanged() {
    }
}

