/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.blockentities.InventoryManagerEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.InventoryUtil;
import de.srendi.advancedperipherals.common.util.ItemUtil;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class InventoryManagerPeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<InventoryManagerEntity>> {
    public static final String TYPE = "inventoryManager";

    public InventoryManagerPeripheral(InventoryManagerEntity tileEntity) {
        super(TYPE, new BlockEntityPeripheralOwner<InventoryManagerEntity>(tileEntity));
    }

    private static int getArmorSlot(int index) {
        return switch (index) {
            case 103 -> 3;
            case 102 -> 2;
            case 101 -> 1;
            default -> 0;
        };
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableInventoryManager.get();
    }

    @LuaFunction
    public final String getOwner() throws LuaException {
        if (((BlockEntityPeripheralOwner)this.owner).getOwner() == null) {
            return null;
        }
        return this.getOwnerPlayer().m_7755_().getString();
    }

    @LuaFunction(mainThread=true, value={"pullItems", "addItemToPlayer"})
    public final int addItemToPlayer(String invDirection, int count, Optional<Integer> slot, Optional<String> item) throws LuaException {
        ItemStack stack = ItemStack.f_41583_;
        if (item.isPresent()) {
            Item item1 = (Item)ItemUtil.getRegistryEntry(item.get(), ForgeRegistries.ITEMS);
            stack = new ItemStack((ItemLike)item1, count);
        }
        return this.addItemCommon(invDirection, count, slot, stack);
    }

    @LuaFunction(mainThread=true)
    public final int addItemToPlayerNBT(String invDirection, int count, Optional<Integer> slot, Optional<Map<?, ?>> item) throws LuaException {
        ItemStack stack = ItemStack.f_41583_;
        if (item.isPresent()) {
            Direction direction = this.validateSide(invDirection);
            BlockEntity targetEntity = ((BlockEntityPeripheralOwner)this.owner).getLevel().m_7702_(((BlockEntityPeripheralOwner)this.owner).getPos().m_142300_(direction));
            IItemHandler inventoryFrom = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).resolve().orElse(null) : null;
            stack = ItemUtil.getItemStackRS(item.get(), ItemUtil.getItemsFromItemHandler(inventoryFrom));
        }
        return this.addItemCommon(invDirection, count, slot, stack);
    }

    private int addItemCommon(String invDirection, int count, Optional<Integer> slot, ItemStack stack) throws LuaException {
        Direction direction = this.validateSide(invDirection);
        BlockEntity targetEntity = ((BlockEntityPeripheralOwner)this.owner).getLevel().m_7702_(((BlockEntityPeripheralOwner)this.owner).getPos().m_142300_(direction));
        IItemHandler inventoryFrom = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).resolve().orElse(null) : null;
        PlayerInvWrapper inventoryTo = new PlayerInvWrapper(this.getOwnerPlayer().m_150109_());
        int invSlot = slot.orElse(0);
        if (inventoryFrom == null) {
            return 0;
        }
        int amount = count;
        int transferableAmount = 0;
        for (int i = 0; i < inventoryFrom.getSlots() && amount > 0; ++i) {
            if (stack.m_41619_() && (stack = inventoryFrom.getStackInSlot(i).m_41777_()).m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)inventoryFrom.getStackInSlot(i))) continue;
            if (invSlot >= 100 && invSlot < 104) {
                if (!(stack.m_41720_() instanceof ArmorItem)) {
                    throw new LuaException(stack + "is not an armor item. Can't put it into the slot " + invSlot);
                }
                if (!((ItemStack)this.getOwnerPlayer().m_150109_().f_35975_.get(InventoryManagerPeripheral.getArmorSlot(invSlot))).m_41619_()) continue;
                this.getOwnerPlayer().m_150109_().f_35975_.set(InventoryManagerPeripheral.getArmorSlot(invSlot), (Object)stack);
                inventoryFrom.extractItem(i, 1, false);
                transferableAmount = 1;
                continue;
            }
            int inserted = InventoryUtil.moveItem(inventoryFrom, i, (IItemHandler)inventoryTo, invSlot, amount);
            transferableAmount += inserted;
            amount -= inserted;
            inserted = InventoryUtil.moveItem(inventoryFrom, i, (IItemHandler)inventoryTo, -1, amount);
            transferableAmount += inserted;
            amount -= inserted;
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true, value={"pushItems", "removeItemFromPlayer"})
    public final int removeItemFromPlayer(String invDirection, int count, Optional<Integer> slot, Optional<String> item) throws LuaException {
        ItemStack stack = ItemStack.f_41583_;
        if (item.isPresent()) {
            Item item1 = (Item)ItemUtil.getRegistryEntry(item.get(), ForgeRegistries.ITEMS);
            stack = new ItemStack((ItemLike)item1, count);
        }
        return this.removeItemCommon(invDirection, count, slot, stack);
    }

    @LuaFunction(mainThread=true)
    public final int removeItemFromPlayerNBT(String invDirection, int count, Optional<Integer> slot, Optional<Map<?, ?>> item) throws LuaException {
        ItemStack stack = ItemStack.f_41583_;
        if (item.isPresent()) {
            Direction direction = this.validateSide(invDirection);
            BlockEntity targetEntity = ((BlockEntityPeripheralOwner)this.owner).getLevel().m_7702_(((BlockEntityPeripheralOwner)this.owner).getPos().m_142300_(direction));
            IItemHandler inventoryFrom = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).resolve().orElse(null) : null;
            stack = ItemUtil.getItemStackRS(item.get(), ItemUtil.getItemsFromItemHandler(inventoryFrom));
        }
        return this.removeItemCommon(invDirection, count, slot, stack);
    }

    private int removeItemCommon(String invDirection, int count, Optional<Integer> slot, ItemStack stack) throws LuaException {
        IItemHandler inventoryTo;
        int invSlot = -1;
        if (slot.isPresent() && slot.get() > 0) {
            invSlot = slot.get();
        }
        Direction direction = this.validateSide(invDirection);
        BlockEntity targetEntity = ((BlockEntityPeripheralOwner)this.owner).getLevel().m_7702_(((BlockEntityPeripheralOwner)this.owner).getPos().m_142300_(direction));
        Inventory inventoryFrom = this.getOwnerPlayer().m_150109_();
        IItemHandler iItemHandler = inventoryTo = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).resolve().orElse(null) : null;
        if (inventoryTo == null) {
            return 0;
        }
        int amount = count;
        int transferableAmount = 0;
        ItemStack rest = ItemStack.f_41583_;
        if (invSlot == -1) {
            for (int i = 0; i < inventoryFrom.m_6643_(); ++i) {
                int subCount;
                if (!stack.m_41619_() && inventoryFrom.m_8020_(i).m_41656_(stack)) {
                    if (inventoryFrom.m_8020_(i).m_41613_() >= amount) {
                        rest = this.insertItem(inventoryTo, inventoryFrom.m_7407_(i, amount));
                        transferableAmount += amount - rest.m_41613_();
                        break;
                    }
                    subCount = inventoryFrom.m_8020_(i).m_41613_();
                    rest = this.insertItem(inventoryTo, inventoryFrom.m_7407_(i, subCount));
                    amount -= subCount;
                    transferableAmount += subCount - rest.m_41613_();
                    if (!rest.m_41619_()) break;
                }
                if (stack.m_41619_() && inventoryFrom.m_8020_(i).m_41613_() >= amount) {
                    rest = this.insertItem(inventoryTo, inventoryFrom.m_7407_(i, amount));
                    transferableAmount += amount - rest.m_41613_();
                    break;
                }
                subCount = inventoryFrom.m_8020_(i).m_41613_();
                rest = this.insertItem(inventoryTo, inventoryFrom.m_7407_(i, subCount));
                amount -= subCount;
                transferableAmount += subCount - rest.m_41613_();
                if (!rest.m_41619_()) break;
            }
        }
        if (invSlot != -1) {
            int subCount;
            if (!stack.m_41619_() && inventoryFrom.m_8020_(slot.get().intValue()).m_41656_(stack)) {
                if (inventoryFrom.m_8020_(slot.get().intValue()).m_41613_() >= amount) {
                    rest = this.insertItem(inventoryTo, inventoryFrom.m_7407_(slot.get().intValue(), amount));
                    transferableAmount += amount - rest.m_41613_();
                } else {
                    subCount = inventoryFrom.m_8020_(slot.get().intValue()).m_41613_();
                    rest = this.insertItem(inventoryTo, inventoryFrom.m_7407_(slot.get().intValue(), subCount));
                    transferableAmount += subCount - rest.m_41613_();
                }
            }
            if (stack.m_41619_() && inventoryFrom.m_8020_(slot.get().intValue()).m_41613_() >= amount) {
                rest = this.insertItem(inventoryTo, inventoryFrom.m_7407_(slot.get().intValue(), amount));
                transferableAmount += amount - rest.m_41613_();
            } else {
                subCount = inventoryFrom.m_8020_(slot.get().intValue()).m_41613_();
                rest = this.insertItem(inventoryTo, inventoryFrom.m_7407_(slot.get().intValue(), subCount));
                transferableAmount += subCount - rest.m_41613_();
            }
        }
        if (!rest.m_41619_()) {
            inventoryFrom.m_36054_(rest);
        }
        return transferableAmount;
    }

    @Nonnull
    @LuaFunction(value={"list", "getItems"}, mainThread=true)
    public final Map<Integer, Object> getItems() throws LuaException {
        HashMap<Integer, Object> items = new HashMap<Integer, Object>();
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().m_150109_().f_35974_) {
            if (!stack.m_41619_()) {
                items.put(i, LuaConverter.stackToObject(stack));
            }
            ++i;
        }
        return items;
    }

    @LuaFunction(mainThread=true)
    public final Map<Integer, Object> getArmor() throws LuaException {
        HashMap<Integer, Object> items = new HashMap<Integer, Object>();
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().m_150109_().f_35975_) {
            if (!stack.m_41619_()) {
                items.put(ArmorSlot.getSlotForItem(stack), LuaConverter.stackToObject(stack));
            }
            ++i;
        }
        return items;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerEquipped() throws LuaException {
        for (ItemStack stack : this.getOwnerPlayer().m_150109_().f_35975_) {
            if (stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isWearing(int index) throws LuaException {
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().m_150109_().f_35975_) {
            if (stack.m_41619_()) continue;
            if (index == i) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final int getEmptySpace() throws LuaException {
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().m_150109_().f_35974_) {
            if (!stack.m_41619_()) continue;
            ++i;
        }
        return i;
    }

    @LuaFunction(mainThread=true)
    public final boolean isSpaceAvailable() throws LuaException {
        return this.getEmptySpace() > 0;
    }

    @LuaFunction(mainThread=true)
    public final int getFreeSlot() throws LuaException {
        return this.getOwnerPlayer().m_150109_().m_36062_();
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getItemInHand() throws LuaException {
        return LuaConverter.stackToObject(this.getOwnerPlayer().m_21205_());
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getItemInOffHand() throws LuaException {
        return LuaConverter.stackToObject(this.getOwnerPlayer().m_21206_());
    }

    private ItemStack insertItem(IItemHandler inventoryTo, ItemStack stack) {
        for (int i = 0; i < inventoryTo.getSlots() && !stack.m_41619_(); ++i) {
            if (!stack.m_41782_()) {
                stack.m_41751_(null);
            }
            stack = inventoryTo.insertItem(i, stack, false);
        }
        return stack;
    }

    private Player getOwnerPlayer() throws LuaException {
        if (((BlockEntityPeripheralOwner)this.owner).getOwner() == null) {
            throw new LuaException("The Inventory Manager doesn't have a memory card or it isn't bound to a player.");
        }
        return ((BlockEntityPeripheralOwner)this.owner).getOwner();
    }

    private static enum ArmorSlot {
        HELMET_SLOT(103, EquipmentSlot.HEAD),
        CHEST_SLOT(102, EquipmentSlot.CHEST),
        LEGGINGS_SLOT(101, EquipmentSlot.LEGS),
        BOOTS_SLOT(100, EquipmentSlot.FEET);

        private final int slot;
        private final EquipmentSlot slotType;

        private ArmorSlot(int slot, EquipmentSlot slotType) {
            this.slot = slot;
            this.slotType = slotType;
        }

        public static int getSlotForItem(ItemStack stack) {
            ArmorSlot[] armorSlotArray = stack.m_41720_();
            if (armorSlotArray instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)armorSlotArray;
                for (ArmorSlot slot : ArmorSlot.values()) {
                    if (armorItem.m_40402_() != slot.slotType) continue;
                    return slot.slot;
                }
            }
            AdvancedPeripherals.LOGGER.warn("Tried to get armor item slot for non armor item " + stack + ". Returning 0");
            return 0;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

